#
# Figury geometryczne
#
from math import sqrt 

class Figure:
	counter = 0
	def __init__(self, *args):
		self.sides = []
		for em in args:
			if em <=0:
				raise ValueError('All sides should be positive')
			self.sides.append(em)
		Figure.counter += 1

	def circumference(self):
		return sum(self.sides)

	def __repr__(self):
		return  f'Figure({self.args})'


class Triangle(Figure):
	def __init__(self, *args):
		if len(args) != 3:
			raise ValueError('Triangle constructor needs 3 side lengths!')
		super().__init__(*args)
	
	def area(self):
		p = sum(self.sides)/2 
		return sqrt(p*(p-self.sides[0])*(p-self.sides[1])*(p-self.sides[2]))

	def __repr__(self):
		return f'Triangle({self.sides})'


class Rectangle(Figure):
	def __init__(self, *args):
		if len(args) != 2:
			raise ValueError('Rectangle constructor needs 2 side lengths!')
		super().__init__(*args, *args)

	def area(self):
		return self.sides[0] * self.sides[1]

	def __repr__(self):
		return f'Rectangle({self.sides})'


class Square(Rectangle):
	def __init__(self, *args):
		if len(args) != 1:
			raise ValueError('Square constructor needs 1 side length!')
		super().__init__( *args, *args,)

	def __repr__(self):
		return f'Square({self.sides})'


if __name__ == '__main__':
	tr = Triangle(3, 4, 5)
	print(tr)
	print('Triangle circ.: {}'.format(tr.circumference()))
	print('Triangle area: {}'.format(tr.area()))
	print()
	
	re = Rectangle(3, 4)
	print(re)
	print('Rectangle circ.: {}'.format(re.circumference()))
	print('Rectangle area: {}'.format(re.area()))
	print()

	sq = Square(3)
	print(sq)
	print('Square circ.: {}'.format(sq.circumference()))
	print('Square area: {}'.format(sq.area()))
	print()

	print("Number of objects: {}".format(Figure.counter))




