#
# Liczby calkowite modulo 17
#

class Rest:
	def __init__(self, val=0):
		self.rest = val%17
	def __add__(self, other):
		val = (self.rest + other.rest) % 17
		return Rest(val)
	def __mul__(self, other):
		val = (self.rest * other.rest) % 17
		return Rest(val)
	def __iadd__(self, other):
		val = (self.rest + other.rest) % 17
		self.rest = val
		return self
	def __imul__(self, other):
		val = (self.rest * other.rest) % 17
		self.rest = val
		return self
	def __str__(self):
		return str(self.rest)
	def __repr__(self):
		return "Rest({})".format(self.rest)

if __name__ == '__main__':
	numbers = []
	val1 = -1
	val2 = -1

	while val1<0 or val1>16:
		print(f"Proszę podać pierwszą liczbę z przedziału [0, 16]")
		val1 = int(input())
	while val2<0 or val2>16:
		print(f"Proszę podać drugą liczbę z przedziału [0, 16]")
		val2 = int(input())
	r1 = Rest(val1)
	r2 = Rest(val2)
	rsum = Rest(r1.rest) # we make a DEEP copy instead of a shallow one
	rsum += r2
	rmul = Rest(r2.rest)  # we make a DEEP copy instead of a shallow one
	rmul *= r1
	print("{} + {} % 17 = {}".format(r1, r2, r1+r2 ))
	print("{} + {} % 17 = {}".format(r1, r2, rsum ))
	print("{} * {} % 17 = {}".format(r1, r2, r1*r2 ))
	print("{} * {} % 17 = {}".format(r1, r2, rmul ))