#
# Liczby wymierne
#
# from math import abs 

def NWD(a, b):
	a = abs(a)
	b = abs(b)
	if a != b:
		if a > b:
			return NWD(a - b, b)
		else:
			return NWD(a, b - a)
	return a


class RationalNumber:
	def __init__(self, *args):
		if len(args) == 0:
			self._q = 1
			self._p = 0
		elif len(args) == 1:
			if isinstance(args[0], str):
				if args[0].count('/') == 1:
					p,q = args[0].split('/')
					self._p = int(p)
					self._q = int(q)
					if self._q < 0:
						 self._q *= -1
						 self._p *= -1
					elif self._q == 0:
						raise ValueError("q cannot be 0")
				else:
					self._q = 1
					self._p = int(args[0])
			else:
				self._q = 1
				self._p = args[0]
		elif len(args) == 2:
			q = args[0]
			p = args[1]
			if q == 0:
				raise ValueError("q cannot be 0")
			elif q<0:
				q *= -1
				p *= -1
			self._q = q
			self._p = p
		else:
			raise ValueError("Too many arguments passed to constructor of RationalNumber. Expected 0, 1 or 2.")
		nwd = NWD(self._q, self._p)
		self._p //= nwd
		self._q //= nwd

	def numerator(self):
		return self._p 

	def denominator(self):
		return self._q

	def __float__(self):
		return self._p / self._q

	def __neg__(self):
		if self._q < 0:
			return RationalNumber(-1*self._q, self._p)
		else:
			return RationalNumber(self._q, -1*self._p)
		return self

	def __lt__(self, other):
		val1 = float(self)
		val2 = float(other)
		if val1 < val2:
			return True
		else:
			return False

	def __add__(self, other):
		pnew = self._p*abs(other.denominator()) + other.numerator()*abs(self._q)
		qnew = abs(self._q * other.denominator())
		nwd = NWD(qnew, pnew)
		pnew //= nwd
		qnew //= nwd
		return RationalNumber(qnew, pnew)

	def __mul__(self, other):
		pnew = self._p * other.numerator()
		qnew = self._q * other.denominator()
		nwd = NWD(qnew, pnew)
		pnew //= nwd
		qnew //= nwd
		return RationalNumber(qnew, pnew)

	def __iadd__(self, other):
		pnew = self._p*abs(other.denominator()) + other.numerator()*abs(self._q)
		qnew = abs(self._q * other.denominator())
		nwd = NWD(qnew, pnew)
		pnew //= nwd
		qnew //= nwd
		self._p = pnew
		self._q = qnew
		return self

	def __mul__(self, other):
		pnew = self._p * other.numerator()
		qnew = self._q * other.denominator()
		nwd = NWD(qnew, pnew)
		pnew //= nwd
		qnew //= nwd
		self._p = pnew
		self._q = qnew
		return self

	def __eq__(self, other):
		if self._p == other.numerator() and self._q == other.denominator():
			return True
		else:
			return False

	def __repr__(self):
		return "RationalNumber({}, {})".format(self._q, self._p)

	def __str__(self):
		return "{}/{}".format(int(self._p), int(self._q))

if __name__ == '__main__':
	print('Proszę podać dwie liczby wymierne oddzielone spacją')
	num = input()
	w1, w2 = num.strip().split()
	r1 = RationalNumber(w1)
	r2 = RationalNumber(w2)
	print('Podane liczby w postaci dziesiętnej')
	print(f'{float(r1)} {float(r2)}')
	print('Liczby przeciwne do danych')
	print(f'{-r1} {-r2}')
	print('Liczby w kolejności niemalejącej')
	if r1 < r2:
		print(f'{r1} {r2}')
	else:
		print(f'{r2} {r1}')
	print('Suma liczb')
	print(r1+r2)
	print('Iloczyn liczb')
	print(r1*r2)



