#
# Relatywistyczne składanie predkosci	
#
from math import sqrt, inf 
import sys

class Velocity:
	def __init__(self, beta=0):
		if beta>1:
			raise ValueError('Velocity should not exceed the speed of light!')
		self.beta = beta
	def gamma(self):
		if self.beta == 1:
			return inf
		else:
			return 1.0/sqrt(1-self.beta*self.beta)
	def __add__(self, other):
		nbeta = (self.beta + other.beta)/(1+self.beta*other.beta)
		return Velocity(nbeta)
	def __iadd__(self, other):
		nbeta = (self.beta + other.beta)/(1+self.beta*other.beta)
		self.beta = nbeta
		return self
	def __str__(self):
		return str(self.beta) 
	def __repr__(self):
		return "Velocity({})".format(self.beta)

if __name__ == '__main__':
	print("Please provide the first velocity in units of c")
	beta1 = Velocity(float(input()))
	print("Please provide the second velocity in units of c")
	beta2 = Velocity(float(input()))
	nbeta = beta1
	nbeta += beta2
	print('beta = {}'.format(nbeta))
	print('gamma = {}'.format(nbeta.gamma()))