#
# Diamond inheritance
#

class Parent:
	def __init__(self, name, surname, votes=True):
		self._name = name 
		self._surname = surname 
		self._votes = votes
	def hello(self):
		return "Hi! I am a parent!"

class ChildA(Parent):
	def __init__(self, **kwargs):
		super().__init__(**kwargs)
		self._votes = True
	def hello(self):
		return "Hi! I am a child A!"

class ChildB(Parent):
	def __init__(self, **kwargs):
		super().__init__(**kwargs)
		self._votes = False
	def hello(self):
		return "Hi! I am a child B!"

class GrandChild(ChildB, ChildA):
	def __init__(self, **kwargs):
		super().__init__(**kwargs)
	def hello(self):
		return "Hi! I am a grandchild!"

if __name__ == '__main__':
	print('__mro__')
	print(GrandChild.__mro__)
	print()

	g = GrandChild( name="Jan", surname="Kowalski" )

	print(g.hello())
	print(g._votes)
