#
# Implementujemy listę za pomocą iteratorów
#

class Node:
	def __init__(self, item):
		self.item = item
		self.next = None
	def get_data(self):
		return self.item
	def set_next(self, node):
		self.next = node
	def get_next(self):
		return self.next

class LinkedListIterator:
    def __init__(self, head):
        self.current = head

    def __iter__(self):
        return self

    def __next__(self):
        if not self.current:
            raise StopIteration
        else:
            item = self.current.get_data()
            self.current = self.current.get_next()
            return item

class LinkedList:
    def __init__(self):
        self.head = None

    def __iter__(self):
        return LinkedListIterator(self.head)

    def add(self, item): 
        new_node = Node(item)
        new_node.set_next(self.head)
        self.head = new_node

    
if __name__ == '__main__':
    test_list = LinkedList()
    test_list.add(1)
    test_list.add(2)
    test_list.add(3)
    for item in test_list:
        print(item)