#
# sequences
#

class Sequence:
	def __init__(self):
		self._terms = []
		self._curr = 0
	def addElement(self, value):
		self._terms.append(value)
	def sum(self, n):
		if n<0:
			raise ValueError("n should be >= 0!")
		elif n == 0:
			return 0.0
		else:
			return sum(self._terms[:n-1])
	def __getitem__(self, key):
		return self._terms[key]
	def __iter__(self):
		return self
	def __next__(self):
		if self._curr >= len(self._terms):
			raise StopIteration
		else:
			val = self._terms[self._curr]
			self._curr += 1
			return val


class Arithmetic(Sequence):
	def __init__(self, a0, delta):
		super().__init__()
		self._a0 = a0 
		self._delta = delta 
	def addElement(self):
		val = self._a0 + self._delta*len(self._terms)
		self._terms.append(val)


class Fibonacci(Sequence):
	def __init__(self):
		super().__init__()
		self._terms = [0, 1]
	def addElement(self):
		self._terms.append(self._terms[-1]+self._terms[-2])

if __name__ == '__main__':

	ar = Arithmetic(2,3)
	fb = Fibonacci()

	for ii in range(10):
		ar.addElement()
		fb.addElement()

	print('Arithmetic')
	for ii in range(10):
		print(ar[ii], end = ' ')
	print('\nFibonacci')
	for ii in range(10):
		print(next(fb), end = ' ')
	print()
