#
# Proxy design pattern
#

class Image:
   """ class for image loading and displaying """
   def __init__( self, filename ):
      self._filename = filename
   
   def load_image_from_disk( self ):
      print("loading " + self._filename )
      # here comes the code that loads image
   
   def display_image( self ):
      print("display " + self._filename)
      # here comes the code that actually displays the image

class Proxy:
   def __init__( self, subject ):
      self._subject = subject
      self._proxystate = None

class ProxyImage( Proxy ):
   def display_image( self ):
      if self._proxystate == None:
         self._subject.load_image_from_disk()
         self._proxystate = 1
      self._subject.display_image()

image1 = Image("HiRes_10Mb_Photo1")
image2 = Image("HiRes_10Mb_Photo2")

proxy_image1 = ProxyImage ( image1 )
proxy_image2 = ProxyImage ( image2 )

proxy_image1.display_image() # loading necessary
proxy_image1.display_image() # loading unnecessary
proxy_image2.display_image() # loading necessary
proxy_image2.display_image() # loading unnecessary
proxy_image1.display_image() # loading unnecessary