#
# Fabryka
#

class FrenchLocalizer:
	""" it simply returns the french version """

	def __init__(self):

		self.translations = {"car": "voiture", "bike": "bicyclette",
							"plane":"avion"}

	def localize(self, msg):

		"""change the message using translations"""
		return self.translations.get(msg, msg)

class SpanishLocalizer:
	"""it simply returns the spanish version"""

	def __init__(self):
		self.translations = {"car": "coche", "bike": "bicicleta",
							"plane":"avión"}

	def localize(self, msg):

		"""change the message using translations"""
		return self.translations.get(msg, msg)

class PolishLocalizer:
	"""it simply returns the polish version"""

	def __init__(self):
		self.translations = {"car": "samochód", "bike": "rower",
							"plane":"samolot"}

	def localize(self, msg):

		"""change the message using translations"""
		return self.translations.get(msg, msg)

class EnglishLocalizer:
	"""Simply return the same message"""

	def localize(self, msg):
		return msg

def Factory(language ="English"):

	"""Factory Method"""
	localizers = {
		"French": FrenchLocalizer,
		"English": EnglishLocalizer,
		"Spanish": SpanishLocalizer,
		"Polish": PolishLocalizer,
	}
	language = language.capitalize() 
	if not language in localizers.keys():
		print('Cannot find language: {}. Available languages are:'.format(language))
		for l in localizers.keys(): print(l, end=', ')
		print()
		exit(1)

	return localizers[language]()

if __name__ == "__main__":

	print("Please provide the language you want to translate to")
	lang = input()
	f = Factory(lang)
	print('Provide words to translate or type q+enter to quit')
	while True:
		print('Word to be translated:')
		inkey = input()
		if inkey == 'q': break
		print('{}\t->\t{}'.format(inkey, f.localize(inkey)))


