#
# rysujemy funkcje trygonometryczne na jednym obrazku
#

import math
import matplotlib.pyplot as plt

def gfrange(a,b,d):
	numbers = []
	if a>=b:
		print('Wrong numbers, a>=b!')
		exit(1)
	elif d<=0:
		print('Wrong d, it has to be positive!')
		exit(1)
	else:
		while a < b:
			numbers.append(a)
			a += d 
		return numbers

def trigplot():
	x = gfrange(-1, 1, 0.1)
	fig = plt.figure()
	for f, l in zip( ( lambda x : x, math.sin, math.tan), ('y=x', 'y=sin(x)', 'y=tan(x)') ):
		y = [ f(em) for em in x ]
		plt.plot(x,y, label=l)
	plt.title(r'Wykres różnych funkcji')
	plt.xlabel('x')
	plt.ylabel('y')
	plt.legend()
	plt.show()
	print('Proszę wybrać format do zapisu: png, jpg, svg lub pdf')
	form = input()
	if form in ('png', 'jpg', 'svg', 'pdf'):
		fig.savefig('trigplot.' + form)
	else:
		print('Unregonised format! Exiting!')
		exit(1)

if __name__ == '__main__':
	trigplot()