#
# Całkowanie metodą prostokątów
#

from math import sin, sqrt

def kwadrat(x):
	return x*x+6*x+1 

def calka(f, x1, x2, n=3):
	"""
	Całkujemy metodą prostokątów.
	Argumenty:
	f -- funkcja matematyczna do scałkowania (jednej zmiennej rzeczywistej)
	x1 -- początek przedziału całkowania
	x2 -- koniec przedziału całkowania
	n -- liczba przedziałów całkowania (domyślnie 3)
	"""

	integral = 0.0
	factor = 1
	if x2 < x1:
		factor = -1
		buf = x1
		x1 = x2
		x2 = buf
	delta = (x2-x1)/n 
	for ii in range(n):
		x = x1 + ii*delta + delta/2
		integral += f(x)*delta
	return integral * factor


print('Sinus na przedziale [0, pi], n=5')
print(calka(sin, 0, 3.1415, 5)) 

print('Sinus na przedziale [0, pi], n=30')
print(calka(sin, 0, 3.1415, 30)) 

print('Sinus na przedziale [0, 2pi], n=3')
print(calka(sin, 0, 2*3.1415, 3)) 

print('Sinus na przedziale [0, 2pi], n=30')
print(calka(sin, 0, 2*3.1415, 30)) 

print('Pierwiastek na przedziale [1,3], n=30')
print(calka(sqrt, 1, 3, 30))

print('Pierwiastek na przedziale [3,1], n=30')
print(calka(sqrt, 3, 1, 30))

print('Funkcja kwadratowa na przedziale [-1, 4], n=3')
print(calka(kwadrat, -1, 4, 3))

print('Funkcja kwadratowa na przedziale [-1, 4], n=30')
print(calka(kwadrat, -1, 4, 30))
