#
# Fitting Erwin Hubble's data
#

from matplotlib import pyplot as plt

# Open the file and read lines (note the file name!)
with open('hubble_data.csv', 'r') as f:
	lines = f.readlines()

dist = []
vel = []

# we skip the header
for line in lines[1:]:
	tokens = line.split(',')
	dist.append(float(tokens[1]))
	vel.append(float(tokens[2]))

# calculate the slope
num = 0.0
den = 0.0
for x,y in zip(dist, vel):
	num += x*y
	den += x*x 

H = num/den
print(H)
plt.scatter(dist, vel, c='blue',label='data')
plt.plot(dist, [H*d for d in dist], c='red',label='Hubble law')
plt.title('Hubble constant -- original fit')
plt.ylabel('velocity [km/s]')
plt.xlabel('distance [Mpc]')
plt.legend()
plt.show()