#
# Korzystając ze słownika robimy konwerter PDG <-> nazwa cząstki
#


particle2pdg = {
	'd' : 1,
	'u' : 2,
	's' : 3,
	'c' : 4,
	'b' : 5,
	't' : 6,
	'e'	: 11,
	'nue' : 12,
	'mu' : 13,
	'numu' : 14,
	'tau' : 15,
	'nutau' : 16,
	'g' : 21,
	'gamma' : 22,
	'z' : 23,
	'w+' : 24,
	'h' : 25, 
}

pdg2particle = {str(v) : k for k, v in particle2pdg.items()} 

if __name__ == '__main__':
	print('Proszę podać identyfikator cząstki (nazwa lub kod PDG)')
	idp = input()
	if idp in particle2pdg.keys():
		print('Cząstce o symbolu {} odpowiada kod PDG: {}'.format(idp, particle2pdg[idp])) 
	elif idp[-1]=='~' and idp[:-1] in particle2pdg.keys():
		print('Cząstce o symbolu {} odpowiada kod PDG: {}'.format(idp, -1*particle2pdg[idp[:1]])) 
	elif idp in pdg2particle.keys():
		print('Cząstce o kodzie {} odpowiada symbol: {}'.format(idp, pdg2particle[idp]))
	elif idp[0]=='-' and idp[1:] in pdg2particle.keys():
		print('Cząstce o kodzie {} odpowiada symbol: {}'.format(idp, pdg2particle[idp[1:]]+'~'))
	else:
		print('Nierozpoznano identyfikatora cząstki! Koniec programu.')

