#
# Wykres słupkowy z wynikami wyborów
#

import matplotlib.pyplot as plt

wyniki = {
			'Podatki i Socjalizm' :  9732,
			'Unioniści' : 1084,
			'Polska Silna Laicka' : 531,
			'Polska 2137' : 4562,
			'Programiści Obiektowi' : 7824,
			'Starym Ludziom Dać' : 2783,
			'Super Progresywni' : 423,
			'Inni': 383,
		 }


klucze = list(wyniki.keys())
wartosci = list(wyniki.values())
# liczymy procentowe poparcie
procenty = [w/sum(wartosci)*100 for w in wartosci]
# sortujemy 
procenty, klucze = zip( *sorted( zip(procenty, klucze) ) )
# rysujemy
fig = plt.figure(figsize=(8,6))
plt.barh(range(0, len(list(wartosci))), width=procenty, tick_label=klucze, color='green')
for ii, p, in enumerate(procenty):
	plt.text(p+1, ii, str(round(p, 2))+'%') 
plt.vlines(5, -1, len(wartosci)+1, color='red', linestyle='--')
plt.xlabel('Poparcie [%]')
plt.xlim(0, max(procenty)+5)
plt.ylim(-0.5, len(list(wartosci))-0.5)
plt.title('Wyniki wyborów w gminie Chrząszczyrzewoszyce, powiat Łękołody')
plt.tight_layout()
plt.savefig('wybory.png')
plt.show()
