#
# Tworzymy bazę danych za pomocą słowników
#
from statistics import mean

uczniowie = { 
				1 : {'imię' : 'Jan', 'nazwisko' : 'Kowalski', 'średnia' : 4.5, 'oceny' : [4.0, 5.0] }, 
				2 : {'imię' : 'Janina', 'nazwisko' : 'Nowak', 'średnia' : 3.5, 'oceny' : [3.0, 3.0, 4.0, 4.0] }, 
			 }


if __name__ == '__main__':
	while(1):
		print("""
Polecenia:
	 l -- wypisz uczniów,
	 d -- dodaj nowego ucznia,
	 u -- usuń istniejącego ucznia,
	 w -- wypisz szczegóły ucznia,
	 o -- dodaj ocenę,
	 z -- zakończ
				 """)
		command = input()

		if command == 'l':
			print('Lista uczniów:')
			for k,v in uczniowie.items():
				print('{}\t{}, {}'.format(k, v['nazwisko'], v['imię']))
		elif command == 'd':
			uczen = {}
			print('Podaj imię')
			uczen['imię'] = input()
			print('Podaj nazwisko')
			uczen['nazwisko'] = input()
			uczen['średnia'] = 0.0
			uczen['oceny'] = []
			uczniowie[ sorted(uczniowie.keys())[-1] + 1 ] = uczen
		elif command == 'u':
			print('Podaj numer ucznia do usunięcia')
			nr = int(input())
			if nr not in uczniowie.keys():
				print('Błąd! Nie ma ucznia o takim numerze!')
			else:
				del uczniowie[nr]
				prev_k = 0
				for k,v in list(uczniowie.items()):
					if k != prev_k+1:
						del uczniowie[k]
						uczniowie[prev_k+1] = v
					prev_k += 1
		elif command == 'w':
			print('Podaj numer ucznia')
			nr = int(input())
			if nr not in uczniowie.keys():
				print('Błąd! Nie ma ucznia o takim numerze!')
			else:
				uczen = uczniowie[nr] 
				print('{}\t {} {}, średnia: {} '.format(nr, uczen['imię'], uczen['nazwisko'], uczen['średnia']))
				ocenytxt = 'oceny:'
				for o in uczen['oceny']:
					ocenytxt += f' {o}'
				print(ocenytxt)
		elif command == 'o':
			print('Podaj numer ucznia')
			nr = int(input())
			if nr not in uczniowie.keys():
				print('Błąd! Nie ma ucznia o takim numerze!')
			else:
				oceny =  uczniowie[nr]['oceny']
				print('Podaj nową ocenę')
				ocena = float(input())
				if ocena < 1.0 or ocena > 6.0:
					print('Błędna ocena!')
				else:
					oceny.append(ocena)

				uczniowie[nr]['oceny'] = oceny
				uczniowie[nr]['średnia'] = mean(oceny)
		elif command == 'z':
			exit(0)
		else:
			print('Nieropoznane polecenie!')


