#
# Policzymy pole trójkąta
#

from math import sqrt
from sys import argv

def area(a,b,c):
	p = 0.5*(a+b+c)
	return sqrt( p*(p-a)*(p-b)*(p-c) )


if __name__ == '__main__':
	a,b,c = 0.0, 0.0, 0.0
	try:
		if len(argv) < 4:
			raise RuntimeError("Provide three sides of a triangle!")
		a = float(argv[1])
		b = float(argv[2])
		c = float(argv[3])
		if a<= 0 or b<=0 or c<=0:
			raise ValueError("Values have to be positive!")
		if a+b<=c or a+c<=b or b+c<=a:
			raise ValueError("This is not a triangle!")
		print(f'Area is {area(a,b,c)}')
	except ValueError as e:
		print(f"Error! {e}")
	except RuntimeError as e:
		print(f"Error! Not enough parameters! {e}")
	except BaseException as err:
		print(f"Unexpected error: {err}, Error type: {type(err)}")
		raise
