#
# Usuwanie komentarzy
#

import sys

# własna definicja wyjątku
class MyError(Exception):
    # Constructor or Initializer
    def __init__(self, value):
        self.value = value
 
    # __str__ is to print() the value
    def __str__(self):
        return(repr(self.value))


if len(sys.argv) < 4:
	print('Niepoprawna liczba argumentów! Podaj znak na komentarz, plik wejściowu i wyjściowy.')
	exit(1)

try:
	if len(sys.argv[1]) > 1:
		raise MyError("Komentarz powinien być oznaczony pojedynczym znakiem!")
	else:
		com = sys.argv[1][0]
		# otwieramy plik, wczytujemy zawartość i zamykamy
		with open(sys.argv[2], 'r') as fin:
			lines = fin.readlines()
		# iterujemy po linijkach
		for ii, line in enumerate(lines):
			if line[0] == com:
				lines.pop(ii)
		# otwieramy plik, zapisujemy zawartość i zamykamy
		with open(sys.argv[3], 'w') as fout:
			fout.write(''.join(lines))
except FileNotFoundError as e:
	print(f'Błąd! {e}')
except MyError as e:
	print(f'Błąd! {e}')
except BaseException as e:
	print(f'Nieznany błąd! {e}')