#
# kalkulator
#

import sys

def textcalc(expression):
	return eval(expression)

if __name__ == '__main__':
	if len(sys.argv) < 3:
		print('Błąd! Proszę podać plik wejściowy i wyjściowy!')
		exit(1)
	else:
		try:
			with open(sys.argv[1], 'r') as fin:
				lines = fin.readlines()
			
			for ii, line in enumerate(lines):
				try:
					res = textcalc(line)
					lines[ii] = line.replace('\n','') + " = {}\n".format(res)
				except ZeroDivisionError as e:
					lines[ii] = "Błąd! Próba podzielenia przez zero!\n"
				except NameError as e:
					lines[ii] = "Błąd! Nierozpoznane wyrażenie!\n"
				except BaseException as e:
					lines[ii] = "Błąd! {}".format(e)

			with open(sys.argv[2], 'w') as fout:
				fout.write(''.join(lines))
		except FileNotFoundError as e:
			print('Błąd! Plik wejściowy nie istnieje!')
		except BaseException as e:
			print('Nieznany błąd! {}'.format(e))