#
# Szyfrowanie XOR
#
import sys

def szyfruj(klucz, znak):
	return ord(znak)^klucz

def odszyfruj(klucz, znak):
	val =  znak^klucz
	return chr(val)

if __name__ == '__main__':
	if len(sys.argv) < 5:
		raise RuntimeError("Za mało argumentów!")
	else:
		try:
			if not sys.argv[1].isdigit():
				raise ValueError('Zła wartość klucza! Podaj liczbę z przedziału [0,255].')
			klucz = int(sys.argv[1])
			if klucz <0 or klucz > 255:
				raise ValueError('Zła wartość klucza! Podaj liczbę z przedziału [0,255].')
			# otwieramy pliki
			fin = open(sys.argv[3], 'r')
			fout = open(sys.argv[4], 'w')
			while 1:
				znak = fin.read(1)
				if not znak:
					break
				else:
					if sys.argv[2] == '/e':
						nowy_znak = szyfruj(klucz, znak)
						fout.write(str(nowy_znak) + ' ')
					elif sys.argv[2] == '/d':
						liczba = znak
						while znak != ' ':
							znak = fin.read(1)
							liczba += znak
						liczba = int(liczba)
						nowy_znak = odszyfruj(klucz, liczba)
						fout.write(str(nowy_znak))
					else:
						raise ValueError('Niepoprawny tryb: "{}"\nUżyj "/e" do kodowania lub "/d" do dekodowania.'.format(sys.argv[2]))
					
			# pamiętamy o zamknięciu plików!
			fin.close()
			fout.close()
		except RuntimeError as e:
			print('[BŁĄD] {}'.format(e))
			print('python3 xor.py <klucz> <tryb /e (szyfruj) lub /d (odszyfruj)> <plik wejściowy> <plik wyjściowy>')
		except ValueError as e:
			print('[BŁĄD] {}'.format(e))
		except FileNotFoundError as e:
			print('[BŁĄD] {}'.format(e))
			print('Plik wsadowy nie istnieje!')
		except BaseException:
			print('[BŁĄD] NIEZNANY BŁĄD! Kończę pracę!')
			raise