#
# Implementujemy czteroped
#
from math import sqrt

class FourMomentum:
	"""Klasa reprezentujaca czterowektor pedu"""
	def __init__(self, E=0, px=0, py=0, pz=0):
		self.E = E
		self.px = px
		self.py = py 
		self.pz = pz


	def __str__(self):
			return f"[{self.E}, {self.px}, {self.py}, {self.pz}]"


	def __add__(self, other):
		x = self.px + other.px
		y = self.py + other.py
		z = self.pz + other.pz
		e = self.E + other.E
		return FourMomentum(e, x, y, z)


	def __sub__(self, other):
		x = self.px - other.px
		y = self.py - other.py
		z = self.pz - other.pz
		e = self.E - other.E
		return FourMomentum(e, x, y, z)


	def __mul__(self, other):
		p2x = self.px*other.px
		p2y = self.py*other.py
		p2z = self.pz*other.pz
		p2 = p2x + p2y + p2z
		return self.E * other.E - p2

	def m(self):
		s = self*self
		return sqrt(s)


if __name__ == '__main__':
	k = FourMomentum(5, 0, 4, 3)
	p0 = FourMomentum()
	p = FourMomentum(6, -1, -4, -3)

	print('Wypisz wszystkie trzy')
	print(k)
	print(p0)
	print(p)

	print('Suma trzech')
	print(k+p0+p)

	print('Masa wszystkich trzech')
	print(k.m())
	print(p0.m())
	print(p.m())

	print('Różnica p-k')
	print(p-k)

	print('Zwężenie p*k')
	print(p*k)


