C-----JACOBI----------------------------------------------

      SUBROUTINE JACOBI(A,N,NP,D,V,NROT)
C
C     A:MATRIX  N:UNTERMAT.LaeNGE  NP:#ZEILEN/SPALTEN  D:EWe  V:DIAG.MAT
C
C      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      implicit none
      integer nmax
      PARAMETER (NMAX=100)
      integer ip,iq,n,np,nrot,i,j
      double precision  sm,tresh,g,s,c,theta,tau,h,t
      DOUBLE PRECISION A(NP,NP),D(NP),V(NP,NP),B(NMAX),Z(NMAX)
C             MATRIX   EW    DIAGMAT

      DO 12 IP=1,N
        DO 11 IQ=1,N
          V(IP,IQ)=0.D0
11      CONTINUE
        V(IP,IP)=1.D0
12    CONTINUE

      DO 13 IP=1,N
        B(IP)=A(IP,IP)
        D(IP)=B(IP)
        Z(IP)=0.D0
13    CONTINUE

      NROT=0
      DO 24 I=1,50
        SM=0.D0
        DO 15 IP=1,N-1
          DO 14 IQ=IP+1,N
            SM=SM+ABS(A(IP,IQ))
14        CONTINUE
15      CONTINUE

        IF(SM.EQ.0.D0)RETURN
        IF(I.LT.4)THEN
          TRESH=0.2D0*SM/N**2
        ELSE
          TRESH=0.D0
        ENDIF

        DO 22 IP=1,N-1
          DO 21 IQ=IP+1,N
            G=100.D0*DABS(A(IP,IQ))
            IF((I.GT.4).AND.(DABS(D(IP))+G.EQ.DABS(D(IP)))
     &         .AND.(DABS(D(IQ))+G.EQ.DABS(D(IQ))))THEN
              A(IP,IQ)=0.D0
            ELSE IF(DABS(A(IP,IQ)).GT.TRESH)THEN
              H=D(IQ)-D(IP)
              IF(DABS(H)+G.EQ.DABS(H))THEN
                T=A(IP,IQ)/H
              ELSE
                THETA=0.5D0*H/A(IP,IQ)
                T=1.D0/(ABS(THETA)+SQRT(1.D0+THETA**2))
                IF(THETA.LT.0.D0)T=-T
              ENDIF
              C=(SQRT(1.D0+T**2))**(-1)
              S=T*C
              TAU=S/(1.D0+C)
              H=T*A(IP,IQ)
              Z(IP)=Z(IP)-H
              Z(IQ)=Z(IQ)+H
              D(IP)=D(IP)-H
              D(IQ)=D(IQ)+H
              A(IP,IQ)=0.D0

              DO 16 J=1,IP-1
                G=A(J,IP)
                H=A(J,IQ)
                A(J,IP)=G-S*(H+G*TAU)
                A(J,IQ)=H+S*(G-H*TAU)
16            CONTINUE
              DO 17 J=IP+1,IQ-1
                G=A(IP,J)
                H=A(J,IQ)
                A(IP,J)=G-S*(H+G*TAU)
                A(J,IQ)=H+S*(G-H*TAU)
17            CONTINUE
              DO 18 J=IQ+1,N
                G=A(IP,J)
                H=A(IQ,J)
                A(IP,J)=G-S*(H+G*TAU)
                A(IQ,J)=H+S*(G-H*TAU)
18            CONTINUE
              DO 19 J=1,N
                G=V(J,IP)
                H=V(J,IQ)
                V(J,IP)=G-S*(H+G*TAU)
                V(J,IQ)=H+S*(G-H*TAU)
19            CONTINUE
              NROT=NROT+1
            ENDIF
21        CONTINUE
22      CONTINUE

        DO 23 IP=1,N
          B(IP)=B(IP)+Z(IP)
          D(IP)=B(IP)
          Z(IP)=0.D0
23      CONTINUE
24    CONTINUE

      PAUSE '50 iterations should never happen'
      RETURN
      END
C----------------------------------------------------------------------


      DOUBLE PRECISION FUNCTION DREAL(AAA)

      COMPLEX*16 AAA
      DREAL=DIMAG(AAA*(0.D0,1.D0))

      END
