
* file aaxbx.for  16-jul-1990

*###[ aaxbx :
	subroutine aaxbx(caxi,cbxi,acbxi,d0,xmu,xp,xma,xmb,level,ier)
*###[ comment:***********************************************************
*									*
*	Calculation of formfactors resulting  from decself.sub		*
*	or decself.frm (at the moment up to second rank tensor)		*
*	11-jun-1993: changed to use my ffxb1, ffxdb0 routines  GJ	*
*									*
*	Input:	xp,xma,xmb	the same as in Geert Jan's routines	*
*		level		rank of tensor(integral)		*
*	Output:								*
*		caxi(2)		ca0i					*
*		cbxi(4)		cb0,cb11,cb21,cb22			*
*		acbxi(2)	acbxi(1),acb11 (derivatives)		*
*									*
*###] comment:***********************************************************
*###[ declarations :
	implicit none
*
*	arguments
*
	integer ier,level
	DOUBLE PRECISION xp,xma,xmb,d0,xmu
	DOUBLE COMPLEX caxi(2),cbxi(4),acbxi(2)
*
*	local variables
*
	integer i,ier0,ier1
	DOUBLE COMPLEX cb2i(2),acb0p
*
*	common blocks
*
	include 'ff.h'
	include 'aa.h'
*
*	initialization
*
	do 10 i=1,2
	    caxi(i)=0
   10	continue
	do 11 i=1,4
	    cbxi(i)=0
   11	continue
	do 12 i=1,2
	    acbxi(i)=0
   12	continue
*###] declarations :
*###[ level 0 : B0
*	B0-function
	ldot = .TRUE.
	ier1 = ier
	call ffxb0(cbxi(1),d0,xmu,xp,xma,xmb,ier1)
	if ( awrite ) then
c	    print *,'   '
c	    print *,'aaxbx : level 0'
c	    print *,'B0 =',cbxi(1)
	endif
	if (level .eq. 0  .and. .NOT. aderiv ) goto 990
*###] level 0 :
*###[ level 1 : B11,A0(I) and derivatives AB0,AB11
*		need 2 diff A0(I)-functions
	ier0 = ier
	call ffxa0( caxi(1),d0,xmu,xma,ier0)
	ier1 = max(ier1,ier0)
	ier0 = ier
	call ffxa0( caxi(2),d0,xmu,xmb,ier0)
	ier1 = max(ier1,ier0)
	if (aderiv) then
	    ier0 = ier
	    call ffxdb0(acbxi(1),acb0p,xp,xma,xmb,ier0)
	    ier1 = max(ier1,ier0)
	    if ( atest ) then
c		if ( abs(xp*acbxi(1)-acb0p) .gt. precc*abs(acb0p) )
c     +		    print *,'aaxbx: error: B0'' not consistent: ',
c     +		    xp*acbxi(1),acb0p,xp*acbxi(1)-acb0p,ier0
	    endif
	    if ( awrite ) then
c		print *,'AB0 =',acbxi(1)
	    endif
	endif

	if ( level .eq. 0 ) return
*###[ calculation of B11:
	ier = ier1
	call ffxb1(cbxi(2),cbxi(1),caxi,xp,xma,xmb,fpij2,ier1)
*###] calculation of B11:
	if ( awrite ) then
c	    print *,'	   '
c	    print *,'aaxbx : level 1 '
c	    print *,'B11 = ',cbxi(2)
c	    print *,'  A0(1) =',caxi(1)
c	    print *,'  A0(2) =',caxi(2)
c	    print *,'AB0 = ',acbxi(1)
c	    print *,'AB11= not yet implemented'
	endif

	if (level .eq. 1  ) goto 990

*###] level 1 :
*###[ level 2 : B21,B22
*		calculate B21 either on the basis of B11 or make
*		first the  complete analytical reduction to B0,A0
	call ffxb2p(cb2i,cbxi(2),cbxi(1),caxi,xp,xma,xmb,fpij2,ier1)

	cbxi(3)=cb2i(1)
	cbxi(4)=cb2i(2)
	if ( awrite ) then
c	    print *,' '
c	    print *,'aaxbx : level 2 '
c	    print *,'B21 = ',cb2i(1)
c	    print *,'B22 = ',cb2i(2)
	endif

	if (level .eq. 2) goto 990

*###] level 2 :
c	print *,'aaxbx: error: level ',level,' not supported'
	stop

  990	continue
	ier = max(ier1,ier)
*###] aaxbx :
	end
