
* file aaxdx.for  25-jun-1990, 8-nov-1993 GJ

*###[ aaxdx :
	subroutine aaxdx(cbxi,ccxi,cdxi,d0,xmm,xpi,level,ier)
***#[*comment:***********************************************************
*									*
*	Calculation of formfactors resulting from  decbox.sub		*
*	or decbox.frm							*
*	( up to 3.rank tensor )						*
*									*
*	Input:								*
*		xpi	  the same as in Geert Jan's routines		*
*		level	  rank of tensor(integral)			*
*	Output: 							*
*		cbxi(12)  cb0(1),cb1(1),[cb2(2)]	 x 6		*
*		ccxi(28)  cc0(1),cc1(2),cc2(4),[cc3(6)]  x 4		*
*		cdxi(24)  cd0(1),cd1(3),cd2(7),cd3(13)			*
*									*
***#]*comment:***********************************************************
*  #[ declarations :
	implicit none
*
*	arguments
*
	integer ier,level
	DOUBLE PRECISION xpi(13),d0,xmm
	DOUBLE COMPLEX cbxi(12),ccxi(28),cdxi(24)
*
*	local variables
*
	integer i,j,cl,ier0,ier1,iinx(6,4)
	DOUBLE PRECISION xpi3(6),fdel2i(4)
	DOUBLE COMPLEX caxj(12),cbxj(48),ccxj(52)
	save iinx
*
*	common blocks
*
	include 'ff.h'
	include 'aa.h'
*
*	data
*
	data iinx /2,3,4,6,7,10,
     +		   1,3,4,9,7,8,
     +		   1,2,4,5,10,8,
     +		   1,2,3,5,6,9/
*
*  #] declarations :
*  #[ initialisations:
*
*	initialization
*
	do 9 i=1,12
	    cbxi(i)=0
    9	continue
	do 10 i=1,28
	    ccxi(i)=0
   10	continue
	do 11 i=1,24
	    cdxi(i)=0
   11	continue
*
*  #] initialisations:
*  #[ get D0:
*	D0-function (ff)
*	   futhermore dotpr and determinants are delivered by ff
	ldot = .TRUE.
	ier1 = ier
	call ffxd0(cdxi(1),xpi,ier1)
	if ( ier1.gt.10 ) then
	    if ( ltest ) then
c		print *,'aaxdx: id = ',id,', nevent = ',nevent
c		print *,'aaxdx: lost ',ier1,' digits in D0 with isgnal '
c     +			,isgnal,', trying other roots, isgnal ',-isgnal
c		print *,'       if OK (no further messages) adding this'
c     +			,' to your code will improve speed'
	    endif
	    isgnal = -isgnal
	    ier1 = ier
	    call ffxd0(cdxi(1),xpi,ier1)
	    isgnal = -isgnal
	endif
	if ( awrite ) then
c	    print *,'    '
c	    print *,'aaxdx : level 0 '
c	    print *,'D0 =',cdxi(1)
	endif
	if ( ier1 .gt. 10 ) then
c	    print *,'aaxdx: id = ',id,', nevent = ',nevent
c	    print *,'aaxdx: error: D0 not stable, lost ',ier1,' digits'
c	    print *,'       please try another permutation or contact ',
c     +	    	'author (t19@nikhef.nl)'
c	    print *,'xpi = ',xpi
	endif
*
	if (level .eq. 0) goto 990
*
*  #] get D0:
*  #[ need C-functions till c-level=(level-1):
	if (level .gt. 3) then
c	    print *,'higher than third rank not yet implemented'
	    goto 990
	endif
	cl=level-1
*	go trough the 4 different cancellation patterns
	if ( awrite ) then
c	   print *,'	 '
c	   print *,'------>underlying C-functions up to level:',cl
	endif
	do 100 i=1,4
	    do 60 j=1,6
		xpi3(j) = xpi(iinx(j,i))
   60	    continue
	    ier0 = ier
	    call aaxcx( caxj(3*i-2),cbxj(12*i-11),ccxj(13*i-12),
     +		d0,xmm,xpi3,cl,ier0)
	    ier1 = max(ier1,ier0)
*		only used for comparision with Geert Jans routines
	    fdel2i(i)=fdel2
  100	continue
*  #[ old code:
***	go trough the 4 different cancellation patterns
*	if ( awrite ) then
c*	   print *,'	 '
c*	   print *,'------>underlying C-functions up to level:',cl
c*	endif
c***	C(1)=C(p2,p3,m2,m3,m4)
c*	xpj(1)=xpi(2)
c*	xpj(2)=xpi(3)
c*	xpj(3)=xpi(4)
c*	xpj(4)=xpi(6)
c*	xpj(5)=xpi(7)
c*	xpj(6)=xpi(10)
c*	ier0 = ier
c*	call aaxcx( caxj(1),cbxj(1),ccxj(1),d0,xmm,xpj,cl,ier0)
c*	ier1 = max(ier1,ier0)
***	    only used for comparision with Geert Jans routines
*	fdel2i(1)=fdel2
***	C(2)=C(p1+p2,p3,m1,m3,m4)
*	xpj(1)=xpi(1)
*	xpj(2)=xpi(3)
*	xpj(3)=xpi(4)
*	xpj(4)=xpi(9)
*	xpj(5)=xpi(7)
*	xpj(6)=xpi(8)
*	ier0 = ier
*	call aaxcx( caxj(4),cbxj(13),ccxj(14),d0,xmm,xpj,cl,ier)
*	ier1 = max(ier1,ier0)
***	    only used for comparision with Geert Jans routines
*	fdel2i(2)=fdel2
***	C(3)=C(p1,p2+p3,m1,m2,m4)
*	xpj(1)=xpi(1)
*	xpj(2)=xpi(2)
*	xpj(3)=xpi(4)
*	xpj(4)=xpi(5)
*	xpj(5)=xpi(10)
*	xpj(6)=xpi(8)
*	ier0 = ier
*	call aaxcx( caxj(7),cbxj(25),ccxj(27),d0,xmm,xpj,cl,ier)
*	ier1 = max(ier1,ier0)
***	    only used for comparision with Geert Jans routines
*	fdel2i(3)=fdel2
***	C(4)=C(p1,p2,m1,m2,m3)
*	xpj(1)=xpi(1)
*	xpj(2)=xpi(2)
*	xpj(3)=xpi(3)
*	xpj(4)=xpi(5)
*	xpj(5)=xpi(6)
*	xpj(6)=xpi(9)
*	ier0 = ier
*	call aaxcx( caxj(10),cbxj(37),ccxj(40),d0,xmm,xpj,cl,ier)
*	ier1 = max(ier1,ier0)
***	    only used for comparision with Geert Jans routines
*	fdel2i(4)=fdel2
*  #] old code:
	if ( awrite ) then
c	    print *,'	 '
c	    print *,'---->end of C-function output--------------------'
	endif
*  #] need C-functions till c-level=(level-1):
*  #[ call aaxdxp:
	call aaxdxp(cbxi,ccxi,cdxi,caxj,cbxj,ccxj,xpi,fdel2i,level,
     +		ier1)
  990	continue
	ier = ier1
*  #] call aaxdxp:
*###] aaxdx :
	end
*###[ aaxdxp :
	subroutine aaxdxp(cbxi,ccxi,cdxi,caxj,cbxj,ccxj,xpi,fdel2i,
     +		level,ier)
***#[*comment:***********************************************************
*									*
*	the part that is common to aaxdx and aazdz.			*
*									*
*									*
***#]*comment:***********************************************************
*  #[ declarations :
	implicit none
*
*	arguments
*
	integer ier,level
	DOUBLE PRECISION xpi(13),fdel2i(4)
	DOUBLE COMPLEX cbxi(12),ccxi(28),cdxi(24),caxj(12),cbxj(48),
     +		ccxj(52)
*
*	local variables
*
	integer i,j,k,ier0,ier1,ier2
	DOUBLE PRECISION xi4(6),f1,f2,f3,absc
	DOUBLE COMPLEX R20,R21,R22,R30,R31,R32,R33,R34,R35,R36,R37,R38,
     +		R41,R42,R43,R44,R45,R46,R47,R48,R49,R50,R51,R52,R53,R54,
     +		R55,cd1i(3),cc0i(4),cc11i(4),cc12i(4),
     +		cc21i(4),cc22i(4),cc23i(4),cc24i(4),cc,cxy(3)
*
*	common blocks
*
	include 'ff.h'
	include 'aa.h'
*
*	statement functions
*
	absc(cc) = abs(DBLE(cc)) + abs(DIMAG(cc))
*
*  #] declarations :
*  #[ kinematical quatities for 4pv-red :
	ier1 = ier
*	if ( abs(fdel3)  .lt. 1.d-6 ) then
c*	    print *,'kinematical det = 0, PV-scheme breaks down'
c*	    print *,fdel3
*	    goto 990
*	endif
*	    inverse kinematical matrix xi4  (3X3)

	ier2 = ier
	call aaxi4(xi4,ier2)
*
*	    f-functions:
***	f1=(xpi(2)-xpi(1))-fpij4(5,5)
c***	print *,'f1 was : ',f1
	f1 = 2*fpij4(1,5)
c***	print *,'f1 is  : ',f1
c***	f2=(xpi(3)-xpi(2))-2*fpij4(5,6)-fpij4(6,6)
c***	print *,'f2 was : ',f2
	f2 = 2*fpij4(1,6)
c***	print *,'f2 is  : ',f2
c***	f3=(xpi(4)-xpi(3))-2*fpij4(5,7)-2*fpij4(6,7)-fpij4(7,7)
c***	print *,'f3 was : ',f3
	f3 = 2*fpij4(1,7)
c***	print *,'f3 is  : ',f3
*
*  #] kinematical quatities for 4pv-red :
*  #[ level 0 :
*	output preparation
*	   1)C-output: reduce the array ccxj(4*13) to ccxi(4*7)
*		       c's are calculated only to (level-1)
	do 130 j=1,4
	    do 131 i=1,7
		ccxi(i+(j-1)*7)=ccxj(i+(j-1)*13)
 131	    continue
 130	continue
*	   2)B-output: reduce the array cbxj(12*4) to cbxi(6*2)
*		       b's are calculated only to (level-2)
	cbxi(1) = cbxj(1)
	cbxi(2) = cbxj(2)
	cbxi(3) = cbxj(5)
	cbxi(4) = cbxj(6)
	cbxi(5) = cbxj(9)
	cbxi(6) = cbxj(10)
	cbxi(7) = cbxj(17)
	cbxi(8) = cbxj(18)
	cbxi(9) = cbxj(21)
	cbxi(10)= cbxj(22)
	cbxi(11)= cbxj(33)
	cbxi(12)= cbxj(34)
*	check the symmetry in B0(i,j)
	if ( atest ) then
	    do 13 i=1,4
		j=4+i
		k=8+i
		if (( cbxj(i)     - cbxj(i+1*12) ) .ne. 0. .or.
     +		    ( cbxj(j)     - cbxj(i+2*12) ) .ne. 0. .or.
     +		    ( cbxj(k)     - cbxj(i+3*12) ) .ne. 0. .or.
     +		    ( cbxj(j+1*12)- cbxj(j+2*12) ) .ne. 0. .or.
     +		    ( cbxj(k+1*12)- cbxj(j+3*12) ) .ne. 0. .or.
     +		    ( cbxj(k+2*12)- cbxj(k+3*12) ) .ne. 0. ) then
c		    print *,'error in B0-calculations in aaxcx.for'
		    goto 990
		endif
 13	    continue
	endif

*  #] level 0 :
*  #[ level 1 : D11,D12,D13,C0(I)
*		need 4 diff C0(I)-functions,I=1,2,3
	cc0i(1)=ccxj(1)
	cc0i(2)=ccxj(14)
	cc0i(3)=ccxj(27)
	cc0i(4)=ccxj(40)
*	    PV-reduction
	R20 = ( f1*cdxi(1)+cc0i(2)-cc0i(1) )/2
	R21 = ( f2*cdxi(1)+cc0i(3)-cc0i(2) )/2
	R22 = ( f3*cdxi(1)+cc0i(4)-cc0i(3) )/2
	cdxi(2)=xi4(1)*R20+xi4(4)*R21+xi4(5)*R22
	cdxi(3)=xi4(4)*R20+xi4(2)*R21+xi4(6)*R22
	cdxi(4)=xi4(5)*R20+xi4(6)*R21+xi4(3)*R22
	if (awrite) then
c	    print *,'	   '
c	    print *,'aaxdx : level 1 :'
c	    print *,'D11=',cdxi(2)
c	    print *,'D12=',cdxi(3)
c	    print *,'D13=',cdxi(4)
	endif
*
*	check with ffroutine
	if ( atest ) then
	    ier0 = ier
	    call ffxd1(cd1i,cdxi(1),cc0i,xpi,fpij4,fdel3,fdel2i,ier0)
	    if ( awrite ) then
c		print *,'GEERT JANs-scheme:',ier0
c		print *,'D11=',cd1i(1)
c		print *,'D12=',cd1i(2)
c		print *,'D13=',cd1i(3)
	    endif
	endif
*
	if (level .eq. 1) goto 990
*
*  #] level 1 :
*  #[ level 2 : D21,D22,D23,D24,D25,D26,D27,C11(I),C12(I)
*	    need 4 diff C1-functions
	do 14 i=1,4
	    j = 2 +(i-1)*13
	    cc11i(i)=ccxj(j)
 14	    cc12i(i)=ccxj(j+1)
*		PV-reduction
	cdxi(11)=-( f1*cdxi(2)+f2*cdxi(3)+f3*cdxi(4)-cc0i(1) )/2
     +		 +xpi(1)*cdxi(1)
	R30=( f1*cdxi(2) + cc11i(2) + cc0i(1)  )/2 - cdxi(11)
	R31=( f2*cdxi(2) + cc11i(3) - cc11i(2) )/2
	R32=( f3*cdxi(2) + cc11i(4) - cc11i(3) )/2
	R33=( f1*cdxi(3) + cc11i(2) - cc11i(1) )/2
	R34=( f2*cdxi(3) + cc12i(3) - cc11i(2) )/2 - cdxi(11)
	R35=( f3*cdxi(3) + cc12i(4) - cc12i(3) )/2
	R36=( f1*cdxi(4) + cc12i(2) - cc12i(1) )/2
	R37=( f2*cdxi(4) + cc12i(3) - cc12i(2) )/2
	R38=( f3*cdxi(4)            - cc12i(3) )/2 - cdxi(11)
	cdxi(5) = xi4(1)*R30+xi4(4)*R31+xi4(5)*R32
	cdxi(6) = xi4(4)*R33+xi4(2)*R34+xi4(6)*R35
	cdxi(7) = xi4(5)*R36+xi4(6)*R37+xi4(3)*R38
	cdxi(8) = xi4(4)*R30+xi4(2)*R31+xi4(6)*R32
	cdxi(9) = xi4(5)*R30+xi4(6)*R31+xi4(3)*R32
	cdxi(10)= xi4(5)*R33+xi4(6)*R34+xi4(3)*R35
*	redundancy check
	if ( atest ) then
	    cxy(1) = xi4(1)*R33+xi4(4)*R34+xi4(5)*R35
	    cxy(2) = xi4(1)*R36+xi4(4)*R37+xi4(5)*R38
	    cxy(3) = xi4(4)*R36+xi4(2)*R37+xi4(6)*R38
	    if ( absc(cxy(1)-cdxi(8))	.gt. .1d-3   .or.
     +		 absc(cxy(2)-cdxi(9))	.gt. .1d-3   .or.
     +		 absc(cxy(3)-cdxi(10)) .gt. .1d-5	   ) then
c		print *,'redundancy check at level 2 failed'
		goto 990
	    endif
	endif
	if ( awrite ) then
c	    print *,'	   '
c	    print *,'aaxdx : level 2 '
c	    print *,'D21=',cdxi(5)
c	    print *,'D22=',cdxi(6)
c	    print *,'D23=',cdxi(7)
c	    print *,'D24=',cdxi(8)
c	    print *,'D25=',cdxi(9)
c	    print *,'D26=',cdxi(10)
c	    print *,'D27=',cdxi(11)
	endif
*
	if (level .eq. 2) goto 990
*
*  #] level 2 :
*  #[ level 3 : D31,D32,D33,D34,D35,D36,D37,D38,D39,D310,D311,D312,D313
*		C21(I),C22(I),C23(I),C11(I),C12(I)
*		need 4 diff C2-functions
	do 15 i=1,4
	    j = 4 +(i-1)*13
	    cc21i(i)=ccxj(j)
	    cc22i(i)=ccxj(j+1)
	    cc23i(i)=ccxj(j+2)
 15	    cc24i(i)=ccxj(j+3)
*		PV-reduction
	R53=( f1*cdxi(11) + cc24i(2) - cc24i(1) )/2
	R54=( f2*cdxi(11) + cc24i(3) - cc24i(2) )/2
	R55=( f3*cdxi(11) + cc24i(4) - cc24i(3) )/2
	cdxi(22) = xi4(1)*R53+xi4(4)*R54+xi4(5)*R55
	cdxi(23) = xi4(4)*R53+xi4(2)*R54+xi4(6)*R55
	cdxi(24) = xi4(5)*R53+xi4(6)*R54+xi4(3)*R55
*
	R41=( f1*cdxi(5) + cc21i(2) - cc0i(1)  )/2-2*cdxi(22)
	R42=( f2*cdxi(5) + cc21i(3) - cc21i(2) )/2
	R43=( f3*cdxi(5) + cc21i(4) - cc21i(3) )/2
	R44=( f1*cdxi(6) + cc21i(2) - cc21i(1) )/2
	R45=( f2*cdxi(6) + cc22i(3) - cc21i(2) )/2-2*cdxi(23)
	R46=( f3*cdxi(6) + cc22i(4) - cc22i(3) )/2
	R47=( f1*cdxi(7) + cc22i(2) - cc22i(1) )/2
	R48=( f2*cdxi(7) + cc22i(3) - cc22i(2) )/2
	R49=( f3*cdxi(7)            - cc22i(3) )/2-2*cdxi(24)
	R50=( f1*cdxi(8) + cc21i(2) + cc11i(1) )/2-cdxi(23)
	R51=( f2*cdxi(8) + cc23i(3) - cc21i(2) )/2-cdxi(22)
	R52=( f3*cdxi(8) + cc23i(4) - cc23i(3) )/2
	cdxi(12) = xi4(1)*R41+xi4(4)*R42+xi4(5)*R43
	cdxi(13) = xi4(4)*R44+xi4(2)*R45+xi4(6)*R46
	cdxi(14) = xi4(5)*R47+xi4(6)*R48+xi4(3)*R49
	cdxi(15) = xi4(4)*R41+xi4(2)*R42+xi4(6)*R43
	cdxi(16) = xi4(5)*R41+xi4(6)*R42+xi4(3)*R43
	cdxi(17) = xi4(1)*R44+xi4(4)*R45+xi4(5)*R46
	cdxi(18) = xi4(1)*R47+xi4(4)*R48+xi4(5)*R49
	cdxi(19) = xi4(5)*R44+xi4(6)*R45+xi4(3)*R46
	cdxi(20) = xi4(4)*R47+xi4(2)*R48+xi4(6)*R49
	cdxi(21) = xi4(5)*R50+xi4(6)*R51+xi4(3)*R52
*	redundancy check
	if ( atest ) then
	    cxy(1) = xi4(1)*R50+xi4(4)*R51+xi4(5)*R52
	    cxy(2) = xi4(4)*R50+xi4(2)*R51+xi4(6)*R52
	    if ( absc(cxy(1)-cdxi(15)) .gt. .1d-3   .or.
     +		 absc(cxy(2)-cdxi(17)) .gt. .1d-3	   ) then
c		print *,'redundancy check at level 3 failed'
		goto 990
	    endif
	endif
	if ( awrite ) then
c	    print *,'	   '
c	    print *,'aaxdx : level 3 '
c	    print *,'D31 =',cdxi(12)
c	    print *,'D32 =',cdxi(13)
c	    print *,'D33 =',cdxi(14)
c	    print *,'D34 =',cdxi(15)
c	    print *,'D35 =',cdxi(16)
c	    print *,'D36 =',cdxi(17)
c	    print *,'D37 =',cdxi(18)
c	    print *,'D38 =',cdxi(19)
c	    print *,'D39 =',cdxi(20)
c	    print *,'D310=',cdxi(21)
c	    print *,'D311=',cdxi(22)
c	    print *,'D312=',cdxi(23)
c	    print *,'D313=',cdxi(24)
	endif
*
	if (level .eq. 3) goto 990
*
*  #] level 3 :
*  #[ end:
  990	continue
	ier = ier1 + (ier2-ier)
*  #] end:
*###] aaxdxp :
	end
