c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: F_SELF.FOR
c     Last revised: 15: 2:1993 (PCh)
c     gauge boson loop contribution adjusted to the DIMENSIONAL
c     REDUCTION regularization

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for photon self-energy function    c
c     and its renormalization.                                          c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,       c
c     available as hep-ph/9303309.                                      c
c     Calculation of the contribution of quarks other than TOP (needed  c
c     for calculation of the hadronic vacuum polarization (see function c
c     f_sig_0() in the file r_const.f) in a separate function added.    c
c                                                                       c
c     The definition of the self energy as follows:                     c
c                                                                       c
c       k      ____    k                                                c
c             |    |             =  i (g(mu,nu)-k^\mu k^\nu /k^2)       c
c       ~~~~~~|____|~~~~~~                * ft_sig(k^2)                 c
c     GAMMA^mu       GAMMA^nu         (or * ft_ren(k^2)                 c
c                                for the renormalized self energy)      c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ft_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      ft_3sig1 = 0
      do 10 k=1,3
        ft_3sig1 = ft_3sig1 - 4*e2*(2*b22(s,em(k),em(k))
     1                      + a(em(k)) + s*b0(s,em(k),em(k))/2)
        ft_3sig1 = ft_3sig1 - 16.d0/3*e2*(2*b22(s,um(k),um(k))
     1                      + a(um(k)) + s*b0(s,um(k),um(k))/2)
10      ft_3sig1 = ft_3sig1 - 4.d0/3*e2*(2*b22(s,dm(k),dm(k))
     1                      + a(dm(k)) + s*b0(s,dm(k),dm(k))/2)
      return
      end

      complex*16 function ft_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      ft_3sig2 = 0
      do 10 k=1,6
        ft_3sig2 = ft_3sig2 + 4*e2*b22(s,slm(k),slm(k))
        ft_3sig2 = ft_3sig2 + 16.d0/3*e2*b22(s,sum(k),sum(k))
10      ft_3sig2 = ft_3sig2 + 4.d0/3*e2*b22(s,sdm(k),sdm(k))
      return
      end

      complex*16 function ft_3sig3(s)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ft_3sig3 = 0
      do 10 k=1,2
10      ft_3sig3 = ft_3sig3 + 4*e2*b22(s,cm(k),cm(k))
      return
      end

      complex*16 function ft_3sig4(s)
c     Charged Goldstone + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      ft_3sig4 = -2*e2*wm2*b0(s,wm,wm)
      return
      end

      complex*16 function ft_3sig5(s)
c     2 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      ft_3sig5 = -2*e2*b22(s,wm,wm)
      return
      end

      complex*16 function ft_3sig6(s)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      complex*16 zpos,zneg
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ft_3sig6 = 0
      do 10 k=1,2
10      ft_3sig6 = ft_3sig6 - 4*e2*(2*b22(s,fcm(k),fcm(k)) + a(fcm(k))
     1                      + s*b0(s,fcm(k),fcm(k))/2)
      return
      end

      complex*16 function ft_3sig7(s)
c     2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      ft_3sig7 = 2*e2*((2*s + wm2)*b0(s,wm,wm) - a(wm) + 5*b22(s,wm,wm))
     2         - idflag*2*e2*(2*wm2 - s/3)
      return
      end

      double precision function ft_4sig1()
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      ft_4sig1 = 0
      do 10 k=1,6
        ft_4sig1 = ft_4sig1 + 2*e2*a(slm(k))
        ft_4sig1 = ft_4sig1 + 8.d0/3*e2*a(sum(k))
10      ft_4sig1 = ft_4sig1 + 2.d0/3*e2*a(sdm(k))
      return
      end

      double precision function ft_4sig2()
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ft_4sig2 = 0
      do 10 k=1,2
10      ft_4sig2 = ft_4sig2 + 2*e2*a(cm(k))
      return
      end

      double precision function ft_4sig3()
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      ft_4sig3 = e2*6*a(wm)
     1         + idflag*e2*4*wm2
      return
      end

      complex*16 function ft_sig(s)
c     Full bare transversal photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 ft_3sig1,ft_3sig2,ft_3sig3,ft_3sig4,
     1           ft_3sig5,ft_3sig6,ft_3sig7
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ft_sig = 0
      if (if.eq.1) ft_sig = ft_sig + ft_3sig1(s)
      if (is.eq.1) ft_sig = ft_sig + ft_3sig2(s) + ft_4sig1()
      if (ig.eq.1) ft_sig = ft_sig + ft_3sig3(s) + ft_3sig4(s) 
     1                             + ft_3sig5(s) + ft_4sig2()
     2                             + ft_4sig3()
      if (ic.eq.1) ft_sig = ft_sig + ft_3sig6(s)
      if (in.eq.1) ft_sig = ft_sig + ft_3sig7(s)
      ft_sig = ft_sig/16/pi/pi
      return
      end

      complex*16 function ft_ren(s)
c     Full renormalized transversal photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 ft_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      ft_ren = ft_sig(s) - (st2*dza + ct2*dzb)*s
      return
      end

      complex*16 function ft_had(s)
c     Light quark contribution (excluding top) to the transversal
c     photon self-energy
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      ft_had = 0
      do 10 k=1,2
10      ft_had = ft_had - 16.d0/3*e2*(2*b22(s,um(k),um(k))
     1                  + a(um(k)) + s*b0(s,um(k),um(k))/2)
      do 20 k=1,3
20      ft_had = ft_had - 4.d0/3*e2*(2*b22(s,dm(k),dm(k))
     1                  + a(dm(k)) + s*b0(s,dm(k),dm(k))/2)
      ft_had = ft_had/16/pi/pi
      return
      end



