c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FFP_ON_V.FOR
c     Released: 29:11:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains pseudoscalar - GAMMA - GAMMA vertex          c
c     formfactors. On-shell version.                                  c
c                                                                     c
c     Incoming pseudoscalar P(i):  momentum (p+q)                     c
c     Outgoing GAMMA            :  momentum  p^{\mu}                  c
c     Outgoing GAMMA            :  momentum  q^{\nu}                  c
c                                                                     c
c                                                                     c
c                                       GAMMA^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       P_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GAMMA^\nu                    c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i (F_1 (g(mu,nu)  - q(mu)p(nu)/pq) + F_4 p(mu)q(nu))      c
c         + F_6 eps(p,q,mu,nu)                                        c
c                                                                     c
c       Momentum arguments in formfactors:                            c
c       p^2 = q^2 = 0    s = (p + q)^2 = 2 pq                         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine ffp_on_vert1(s,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        form(6) = form(6) + 8*e2*em(k)*em(k)*zh(1,i)/v1*c0_on(s,em(k))
        form(6) = form(6) + 32/3.d0*e2*um(k)*um(k)*zh(2,i)/v2
     1          * c0_on(s,um(k))
10      form(6) = form(6) + 8/3.d0*e2*dm(k)*dm(k)*zh(1,i)/v1
     1          * c0_on(s,dm(k))
      return
      end
 
      subroutine ffp_on_vert2(s,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on
      complex*16 zpos,zneg
      complex*16 v_ccp
      complex*16 r,form(6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        r = (v_ccp(k,k,i) + conjg(v_ccp(k,k,i)))/2
10      form(6) = form(6) - 4*e*e2*sq2/st*fcm(k)*dble(r)*c0_on(s,fcm(k))
      return
      end
 
      subroutine ffp_on_vert4(s,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0_on,feq
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        tmp = 8*e2*dimag(v_llp(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*(2*slm(k)*slm(k)*c0_on(s,slm(k)) - 1)
          form(4) = form(4) - tmp/4*(2/s + 4/s*feq(s,slm(k))
     1            - (1 + 4*slm(k)*slm(k)/s)*c0_on(s,slm(k)))
        end if
        tmp = 32/3.d0*e2*dimag(v_uup(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*(2*sum(k)*sum(k)*c0_on(s,sum(k)) - 1)
          form(4) = form(4) - tmp/4*(2/s + 4/s*feq(s,sum(k))
     1            - (1 + 4*sum(k)*sum(k)/s)*c0_on(s,sum(k)))
        end if
        tmp = 8/3.d0*e2*dimag(v_ddp(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*(2*sdm(k)*sdm(k)*c0_on(s,sdm(k)) - 1)
          form(4) = form(4) - tmp/4*(2/s + 4/s*feq(s,sdm(k))
     1                      - (1 + 4*sdm(k)*sdm(k)/s)*c0_on(s,sdm(k)))
        end if
20    continue
      return
      end

      subroutine ffp_on_vert(s,i,form)
c     Full FFP formfactor
      implicit double precision (a-h,o-z)
      logical vstat,fstat
      complex*16 form(6)
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      if (if.eq.1) call ffp_on_vert1(s,i,form)
      if (is.eq.1) call ffp_on_vert4(s,i,form)
      if (ic.eq.1) call ffp_on_vert2(s,i,form)
      do j=1,6
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end
 
