c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FPS_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains GAMMA-scalar-pseudoscalar vertex             c
c     formfactors and their renormalization.                          c
c                                                                     c
c     Incoming    GAMMA:           momentum (p+q)(\mu)                c
c     Outgoing pseudoscalar P(j):  momentum  p     (P_j = H^0_{j+2}   c
c     Outgoing scalar S(i)      :  momentum  q     (S_i = H^0_i)      c
c                                                                     c
c                                                                     c
c                               _______ P_j                           c
c                             /|                                      c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       GAMMA_{\mu}     /      |                                      c
c               ~~~~~~~~\      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  S_i                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437 available as       c
c       hep-ph-9303309:                                               c
c                                                                     c
c       V = p(mu) G_p + q(mu) G_q                                     c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
 
      subroutine fps_3vert2(p,q,pq,i,j,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      complex*16 v_lls,v_uus,v_dds
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        do 20 m=1,6
          tmp = 2*e*dble(v_llp(k,m,j)*v_lls(m,k,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) + tmp*(c0(slm(k),slm(m),slm(k))
     1              + 2*c11(slm(k),slm(m),slm(k)))
            form(2) = form(2) + tmp*(c0(slm(k),slm(m),slm(k))
     1              + 2*c12(slm(k),slm(m),slm(k)))
            call creset
          end if
          tmp = 4*e*dble(v_uup(k,m,j)*v_uus(m,k,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) + tmp*(c0(sum(k),sum(m),sum(k))
     1              + 2*c11(sum(k),sum(m),sum(k)))
            form(2) = form(2) + tmp*(c0(sum(k),sum(m),sum(k))
     1              + 2*c12(sum(k),sum(m),sum(k)))
            call creset
          end if
          tmp = 2*e*dble(v_ddp(k,m,j)*v_dds(m,k,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) + tmp*(c0(sdm(k),sdm(m),sdm(k))
     1              + 2*c11(sdm(k),sdm(m),sdm(k)))
            form(2) = form(2) + tmp*(c0(sdm(k),sdm(m),sdm(k))
     1              + 2*c12(sdm(k),sdm(m),sdm(k)))
            call creset
          end if
20    continue
      return
      end
 
      subroutine fps_3vert3(p,q,pq,i,j,form)
c     3 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/eps/eps(2,2)
      if (j.eq.2) return
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) + e*(e/st)**2*wm/2*eps(k,l)*v_hhs(i,k,l)
     1            *(c0(cm(k),cm(l),cm(k)) + 2*c11(cm(k),cm(l),cm(k)))
          form(2) = form(2) + e*(e/st)**2*wm/2*eps(k,l)*v_hhs(i,k,l)
     1            *(c0(cm(k),cm(l),cm(k)) + 2*c12(cm(k),cm(l),cm(k)))
10        call creset
      return
      end
 
      subroutine fps_3vert6(p,q,pq,i,j,form)
c     Charged Higgs + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e*(e/st)**2/2*am(i,j)*(1 + 6*c24(wm,cm(j),wm)
     1        + q*(2*c0(wm,cm(j),wm) + c11(wm,cm(j),wm)
     2        - c12(wm,cm(j),wm) + 2*c22(wm,cm(j),wm)
     3        + 2*c23(wm,cm(j),wm)) + pq*(6*c0(wm,cm(j),wm)
     4        + 7*c11(wm,cm(j),wm) + c12(wm,cm(j),wm)
     5        + 2*c21(wm,cm(j),wm) + 2*c23(wm,cm(j),wm)))
      form(2) = form(2) - e*(e/st)**2/2*am(i,j)*(1 + 6*c24(wm,cm(j),wm)
     1        + p*(6*c0(wm,cm(j),wm) + 7*c11(wm,cm(j),wm)
     2        + c12(wm,cm(j),wm) + 2*c21(wm,cm(j),wm)
     3        + 2*c23(wm,cm(j),wm)) + pq*(2*c0(wm,cm(j),wm)
     4        + c11(wm,cm(j),wm) - c12(wm,cm(j),wm)
     5        + 2*c22(wm,cm(j),wm) + 2*c23(wm,cm(j),wm)))
      call creset
      return
      end
 
      subroutine fps_3vert7(p,q,pq,i,j,form)
c     Charged Goldstone + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (j.eq.1) return
      form(1) = form(1) - e2*e2*zm/4*ct/st/st2*cr(i)*(c0(wm,wm,wm)
     1        - c11(wm,wm,wm))
      form(2) = form(2) + e2*e2*zm/4*ct/st/st2*cr(i)*c12(wm,wm,wm)
      call creset
      return
      end
 
      subroutine fps_3vert8(p,q,pq,i,j,form)
c     2 charged Higgs + W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) - e**3/2*zm*ct/st*v_hhs(i,2,j)*(c11(wm,cm(j),wm)
     1        + 2*c0(wm,cm(j),wm))
      form(2) = form(2) - e**3/2*zm*ct/st*v_hhs(i,2,j)*c12(wm,cm(j),wm)
      call creset
      return
      end
 
      subroutine fps_3vert9(p,q,pq,i,j,form)
c     Charged Higgs + charged Goldstone + W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      if (j.eq.2) return
      form(1) = form(1) - e**3/4/st2*wm2*am(i,1)*(c11(wm,cm(1),wm)
     1        + c0(wm,cm(1),wm))
      form(2) = form(2) - e**3/4/st2*wm2*am(i,1)*(c12(wm,cm(1),wm)
     1        - c0(wm,cm(1),wm))
      call creset
      return
      end
 
      subroutine fps_3vert13(p,q,pq,i,j,form)
c     3 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (j.eq.1) return
      form(1) = form(1) + e*(e/st)**3*wm/8*cr(i)*c0(wm,wm,wm)
      form(2) = form(2) + e*(e/st)**3*wm/8*cr(i)*c0(wm,wm,wm)
      call creset
      return
      end
 
      subroutine fps_3vert14(p,q,pq,i,j,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      complex*16 zpos,zneg
      complex*16 v_ccp,v_ccs
      complex*16 b,c,y,z
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 l=1,2
          b  = conjg(v_ccs(k,l,i)) + v_ccs(l,k,i)
          y  = conjg(v_ccs(k,l,i)) - v_ccs(l,k,i)
          c =  conjg(v_ccp(l,k,j)) - v_ccp(k,l,j)
          z =  conjg(v_ccp(l,k,j)) + v_ccp(k,l,j)
          form(1) = form(1) - e*e2/st2*(dble(b*c - y*z)
     1        *((p + 2*fcm(k)*fcm(k))*c11(fcm(k),fcm(l),fcm(k))
     2        + fcm(k)*fcm(k)*c0(fcm(k),fcm(l),fcm(k))
     3        + 2*p*c21(fcm(k),fcm(l),fcm(k))
     4        - q*c12(fcm(k),fcm(l),fcm(k))
     5        + 2*pq*c23(fcm(k),fcm(l),fcm(k)) + b0(q,fcm(l),fcm(k))
     6        + 2*c24(fcm(k),fcm(l),fcm(k)))
     7        + dble(b*c + y*z)*fcm(k)*fcm(l)
     8        *(c0(fcm(k),fcm(l),fcm(k)) + 2*c11(fcm(k),fcm(l),fcm(k))))
          form(2) = form(2) - e*e2/st2*(dble(b*c - y*z)
     1        *(p*c11(fcm(k),fcm(l),fcm(k)) + 0.5d0
     3        + p*c21(fcm(k),fcm(l),fcm(k)) - b1(q,fcm(l),fcm(k))
     3        + (p + 2*pq + 2*fcm(k)*fcm(k))*c12(fcm(k),fcm(l),fcm(k))
     4        + 2*(p + pq)*c23(fcm(k),fcm(l),fcm(k))
     5        + (q + 2*pq)*c22(fcm(k),fcm(l),fcm(k))
     6        + 4*c24(fcm(k),fcm(l),fcm(k)))
     7        + dble(b*c + y*z)*fcm(k)*fcm(l)
     8        *(c0(fcm(k),fcm(l),fcm(k)) + 2*c12(fcm(k),fcm(l),fcm(k))))
10          call creset
      return
      end
 
      subroutine fps_3vert16(p,q,pq,i,j,form)
c     2 charged Higgs + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e*e2/2/st2*am(i,j)*(0.5d0
     1        + 2*b0(q,wm,cm(j)) + 4*c24(cm(j),wm,cm(j))
     2        + 2*cm(j)*cm(j)*c11(cm(j),wm,cm(j))
     3        + p*(c21(cm(j),wm,cm(j)) - c0(cm(j),wm,cm(j))
     4        - 2*c11(cm(j),wm,cm(j))) + q*(2*c12(cm(j),wm,cm(j))
     5        + c22(cm(j),wm,cm(j)) + 4*c23(cm(j),wm,cm(j)))
     6        + 2*pq*(2*c21(cm(j),wm,cm(j)) + c23(cm(j),wm,cm(j))
     7        - c0(cm(j),wm,cm(j)) - c11(cm(j),wm,cm(j))))
      form(2) = form(2) + e*e2/2/st2*am(i,j)*(0.5d0
     1        - 2*b1(q,wm,cm(j)) + 8*c24(cm(j),wm,cm(j))
     2        + 2*cm(j)*cm(j)*c12(cm(j),wm,cm(j))
     3        + p*(c21(cm(j),wm,cm(j)) - c0(cm(j),wm,cm(j))
     4        - 2*c12(cm(j),wm,cm(j))) + q*(2*c12(cm(j),wm,cm(j))
     5        + 5*c22(cm(j),wm,cm(j))) - 2*pq*(c0(cm(j),wm,cm(j))
     6        - c11(cm(j),wm,cm(j)) + 2*c12(cm(j),wm,cm(j))
     7        - 3*c23(cm(j),wm,cm(j))))
      call creset
      return
      end
 
      subroutine fps_4vert3(p,q,pq,i,j,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) - e*e2/st2/2*am(i,j)*(2*b0(p,wm,cm(j))
     1        + b1(p,wm,cm(j)))
      return
      end

      subroutine fps_4vert4(p,q,pq,i,j,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(2) = form(2) + e*e2/st2/2*am(i,j)*(2*b0(q,wm,cm(j))
     1        + b1(q,wm,cm(j)))
      return
      end
  
      subroutine fps_vert(p,q,pq,i,j,form)
c     Full bare GAMMA-P-S formfactor 
      implicit double precision (a-h,o-z)
      complex*16 form(2)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do 10 k=1,2
 10     form(k) = (0,0)
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (is.eq.1) call fps_3vert2(p,q,pq,i,j,form)
      if (ig.eq.1) then
        call fps_3vert3(p,q,pq,i,j,form)
        call fps_3vert6(p,q,pq,i,j,form)
        call fps_3vert7(p,q,pq,i,j,form)
        call fps_3vert8(p,q,pq,i,j,form)
        call fps_3vert9(p,q,pq,i,j,form)
        call fps_3vert13(p,q,pq,i,j,form)
        call fps_3vert16(p,q,pq,i,j,form)
        call fps_4vert3(p,q,pq,i,j,form)
        call fps_4vert4(p,q,pq,i,j,form)
      end if
      if (ic.eq.1) call fps_3vert14(p,q,pq,i,j,form)
      do 20 k=1,2
 20     form(k) = form(k)/16/pi/pi
      return
      end
 
      subroutine fps_ren(p,q,pq,i,j,form)
c     Full renormalized GAMMA-P-S formfactor
      implicit double precision (a-h,o-z)
      complex*16 form(2)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      do 10 k=1,2
 10     form(k) = (0,0)
      if (.not.vstat) return
      call fps_vert(p,q,pq,i,j,form)
      form(1) = e/2*(dz2 - dza)*am(i,j) - form(1)
      form(2) = e/2*(dz2 - dza)*am(i,j) + form(2)
      return
      end





 


