c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: GGS_ON_V.FOR
c     Released: 28:10:1992
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains scalar - GLUON- GLUON vertex formfactor      c
c     proportional to (g(mu,nu) - q(mu)p(nu)/pq).                     c
c     On-shell expression.                                            c
c     Alpha QCD not included in that file.                            c
c                                                                     c
c     Incoming scalar S(i):  momentum (p+q)                           c
c     Outgoing GLUON      :  momentum  p^{\mu}                        c
c     Outgoing GLUON      :  momentum  q^{\nu}                        c
c                                                                     c
c                                                                     c
c                                       GLUON^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)  p^2=0             c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GLUON^\nu                    c
c                                     q (outgoing)  q^2=0             c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i F_1 (g(mu,nu) - q(mu)p(nu)/pq)                          c
c                                                                     c
c       s = (p + q)^2 = 2 pq                                          c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      complex*16 function ggs_on_vert1(s,i)
c     Quark contribution
      implicit double precision (a-h,o-z)
      complex*16 c0_on
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ggs_on_vert1 = 0
      do 10 k=1,3
        ggs_on_vert1 = ggs_on_vert1 + um(k)**2/v2*zr(2,i)
     1               * (2 + (s - 4*um(k)*um(k))*c0_on(s,um(k)))
10      ggs_on_vert1 = ggs_on_vert1 + dm(k)**2/v1*zr(1,i)
     1               * (2 + (s - 4*dm(k)*dm(k))*c0_on(s,dm(k)))
      return
      end
 
      complex*16 function ggs_on_vert2(s,i)
c     Squark contribution
      implicit double precision (a-h,o-z)
      complex*16 c0_on
      complex*16 v_uus,v_dds
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      ggs_on_vert2 = 0
      do 20 k=1,6
        ggs_on_vert2 = ggs_on_vert2 + dble(v_uus(k,k,i))/2
     1               * (1 - 2*sum(k)*sum(k)*c0_on(s,sum(k)))
20      ggs_on_vert2 = ggs_on_vert2 + dble(v_dds(k,k,i))/2
     1               * (1 - 2*sdm(k)*sdm(k)*c0_on(s,sdm(k)))
      return
      end
 
      complex*16 function ggs_on_vert(s,i)
c     Full ggs formfactor proportional to (g(mu,nu) - p(mu)q(u)/pq)
      implicit double precision (a-h,o-z)
      complex*16 ggs_on_vert1,ggs_on_vert2
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      ggs_on_vert = 0
      if (.not.vstat) return
      if (if.eq.1) ggs_on_vert = ggs_on_vert + ggs_on_vert1(s,i)
      if (is.eq.1) ggs_on_vert = ggs_on_vert + ggs_on_vert2(s,i)
      return
      end




