c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: HM_GRID.FOR
c     Released: 1: 7:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Package of procedures for simultaneous interpolation of       c
c     several multi-valued functions. For details see comments to   c
c     procedures mh_grid, mh_interp, mh_int_arr                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine find_branch(x,y,n,ierr,ndat)
c     this procedure cuts x array into branches of uniquness
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      dimension x(n),y(n)
      logical mhstat
      common/mhbranch/nbranch(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      if (n.eq.1) then
c     Cannot interpolate from one point
        ierr = 1
        return
      end if
c     i enumerates the current position in x array
      i = 1
c     nbr counts number of branches
      nbr = 0
c     Scan x array to isolate branches
10    continue
c     Skip starting x values if equal to each other
20    if (x(i).eq.x(i+1)) then
        i = i + 1
        if (i.eq.n) then
c     No more points; if all values of x equal - interpolation impossible
          if (nbr.eq.0) ierr = 2
          nbranch(ndat) = nbr
          return
        end if
        goto 20
      end if
c     increase branch number
      nbr = nbr + 1
c     check if not to many branches
      if (nbr.gt.ibr) then
        ierr = 3
        return
      end if
c     ib is the index in the actual branch;  reset it to 1 now
      ib = 1
c     Check if x values in the branch are decresing or increasing
c     Next store branch in common/mhbranch/
      if (x(i+1).lt.x(i)) then
30      h(ndat,ib,nbr) = x(i)
        f(ndat,ib,nbr) = y(i)
        if (i.eq.n) goto 40
        if (x(i+1).ge.x(i)) goto 40
          i = i + 1
          ib = ib + 1
          goto 30
40      ibmax(ndat,nbr) = ib
c     Sort branch in increasing order
        do 50 j=1,ibmax(ndat,nbr)/2
          tmp1 = h(ndat,j,nbr)
          tmp2 = f(ndat,j,nbr)
          h(ndat,j,nbr) = h(ndat,ibmax(ndat,nbr)+ 1 - j,nbr)
          f(ndat,j,nbr)  = f(ndat,ibmax(ndat,nbr) + 1 - j,nbr)
          h(ndat,ibmax(ndat,nbr) + 1 - j,nbr) = tmp1
50        f(ndat,ibmax(ndat,nbr) + 1 - j,nbr)  = tmp2
      else
60      h(ndat,ib,nbr) = x(i)
        f(ndat,ib,nbr)  = y(i)
        if (i.eq.n) goto 70
        if (x(i+1).le.x(i)) goto 70
          i = i + 1
          ib = ib + 1
          goto 60
70      ibmax(ndat,nbr) = ib
      end if
c     Check if number of points in branch not too big
      if (ibmax(ndat,nbr).gt.npoint) then
        ierr = - nbr
        return
      end if
c     Quit if entire input data arrays classified
      if (i.eq.n) then
        nbranch(ndat) = nbr
        return
      end if
      goto 10
      end

      subroutine mh_splin(ierr,ndat)
c     this procedure and evaluates interpolation coefficients for 
c     later calculations
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      dimension x(npoint),y(npoint),bb(npoint),cc(npoint),dd(npoint)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      do 10 i=1,nbr(ndat)
        if (ibmax(ndat,i).eq.2) then
c     Two points allows only linear intepolation
          spc(ndat,1,1,i) = (f(ndat,2,i) - f(ndat,1,i))
     1                     /(h(ndat,2,i) - h(ndat,1,i))
          spc(ndat,1,2,i) = f(ndat,2,i) - spc(ndat,1,1,i)*h(ndat,2,i)
        else if (ibmax(ndat,i).eq.3) then
c     Three points allows parabolic intepolation
          a = (f(ndat,1,i) - f(ndat,2,i))/(h(ndat,1,i) - h(ndat,2,i))
          b = (f(ndat,2,i) - f(ndat,3,i))/(h(ndat,2,i) - h(ndat,3,i))
          spc(ndat,1,1,i) = (a - b)/(h(ndat,1,i) - h(ndat,3,i))
          spc(ndat,1,2,i) = a - spc(ndat,1,1,i)
     1                    *(h(ndat,1,i) + h(ndat,2,i))
          spc(ndat,1,3,i) = f(ndat,1,i) - h(ndat,1,i)
     1                 *(spc(ndat,1,1,i)*h(ndat,1,i) + spc(ndat,1,2,i))
        else
c     For more than three points calculate coefficients of cubic spline
c     Rewrite proper part of common/mhbranch/ to temporary arrays
          do 20 j=1,ibmax(ndat,i)
            x(j) = h(ndat,j,i)
20          y(j) = f(ndat,j,i)
          call splin3(x,y,bb,cc,dd,ibmax(ndat,i),ierrspl)
c     Check errors
          if (ierrspl.ne.0) ierr = ierrspl + 3
c     Store calculated derivatives in common/mhbranch/
          do 30 j=1,ibmax(ndat,i)
            spc(ndat,1,j,i) = bb(j)
            spc(ndat,2,j,i) = cc(j)
30          spc(ndat,3,j,i) = dd(j)
        end if
10      continue
      end

      subroutine mh_interp(z,val,nb,nbmax,ndat)
c     this procedure calculates set of function values for given z
c     parameter:
c     ndat:  type of function to evaluate (for example ndat=1 gives data set 1,
c            ndat=2 gives data set 2 or similar, depending on parameters intro-
c            duced  in mh_grid
c     z:     point in which function values should be calculates
c     nbmax: number of branches containing point z inside
c     val:   array containing nbmax possible function values in point z
c     nb:    integer array containing branch numbers corresponding to
c            values stored in val

      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      dimension val(ibr),nb(ibr)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      if (mhstat(ndat)) then
c     nbmax counts number of possible values.  Initialize it here
        nbmax = 0
      else
c     mh_grid failed or not executed yet for this value of ndat.
c     cannot interpolate until mhstat(ndat)=.false.
        nbmax = -1
        return
      end if
      do 10 i=1,nbr(ndat)
        if ((z.lt.h(ndat,1,i)).or.(z.gt.h(ndat,ibmax(ndat,i),i)))
     1                                                           goto 10
        nbmax = nbmax + 1
        if (ibmax(ndat,i).eq.2) then
c     Two points allows only linear intepolation
          val(nbmax) = z*spc(ndat,1,1,i) + spc(ndat,1,2,i)
          nb(nbmax)  = i
        else if (ibmax(ndat,i).eq.3) then
c     Three points allows parabolic intepolation
          val(nbmax) = z*z*spc(ndat,1,1,i) + z*spc(ndat,1,2,i)
     1               + spc(ndat,1,3,i)
          nb(nbmax)  = i
        else
c     For more than three points use cubic spline
c     Find range number to which z belongs
          do 20 j=2,ibmax(ndat,i)-1
            k = j - 1
            if (z.lt.h(ndat,j,i)) goto 30
20          k = ibmax(ndat,i) - 1
30        t = z - h(ndat,k,i)
c     Evaluate function
          val(nbmax) = ((spc(ndat,3,k,i)*t + spc(ndat,2,k,i))*t
     1               + spc(ndat,1,k,i))*t + f(ndat,k,i)
          nb(nbmax)  = i
        end if
10      continue
      end

      subroutine mh_int_arr(z,n,val,nb,nbmax,ndat,ndim,ierr)
c     this procedure calculates set of function values for given
c     array of (increasingly ordered!) z parameters:
c     ndat:  type of function to evaluate (for example ndat=1 gives data set 1,
c            ndat=2 gives data set 2 or similar, depending on parameters intro-
c            duced  in mh_grid
c     z:     array of points in which function values should be calculates
c     n:     number of points in the z array
c     nbmax: number of branches containing point z inside
c     val:   array containing nbmax possible function values in z points
c     nb:    integer array containing branch numbers corresponding to
c            values stored in val
c     ndim:  first dimension parameter size of the z, val and nb arrays
c            in the calling routine
c     ierr:  error parameter:
c        0 - routine executed succesfully
c        1 - ie. mh_grid failed or not executed yet for this value of ndat.
c        >1 - points in z array not increasingly ordered (ierr = 1 +
c             number of point for which proper ordering is broken)

      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      dimension val(ndim,ibr),nb(ndim,ibr),z(ndim),nbmax(ndim),l(ibr)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
c     Initialize error parameter
      ierr = 0
c     Check if interpolation polynomials are initialized
      if (.not.mhstat(ndat)) then
c     cannot interpolate until mhstat(ndat)=.false.
        ierr = 1
        return
      end if
c     Initialize starting search point for the cubic spline in each branch
      do 5 j=1,nbr(ndat)
5       l(j) = 1
c     Main loop over points in the z array
      do 10 i=1,n
c     Check for correct ordering of the z points
        if ((i.ne.n).and.(z(i+1).lt.z(i))) then
          ierr = i + 1
          return
        end if
c     nbmax counts number of possible values.  Initialize it here
        nbmax(i) = 0
c     loop over possible branches
        do 10 j=1,nbr(ndat)
c      check if z(i) inside branch limits
          if ((z(i).lt.h(ndat,1,j)).or.
     1        (z(i).gt.h(ndat,ibmax(ndat,j),j))) goto 10
          nbmax(i) = nbmax(i) + 1
          if (ibmax(ndat,j).eq.2) then
c     Two points allows only linear intepolation
            val(i,nbmax(i))  = z(i)*spc(ndat,1,1,j) + spc(ndat,1,2,j)
            nb(i,nbmax(i)) = j
          else if (ibmax(ndat,j).eq.3) then
c     Three points allows parabolic intepolation
            val(i,nbmax(i)) = z(i)*z(i)*spc(ndat,1,1,j)
     1                      + z(i)*spc(ndat,1,2,j) + spc(ndat,1,3,j)
            nb(i,nbmax(i))  = j
          else
c     For more than three points use cubic spline
c     Find range number to which z(i) belongs
            do 20 k=l(j)+1,ibmax(ndat,j)-1
              if (z(i).lt.h(ndat,k,j)) then
                l(j) = k - 1
                goto 30
              end if
20            continue
              l(j) = ibmax(ndat,j) - 1
c     Calculate "reduced" argument for the interpolation polynomial
30          t = z(i) - h(ndat,l(j),j)
c     Evaluate function
            val(i,nbmax(i)) = ((spc(ndat,3,l(j),j)*t
     1                      + spc(ndat,2,l(j),j))*t
     2                      + spc(ndat,1,l(j),j))*t + f(ndat,l(j),j)
            nb(i,nbmax(i))  = j
          end if
10        continue
      end

      subroutine splin3(x,y,b,c,d,n,ierr)
c     Natural spline approximation of the third order
c     x,y   - input arrays of size 1..n
c     n     - number of points in input arrays
c     b,c,d - coefficients of spline polynomials
c     ierr  - error signalization:
c        0 - no errors encountered
c        1 - cubic spline impossible for less than four points
c        2 - x-values not in increasing order
      implicit double precision (a-h,o-z)
      dimension x(n),y(n)
      dimension b(n),c(n),d(n)
c     Check for possible errors
      if (n.lt.4) then
        ierr = 1
        return
      end if
      ierr = 2
      do 10 i=1,n-1
10      if (x(i + 1).le.x(i)) return
c     No errors
      ierr = 0
c     Evaluate c* coefficients
      b(1) = 2
      d(1) = ((y(3) - y(2))/(x(3) - x(2)) - (y(2) - y(1))/(x(2) - x(1)))
     1    /(x(3) - x(1))
      do 20 i=1,n-3
        u = (x(i+2) - x(i+1))/(x(i+2) - x(i))
        w = (x(i+2) - x(i+1))/(x(i+3) - x(i+1))
        b(i+1) = 2 - u*w/b(i)
20      d(i+1) = ((y(i+3) - y(i+2))/(x(i+3) - x(i+2))
     1         - (y(i+2) - y(i+1))/(x(i+2) - x(i+1)))
     2         /(x(i+3) - x(i+1)) - d(i)*w/b(i)
      c(n-1) = d(n-2)/b(n-2)
      do 30 i=2,n-2
        w = (x(n-i+1) - x(n-i))/(x(n-i+1) - x(n-i-1))
30      c(n-i) = (d(n-i-1) - w*c(n-i+1))/b(n-i-1)
      c(1) = 0
      c(n) = 0
c     Evaluate spline polynomials coefficients;
      do 40 i=1,n-1
        b(i) = (y(i+1) - y(i))/(x(i+1) - x(i))
     1       - (x(i+1) - x(i))*(c(i+1) + 2*c(i))
        d(i) = (c(i+1) - c(i))/(x(i+1) - x(i))
40      c(i) = 3*c(i)
      return
      end

      subroutine mh_grid(x,y,n,ierr,ndat)
c     this procedure cuts x array into branches of uniqness and
c     evaluates interpolation coefficients for for each branch
c     parameters:
c     x:      array storing data points; to be cut into branches
c     y:      function values correspoding to x points
c     n:      number of points stored in x,y arrays
c     ierr:   error status; ierr=0 if everything is OK
c     ndat:   number identifying input data given in x,y arrays

      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      dimension x(n),y(n)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      external init_mh_grid
c     reset error flag and interpolation status
      ierr = 0
      if (ndat.gt.nod) then
        ierr = 6
        return
      end if
      mhstat(ndat) = .false.
c     possible errors
c     ierr = 1:  n equal to 1, cannot interpolate from one point
c     ierr = 2:  x(1) = x(2) = ... = x(n) - all values equal, no branches
c     ierr = 3:  more then ibr branches - increase ibr parameter to
c     accumulate all of them
c     ierr < 0:  more then npoint points in branch (-ierr)
c     ierr = 4 or 5:  error in splin3 procedure (ierr = 3 + error number
c                     reported by splin3)
c     ierr = 6:  ndat greater than nod (nod = maximal number of interpolated
c     arrays which can be stored)
c     first divide data into branches
      call find_branch(x,y,n,ierr,ndat)
      if (ierr.ne.0) return
c     find and store interpolation coefficients
      call mh_splin(ierr,ndat)
c     interpolation succesful?
      if (ierr.eq.0) mhstat(ndat) = .true.
      return
      end

      logical function mh_stat(ndat)
c     checks if ndat entry is already in use
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      mh_stat = mhstat(ndat)
      return
      end

      subroutine mh_reset(ndat)
c     reset ndat entry status to 'unitialized'
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      mhstat(ndat) = .false.
      return
      end

      subroutine mh_par(np,ib,nd)
c     returns dimension of package arrays
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      np = npoint
      ib = ibr
      nd = nod
      return
      end

      block data init_mh_grid
c     initialization of interpolation status - no interpolation possible
c     before executing mh_grid at least one time
      implicit double precision (a-h,o-z)
      parameter(npoint=30,ibr=6,nod=10)
      logical mhstat
      common/mhbranch/nbr(nod),h(nod,npoint,ibr),f(nod,npoint,ibr),
     1                spc(nod,3,npoint,ibr),ibmax(nod,ibr),mhstat(nod)
      common/pi/pi
      data pi/3.1415926535d0/
      data mhstat/nod*.false./
      end




