c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: HM_INV.FOR
c     Released: 23 May 1995 (J.R.)

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains routines for calculations of tan(beta) for      c
c     given m_A,m_h and SUSY parameters                                  c
c     See comments in the headers of subroutines mh_limits and tan_beta  c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine mh_limits(hmin,hmax,pm,tm,am,amsq,amsl,amg,ys,n,iout)
c     hmin and hmax returns maximal and minimal scalar mass value
c     for given mtop and set of SUSY parameters
c     n is the Higgs index (1=H, 2=h)
c     Other parameters defined as in subroutine set_par
      implicit double precision (a-h,o-z)
      parameter(itdim=28)
      logical tb_aux_stat
      common/tb_inv/tb(itdim),h(itdim),ierr(itdim),
     1              hmin0,hmax0,errin,isucc
      common/hm_phys/frm(2),frm2(2)
      external init_mh_invert
      iout = 0
      if (tb_aux_stat(n,pm,tm,am,amsq,amsl,amg,ys)) then
        if (isucc.ne.0) then
          hmin = hmin0
          hmax = hmax0
          if (isucc.eq.1) iout = 5
         else
          hmin = 0
          hmax = 0
          iout = 4
         end if
         return
      end if 
      isucc = 0
      hmin = 1d20
      hmax = - 1.d20
      call set_tb_aux(n,pm,pm,tm,am,amsq,amsl,amg,ys)
      do 10 i=1,itdim
        h(i) = 0    
        call set_par(tb(i),pm,tm,am,amsq,amsl,amg,ys,ierr(i))
        if (ierr(i).ne.0) goto 10
        call gr_const
        call hr_const
        call hm_solve(ierr(i),errin,errout)
        if (ierr(i).ne.0) goto 10
        h(i) = frm(n)
        hmin = min(hmin,h(i))
        hmax = max(hmax,h(i))
        isucc = isucc + 1
 10     continue
      hmin0 = hmin
      hmax0 = hmax
      if (isucc.ge.2) return
      iout = isucc + 4
      return
      end

      subroutine tan_beta(res,ir,hm,pm,tm,am,amsq,amsl,amg,ys,n,iout)
c     hm is the input scalar mass (mH for n=1, mh for n=2)
c     array res contains ir possible solutions for tan(beta) values
c     Other parameters defined as in subroutine set_par
      implicit double precision (a-h,o-z)
      parameter(itdim=28,nroot=10)
      dimension tt(itdim),hh(itdim)
      dimension vt(nroot),val(nroot),nb(nroot),res(nroot)
      logical mh_stat
      common/tb_inv/tb(itdim),h(itdim),ierr(itdim),
     1              hmin0,hmax0,errin,isucc

c     reset error flag
      iout = 0
c     find free interpolation array
      ndat = 0
      call mh_par(npoint,ibr,nod)
      do nd=nod,1,-1
        if (.not.mh_stat(nd)) then
          ndat = nd
          goto 10 
        end if
      end do
c     No free interpolation array, clean something first
      iout = 1
      return
 10   nvt = 0
      i1 = 0
      call mh_limits(hmin,hmax,pm,tm,am,amsq,amsl,amg,ys,n,iout)
      if (iout.ne.0) return
      if ((hm.lt.hmin).or.(hm.gt.hmax)) then
        iout = 6
        return
      end if
 20   i1 = i1 + 1
      if (i1.gt.itdim) goto 100
      if (ierr(i1).ne.0) goto 20      
 30   i2 = i1
 40   tt(i2 - i1 + 1) = tb(i2)
      hh(i2 - i1 + 1) = h(i2)
      i2 = i2 + 1  
      if ((ierr(i2).eq.0).and.(i2.le.itdim)) goto 40 
      if ((i2 - i1).gt.1) then
        call mh_grid(hh,tt,i2 - i1,ierror,ndat)
        if (ierror.eq.0) then
          call mh_interp(hm,val,nb,nbmax,ndat)
          if (nbmax.gt.0) then
            do i = 1,nbmax
              nvt = nvt + 1
              if (nvt.gt.nroot) stop 'increase vt size in mh_invert'
              vt(nvt) = val(i)
            end do
          end if
        end if
      end if
      i1 = i2 
      goto 20
 100  call mh_reset(ndat)
      if (nvt.eq.0) then
c     No solutions
        iout = 2
        return
      end if
c     Find exact tan(beta) values
      ir = 0
      call set_tb_aux(n,hm,pm,tm,am,amsq,amsl,amg,ys)
      do i=1,nvt
        call tb_find(vtb,vt(i),ierror)
        if (ierror.eq.0) then
          ir = ir + 1
          res(ir) = vtb
        end if
      end do 
      if (ir.eq.0) then
c     No solutions (?)
        iout = 3
        return
      end if
      return
      end

      subroutine tb_find(vtb,vtold,ierr)
      implicit double precision (a-h,o-z)
      parameter(itdim=28,maxiter=20)
      common/tb_inv/tb(itdim),h(itdim),ierror(itdim),
     1              hmin,hmax,errin,isucc
      ierr = 0
      fact = 1.05d0
      do 10 i=1,5
        xl = vtold/fact
        xr = vtold*fact
        fact = fact*fact
        call hm_find(xl,fl,ierrl)
        if (ierrl.ne.0) goto 10
        call hm_find(xr,fr,ierrr)
        if ((ierrr.eq.0).and.(fl*fr.le.0)) goto 20
 10     continue
 20   if ((ierrl.ne.0).or.(ierrr.ne.0).or.(fl*fr.gt.0)) then
        ierr = - 1
        return
      end if
      vtb = tb_falsi(xl,xr,errin,errout,maxiter,ierr)
      return
      end
      
      subroutine hm_find(tanb,xm,ierr)
      implicit double precision (a-h,o-z)
      parameter (itdim=28)
      common/tb_inv/tb(itdim),h(itdim),ierror(itdim),
     1              hmin,hmax,errin,isucc
      common/tb_aux/hm,pm,tm,am,amsq,amsl,amg,ys,n
      common/hm_phys/frm(2),frm2(2)
      call set_par(tanb,pm,tm,am,amsq,amsl,amg,ys,ierr)
      if (ierr.ne.0) return
      call gr_const
      call hr_const
      call hm_solve(ierr,errin,errout)
      xm = frm(n) - hm
      return
      end
 
      double precision function tb_falsi(xa,xb,err,errout,imax,istat)
      implicit double precision (a-h,o-z)
      x0 = xa
      x1 = xb
      tb_falsi = (x1 + x2)/2 
      i  = 0
      call hm_find(x0,f0,istat)
      call hm_find(x1,f1,istat)
10    x2 = x1 - (x1 - x0)/(f1 - f0)*f1
      errout = abs(x2 - x1)
      if (errout.lt.err) then
        tb_falsi = (x1 + x2)/2 
        return
      end if
      x0 = x1
      x1 = x2
      f0 = f1
      call hm_find(x1,f1,istat)
      if (istat.ne.0) return
      i  = i + 1
      if (i.gt.imax) then
        istat = istat + 10
        tb_falsi = 0
        return
      end if
      goto 10
      end
       
      subroutine set_tb_aux(n,hm,pm,tm,am,amsq,amsl,amg,ys)
      implicit double precision (a-h,o-z)
      common/tb_aux/hm0,pm0,tm0,am0,amsq0,amsl0,amg0,ys0,n0
      n0    = n
      hm0   = hm
      pm0   = pm
      tm0   = tm
      am0   = am
      amsq0 = amsq
      amsl0 = amsl
      amg0  = amg
      ys0   = ys
      return
      end        

      logical function tb_aux_stat(n,pm,tm,am,amsq,amsl,amg,ys)
      implicit double precision (a-h,o-z)
      common/tb_aux/hm0,pm0,tm0,am0,amsq0,amsl0,amg0,ys0,n0
      common/parcont/if,is,ig,ic,in,iq,il
      if ((n.ne.n0).or.(pm.ne.pm0).or.
     1    ((tm.ne.tm0).and.(if.ne.0)).or.
     2    ((am.ne.am0).and.(ig*ic*in*is.ne.0)).or.
     3    ((amsq.ne.amsq0).and.(is.ne.0)).or.
     4    ((amsl.ne.amsl0).and.(is.ne.0)).or.
     5    ((amg.ne.amg0).and.(ic*in.ne.0)).or.
     6    ((ys.ne.ys0).and.(is.ne.0))) then
        tb_aux_stat = .false.
      else
        tb_aux_stat = .true.
      end if
      return
      end        

      block data init_mh_invert
      implicit double precision (a-h,o-z)
      parameter(itdim=28)
      common/tb_inv/tb(itdim),h(itdim),ierr(itdim),
     1              hmin,hmax,errin,isucc
      common/tb_aux/susy_par(8),n
      data susy_par,n/8*1.d6,-1/
      data tb/0.5d0,0.6d0,0.7d0,0.8d0,0.9d0,0.97d0,1.03d0,1.1d0,1.3d0,
     1        1.5d0,2.d0,2.5d0,3.d0,3.5d0,4.d0,4.5d0,5.d0,6.d0,7.d0,
     2        8.d0,9.d0,10.d0,12.d0,15.d0,20.d0,25.d0,35.d0,50.d0/
      data hmin,hmax,errin,isucc/2*0.d0,1.d-2,-1/
      data h,ierr/itdim*0.d0,itdim*0/
      end 


 



