c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: HM_PHYS.FOR
c     Last revised: 5:12:1993(J.R.)
c     1-loop massed calculated in hm_solve forced to be orderded: m_h < m_H
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains subroutines solving equation for the physical  c
c     (radiatively corrected) MSSM neutral scalar Higgs boson masses.   c
c     See: Chankowski,Pokorski,Rosiek@preprint MPI-Ph 92/117            c
c     available as  hep-ph-9303309 from the Trieste e-mail              c
c     preprint library.                                                 c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine hm_solve(istat,errin,errout)
      parameter (maxint=30)
      implicit double precision (a-h,o-z)
      logical hstat
      double precision s_det,red_det
      dimension appr(2),err(2),root_old(2),root_new(2)
      common/hm_phys/frm(2),frm2(2)
      common/hm_stat/hstat
      common/hm_root/root
      external s_det,red_det
      istat = 0
c     Calculate approximate masses first
      call hm_approx(appr)
c     Initialize
      do 10 i=1,2
10      root_old(i) = appr(i)
c     Iterate equation for full physical masses
      do 20 j=1,maxint
        do 30 i=1,2
c     New approach for pole of scalar propagator
          root_new(i) = s_mass(root_old(i),3 - 2*i)
c     Approximate error of pole
          err(i) = abs(root_new(i) - root_old(i))
c     Calculate m_h^2 and m_H^2
          frm2(i) = root_new(i)
c     Starting value for next iteration
30        root_old(i) = root_new(i)
c     Common error for m_h, m_H
        errout = max(err(1),err(2))
c     Quit if required accuracy already achieved
20      if (errout.le.errin) goto 100
c     Maximum number of iterations exceeded; store error code in istat
      if ((err(1).gt.errin).and.(err(2).le.errin)) then
        istat = 1
      else if ((err(2).gt.errin).and.(err(1).le.errin)) then
        istat = 2
      else 
        istat = 3
      end if
c     Try other procedure
      frm2(1) = falsi(s_det,appr(1),appr(1) + 100,
     1                errin,errout,maxint,istat)
c     quit if with positive error status
      if (istat.gt.10) return
      root = frm2(1)
      frm2(2) = falsi(red_det,appr(2),appr(2) - 40,
     1                errin,errout,maxint,istat)
c     quit if with positive error status
      if (istat.gt.10) return
c     Calculation succesful
100   hstat = .true.
      istat = 0
c     Calculate m_h and m_H; if m^2<0 then m = - sqrt(-m^2)
      frm(1) = sign(1.d0,frm2(1))*sqrt(abs(frm2(1)))
      frm(2) = sign(1.d0,frm2(2))*sqrt(abs(frm2(2)))
c     If m_h^2 > m_H^2 reverse mass order and set istat to -1 (warning)
      if (frm2(1).lt.frm2(2)) then
        istat = - 1
        call switch_order(frm2(1),frm2(2))
        call switch_order(frm(1),frm(2))
      end if
      return
      end

      subroutine hm_approx(appr)
c     Approximate formulas for m_h,H^2; accurate up to 2-5 GeV.
      implicit double precision (a-h,o-z)
      complex*16 s_ren
      dimension appr(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zhtmp(2,2)
      common/fmass/em(3),um(3),dm(3)
      zero = 1.d-2
      fm1 = dble(s_ren(zero,1,1)) + rm(1)*rm(1)
      fm2 = dble(s_ren(zero,2,2)) + rm(2)*rm(2)
      del = dble(s_ren(zero,1,2))
      z = alpha/16/pi*um(3)**2/st2/wm2*3.d0*(st2 - ct2)
      delta = sqrt((1 - 2*z)*(fm1 - fm2)**2
     1      + (z*(fm1 + fm2) + 2*(1 - z)*del)**2)
      b = (1 - z)*(fm1 + fm2) + 2*z*del
      appr(1) = (b + delta)/2/(1 - 2*z)
      appr(2) = (b - delta)/2/(1 - 2*z)
      return
      end

      subroutine switch_order(a,b)
      implicit double precision (a-h,o-z)
      tmp = a
      a = b
      b = tmp
      return
      end

      double precision function s_mass(s,is)
      implicit double precision (a-h,o-z)
      complex*16 s_ren
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      a = rm(1)*rm(1) + dble(s_ren(s,1,1))
      b = rm(2)*rm(2) + dble(s_ren(s,2,2))
c     Second-order non-leading imaginary terms are doubtful. Neglect?
      c = dble(s_ren(s,1,2))**2
     1  - imag(s_ren(s,1,2))**2 + imag(s_ren(s,1,1))*imag(s_ren(s,2,2))
      s_mass = (a + b + is*sqrt(abs((a - b)**2 + 4*c)))/2
      return
      end
  
      double precision function falsi(fun,xa,xb,err,errout,imax,istat)
      implicit double precision (a-h,o-z)
      external fun
      x0 = xa
      x1 = xb
      i  = 0
      f0 = fun(x0)
      f1 = fun(x1)
10    x2 = x1 - (x1 - x0)/(f1 - f0)*f1
      errout = abs(x2 - x1)
      if (errout.lt.err) then
        falsi = (x1 + x2)/2 
        return
      end if
      x0 = x1
      x1 = x2
      f0 = f1
      f1 = fun(x1)
      i  = i + 1
      if (i.gt.imax) then
        istat = istat + 10
        falsi = 0
        return
      end if
      goto 10
      end

      double precision function red_det(x)
      implicit double precision (a-h,o-z)
      common/hm_root/root
      eps = 1.d-6
      if (x.ne.root) then
        red_det = s_det(x)/(x - root)
      else
        red_det = (s_det(x*(1 + eps)) - s_det(x*(1 - eps)))/2/eps/x
      end if
      return
      end

      double precision function s_det(s)
      implicit double precision (a-h,o-z)
      complex*16 s_ren
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_det = dble((s - rm(1)*rm(1) - s_ren(s,1,1))
     1      *(s - rm(2)*rm(2) - s_ren(s,2,2)) - s_ren(s,1,2)**2)
      return
      end




