c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: S_GAM.FOR
c     Released: 28:10:1992
c     Last revised: 5:02:1994 (J.R.)
c     Decays S->sfermions added
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the widths and branching ratios for the scalar decay  c
c     function gam_s(i,gam_arr,br_arr) outputs decay widths and           c
c     branching ratios for the scalar S_i. The entries of the             c
c     arrays gam_arr and br_arr are described below.                      c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function gam_s(i,gam_arr,br_arr)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Total decay width of scalar (gam_s); partial decay          c
c     widths (gam_arr); scalar decay branching ratios (br_arr)    c
c     Decays numeration:                                          c
c     1:      S -> ZZ                                             c
c     2:      S -> Zgamma                                         c
c     3:      S -> gamma + gamma                                  c
c     4-6:    S -> ll                                             c
c     7-9:    S -> uu                                             c
c     10-12:  S -> dd                                             c
c     13:     S -> gg                                             c
c     14-17:  S -> 2 neutralino (identical)                       c
c     18-23:  S -> neutralino + neutralino (not identical)        c
c     24-25:  S -> 2 chargino (identical with opposite charge)    c
c     26:     S -> chargino + chargino (not identical)            c
c             attention: decays into c1+c2- ad c1-c2+ summed      c
c     27:     S -> AA                                             c
c     28:     S -> SS                                             c
c     29:     S -> H+H-                                           c
c     30:     S -> W+H-,W-H+                                      c
c     31:     S -> W+W-                                           c
c     32:     S -> ZP                                             c
c     33-35:  S -> 2 sneutrino (identical)                        c
c     36-41:  S -> 2 sleptons (identical)                         c
c     42-56:  S -> slepton + slepton (not identical)              c
c             attention: decays into Li+Lj- and Li-Lj+ summed     c
c     57-62:  S -> 2 up-squarks (identical)                       c
c     63-77:  S -> up-squark + up-squark (not identical)          c
c             attention: decays into Ui+Uj- and Ui-Uj+ summed     c
c     78-83:  S -> 2 down - squarks (identical)                   c
c     84-98:  S -> down-squark + down-squark (not identical)      c
c             attention: decays into Di+Dj- and Di-Dj+ summed     c
c     Three-body decays (very small?) - not included!             c
c     H --> 3h                                                    c
c     H --> hAA                                                   c
c     H --> hH+H-                                                 c
c     H --> WWh,ZZh                                               c
c     H --> ZW-H+,FW-H+                                           c
c     H --> LLh,UUh,DDh,vvh                                       c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision (a-h,o-z)
      parameter (max_gam = 98)
      dimension gam_arr(max_gam),br_arr(max_gam)
c     S -> ZZ
      gam_arr(1) = gam_s_zz(i)
c     S -> Zgamma
      gam_arr(2) = gam_s_fz(i)
c     S -> 2gamma
      gam_arr(3) = gam_s_ff(i)
c     S -> ll, S -> uu, S -> dd
      do 10 j=1,3
        gam_arr(j + 3) = gam_s_ll(i,j)
        gam_arr(j + 6) = gam_s_uu(i,j)
10      gam_arr(j + 9) = gam_s_dd(i,j)
c     S -> gg
      gam_arr(13) = gam_s_gg(i)
c     S -> 2neutralino
      do 20 j=1,4
20      gam_arr(j + 13) = gam_s_nn(i,j,j)
c     S -> neutralino + neutralino (not identical)
      ind = 17
      do 30 j=1,3
        do 30 k=j+1,4
          ind = ind + 1
30        gam_arr(ind) = 2*gam_s_nn(i,j,k)
c     S -> 2chargino
      do 40 j=1,2
40      gam_arr(j + 23) = gam_s_cc(i,j,j)
c     S -> chargino + chargino (not identical)
c          attention: decays into c1+c2- ad c1-c2+ summed
      gam_arr(26) = 2*gam_s_cc(i,1,2)
c     S -> AA
      gam_arr(27) = gam_s_aa(i)
c     S -> SS
      gam_arr(28) = gam_s_ss(i)
c     S -> H+H-
      gam_arr(29) = gam_s_hh(i)
c     S -> W+H-,W-H+
      gam_arr(30) = gam_s_wh(i)
c     S -> W+W-
      gam_arr(31) = gam_s_ww(i)
c     S -> ZP
      gam_arr(32) = gam_s_zp(i)
c     S -> vv (sneutrinos)
      do 50 j=1,3
50      gam_arr(j + 32) = gam_s_vv(i,j)
c     S -> LL
      do 60 j=1,6
60      gam_arr(j + 35) = gam_s_sll(i,j,j)
c     S -> L + L (not identical)
      ind = 41
      do 70 j=1,5
        do 70 k=j+1,6
          ind = ind + 1
70        gam_arr(ind) = 2*gam_s_sll(i,j,k)
c     S -> UU
      do 80 j=1,6
80      gam_arr(j + 56) = gam_s_suu(i,j,j)
c     S -> U + U (not identical)
      ind = 62
      do 90 j=1,5
        do 90 k=j+1,6
          ind = ind + 1
90        gam_arr(ind) = 2*gam_s_suu(i,j,k)
c     S -> DD
      do 100 j=1,6
100     gam_arr(j + 78) = gam_s_sdd(i,j,j)
c     S -> D + D (not identical)
      ind = 83
      do 110 j=1,5
        do 110 k=j+1,6
          ind = ind + 1
110       gam_arr(ind) = 2*gam_s_sdd(i,j,k)
c     Total width
      gam_s = 0
      do 1000 j=1,max_gam
1000    gam_s = gam_s + gam_arr(j)
c     Branching ratios
      do 1100 j=1,max_gam
1100    br_arr(j) = gam_arr(j)/gam_s
      return
      end
 
      double precision function gam_s_zz(i)
c     Width of the decay of scalar into Z boson pair
      implicit double precision (a-h,o-z)
      complex*16 fg1,fg2,fs1,fs2,h1,h2,fact,zzs(6)
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*zm) then
        gam_s_zz = 0
        return
      end if
      p = zm2
      q = frm2(i)
      pq = - q/2
      x = q/p/2 - 1
      call zzs_ren(p,q,pq,i,zzs)
      fg1 = 2*sct2/e2*zzs(1)
      fs1 = 2*sct2/e2*(zzs(3) - zzs(4))
      call zzs_ren(p,q,pq,3 - i,zzs)
      fg2 = 2*sct2/e2*zzs(1)
      fs2 = 2*sct2/e2*(zzs(3) - zzs(4))
      fact = e2/2/sct2*zz*zz*zs(i)
      h1 = fact*(cr(i) + fg1 + zms(i,2)*(cr(3 - i) + fg2))
      h2 = x*h1 - (1 - x*x)*fact*zm2*(fs1 + zms(i,2)*fs2)
      am = 2*abs(h1)**2 + abs(h2)**2
      gam_s_zz = sqrt(1 - 4*p/q)/32/pi/frm(i)*am
      return
      end
 
      double precision function gam_s_fz(i)
c     Width of the decay of scalar into Z boson and photon
      implicit double precision (a-h,o-z)
      complex*16 amp,fzs(6)
      complex*16 zms,zmp
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.zm) then
        gam_s_fz = 0
        return
      end if
      vtmp = vstat
      vstat = .true.
      p = zm2
      q = frm2(i)
      pq = - (p + q)/2
      call fzs_ren(p,q,pq,i,fzs)
      amp = fzs(1)
      call fzs_ren(p,q,pq,3 - i,fzs)
      amp = (amp + zms(i,2)*fzs(1))*zz*zs(i)
      gam_s_fz = (1 - p/q)/8/pi/frm(i)*abs(amp)**2
      vstat = vtmp
      return
      end
 
      double precision function gam_s_ff(i)
c     Width of the decay of scalar into photon pair
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      complex*16 ffs(6)
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      vtmp = vstat
      vstat = .true.
      s = frm2(i)
      call ffs_on_vert(s,i,ffs)
      amp = ffs(1)
      call ffs_on_vert(s,3 - i,ffs)
      amp = (amp + zms(i,2)*ffs(1))*zs(i)
      gam_s_ff = abs(amp)**2/16/pi/frm(i)
      vstat = vtmp
      return
      end
 
      double precision function gam_s_ll(i,j)
c     Width of the decay of scalar into lepton pair
c     Corrections to vertex and lepton self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*em(j)) then
        gam_s_ll = 0
        return
      end if
      p = em(j)*em(j)
      q = frm2(i)
      amp = (zr(1,i) + zms(i,2)*zr(1,3 - i))*zs(i)
      gam_s_ll = frm(i)/8/pi*p/v1/v1*(1 - 4*p/q)**1.5d0*abs(amp)**2
      return
      end
 
      double precision function gam_s_dd(i,j)
c     Width of the decay of scalar into down quark pair
c     Corrections to vertex and quark self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/hm_phys/frm(2),frm2(2)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if ((frm(i).le.0.d0).or.(j.ne.3)) then
c     Stop for unphysical Higgs mass or for attempt of calculation
c     of decay width into dd or ss pair
        gam_s_dd = 0
        return
      end if
c     running quark mass at Q = mh
      qm = runmass(frm(i),dm(j))
      if (frm(i).le.2*qm) then
        gam_s_dd = 0
        return
      end if
      p = qm*qm
      q = frm2(i)
      amp = (zr(1,i) + zms(i,2)*zr(1,3 - i))*zs(i)
      gam_s_dd = 3.d0*frm(i)/8/pi*p/v1/v1*(1 - 4*p/q)**1.5d0*abs(amp)**2
      gam_s_dd = gam_s_dd*run_gam(qm,frm(i),1)
      return
      end
 
      double precision function gam_s_uu(i,j)
c     Width of the decay of scalar into up quark pair
c     Corrections to vertex and quark self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if ((frm(i).le.0.d0).or.(j.eq.1)) then
c     Stop for unphysical Higgs mass or for attempt of calculation
c     of decay width into uu pair
        gam_s_uu = 0
        return
      end if
c     running quark mass at Q = mh
      qm = runmass(frm(i),um(j))
      if (frm(i).le.2*qm) then
        gam_s_uu = 0
        return
      end if
      p = qm*qm
      q = frm2(i)
      amp = (zr(2,i) + zms(i,2)*zr(2,3 - i))*zs(i)
      gam_s_uu = 3.d0*frm(i)/8/pi*p/v2/v2*(1 - 4*p/q)**1.5d0
      gam_s_uu = gam_s_uu*run_gam(qm,frm(i),1)*abs(amp)**2
      return
      end
 
      double precision function gam_s_gg(i)
c     Width of the decay of scalar into gluon pair
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 ggs_on_vert
      complex*16 zms,zmp
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      vtmp = vstat
      vstat = .true.
      s = frm2(i)
      amp = zs(i)*(ggs_on_vert(s,i) + zms(i,2)*ggs_on_vert(s,3 - i))
      amp = 2*alfas(frm(i))/pi*amp
      gam_s_gg = abs(amp)**2/32/pi/frm(i)
      vstat = vtmp
      return
      end
 
      double precision function gam_s_nn(i,j,k)
c     Width of the decay of scalar into neutralino pair
c     Corrections to vertex and neutralino self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 a,at
      complex*16 v_nns,zn
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/neut/fnm(4),zn(4,4)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.fnm(j) + fnm(k)) then
        gam_s_nn = 0
        return
      end if
      p1 = fnm(j)*fnm(j)
      p2 = fnm(k)*fnm(k)
      p3 = fnm(j)*fnm(k)
      q = frm2(i)
      alam = sqrt(q*q - 2*q*(p1 + p2) + (p1 - p2)**2)
      a = (v_nns(j,k,i) + zms(i,2)*v_nns(j,k,3 - i))*zs(i)
      at = (v_nns(k,j,i) + zms(i,2)*v_nns(k,j,3 - i))*zs(i)
      am = (q - p1 - p2)*(abs(a)**2 + abs(at)**2) - 4*p3*dble(a*at)
      gam_s_nn = alam/32/pi/frm(i)**3*e2/4/sct2*am
      return
      end
 
      double precision function gam_s_cc(i,j,k)
c     Width of the decay of scalar into chargino pair
c     Corrections to vertex and chargino self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 a,at
      complex*16 v_ccs,zpos,zneg
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.fcm(j) + fcm(k)) then
        gam_s_cc = 0
        return
      end if
      p1 = fcm(j)*fcm(j)
      p2 = fcm(k)*fcm(k)
      p3 = fcm(j)*fcm(k)
      q = frm2(i)
      alam = sqrt(q*q - 2*q*(p1 + p2) + (p1 - p2)**2)
      a = (v_ccs(j,k,i) + zms(i,2)*v_ccs(j,k,3 - i))*zs(i)
      at = (v_ccs(k,j,i) + zms(i,2)*v_ccs(k,j,3 - i))*zs(i)
      am = (q - p1 - p2)*(abs(a)**2 + abs(at)**2) - 4*p3*dble(a*at)
      gam_s_cc = alam/16/pi/frm(i)**3*e2/2/st2*am
      return
      end
 
      double precision function gam_s_aa(i)
c     Width of the decay of scalar into physical pseudoscalar pair
      implicit double precision (a-h,o-z)
      complex*16 amp,spp_ren
      complex*16 zms,zmp
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*pm(1)) then
        gam_s_aa = 0
        return
      end if
      vtmp = vstat
      vstat = .true.
      p = pm(1)*pm(1)
      pq = frm2(i)/2 - p
      amp = 0
      do 10 j=1,2
        do 10 k=1,2
          do 10 l=1,2
10          amp = amp + zms(i,j)*zmp(1,k)*zmp(1,l)
     1          *spp_ren(p,p,pq,i_sup(i,j),i_sup(1,k),i_sup(1,l))
      amp = zs(i)*zp(1)*zp(1)*amp
      gam_s_aa = sqrt(1 - 4*p/frm2(i))/32/pi/frm(i)*abs(amp)**2
      vstat = vtmp
      return
      end
 
      double precision function gam_s_ss(i)
c     Width of the decay of scalar into scalar pair
      implicit double precision (a-h,o-z)
      complex*16 amp,sss_ren
      complex*16 zms,zmp
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      j = 3 - i
      if (frm(i).le.2*frm(j)) then
        gam_s_ss = 0
        return
      end if
      vtmp = vstat
      vstat = .true.
      p = frm2(j)
      pq = frm2(i)/2 - p
      amp = 0
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
10          amp = amp + zms(i,k)*zms(j,l)*zms(j,m)
     1          *sss_ren(p,p,pq,i_sup(i,k),i_sup(j,l),i_sup(j,m))
      amp = zs(i)*zs(j)*zs(j)*amp
      gam_s_ss = sqrt(1 - 4*p/frm2(i))/32/pi/frm(i)*abs(amp)**2
      vstat = vtmp
      return
      end
 
      double precision function gam_s_hh(i)
c     Width of the decay of scalar into charged Higgs pair
c     Corrections to vertex and charged Higgs self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*cm(1)) then
        gam_s_hh = 0
        return
      end if
      p = cm(1)*cm(1)
      amp = e/2/st*zs(i)*(v_hhs(i,1,1) + zms(i,2)*v_hhs(3 - i,1,1))
      gam_s_hh = sqrt(1 - 4*p/frm2(i))/16/pi/frm(i)*abs(amp)**2
      return
      end
 
      double precision function gam_s_wh(i)
c     Width of the decay of scalar into charged Higgs and W boson
c     Corrections to vertex and charged Higgs self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.cm(1) + wm) then
        gam_s_wh = 0
        return
      end if
      p = cm(1)*cm(1)
      q = frm2(i)
      alam = sqrt(q*q - 2*q*(p + wm2) + (p - wm2)**2)
      amp = zs(i)*zw*(cr(i) + zms(i,2)*cr(3 - i))
      gam_s_wh = (e2/8/st2/wm2)**2/2/pi*(alam/frm(i))**3*abs(amp)**2
      return
      end
 
      double precision function gam_s_ww(i)
c     Width of the decay of scalar into W boson pair
c     Corrections to vertex not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*wm) then
        gam_s_ww = 0
        return
      end if
      x = frm2(i)/wm2/2
      amp = e2/2/st2*zs(i)*zw*zw*(cr(i) + zms(i,2)*cr(3 - i))
      gam_s_ww = sqrt(1 - 2/x)/16/pi/frm(i)*abs(amp)**2*(x*x - 2*x + 3)
      return
      end
 
      double precision function gam_s_zp(i)
c     Width of the decay of scalar into Z boson and (physical) pseudoscalar
      implicit double precision (a-h,o-z)
      complex*16 bm
      complex*16 zms,zmp
      complex*16 zps(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.zm + pm(1)) then
        gam_s_zp = 0
        return
      end if
      p = pm(1)*pm(1)
      q = frm2(i)
      pq = (zm2 - p - q)/2
      alam = sqrt(zm2*zm2 - 2*zm2*(p + q) + (p - q)**2)
      bm = 0
      do 10 k=1,2
        do 10 l=1,2
          kk = i_sup(i,k)
          ll = i_sup(1,l)
          call zps_ren(p,q,pq,kk,ll,zps)
10        bm = bm + (e/sct*am(kk,ll)+ zps(1) + zps(2))*zms(i,k)*zmp(1,l)
      fact = alam**3*(zs(i)*zp(1)*zz)**2/64/pi/zm2/frm(i)/frm2(i)
      gam_s_zp = fact*abs(bm)**2
      return
      end

      double precision function gam_s_vv(i,j)
c     Width of the decay of scalar into sneutrino pair 
      implicit double precision (a-h,o-z)
      complex*16 zv,zl
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.2*vm(j)) then
        gam_s_vv = 0
        return
      end if
      fact = sqrt(1 - 4*vm(j)*vm(j)/frm2(i))*(e2*zs(i)/16/sct2)**2
      gam_s_vv = fact/pi/frm(i)*abs(br(i) + zms(i,2)*br(3 - i))**2
      return
      end
 
      double precision function gam_s_sll(i,j,k)
c     Width of the decay of scalar into slepton pair
c     Slepton L_j^- incoming, slepton L_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,v_lls
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.slm(j) + slm(k)) then
        gam_s_sll = 0
        return
      end if
      p = frm2(i)
      q = slm(j)**2
      r = slm(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = alam/16/pi/frm(i)/frm2(i)*zs(i)**2 
      gam_s_sll = fact*abs(v_lls(j,k,i) + zms(i,2)*v_lls(j,k,3 - i))**2
      return
      end
 
      double precision function gam_s_sdd(i,j,k)
c     Width of the decay of scalar into down-squark pair
c     Squark D_j^- incoming, squark D_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,v_dds
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.sdm(j) + sdm(k)) then
        gam_s_sdd = 0
        return
      end if
      p = frm2(i)
      q = sdm(j)**2
      r = sdm(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = 3.d0*alam/16/pi/frm(i)/frm2(i)*zs(i)**2 
      gam_s_sdd = fact*abs(v_dds(j,k,i) + zms(i,2)*v_dds(j,k,3 - i))**2
      return
      end
 
      double precision function gam_s_suu(i,j,k)
c     Width of the decay of scalar into up-squark pair
c     Squark U_j^- incoming, squark U_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,v_uus
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (frm(i).le.sum(j) + sum(k)) then
        gam_s_suu = 0
        return
      end if
      p = frm2(i)
      q = sum(j)**2
      r = sum(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = 3.d0*alam/16/pi/frm(i)/frm2(i)*zs(i)**2 
      gam_s_suu = fact*abs(v_uus(j,k,i) + zms(i,2)*v_uus(j,k,3 - i))**2
      return
      end
 
 
 
 
