c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@fuw.edu.pl
 
c     FILENAME: SET_PAR.FOR
c     Last revised: 10: 3:1993(J.R.)
c     Initialization of Kobayashi-Maskawa matrix added

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains the procedures allowing easy setting typical  c
c     values to MSSM parameters                                        c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      subroutine set_par(tanb,am,tm,amiu,amsq,amsl,amg,ys,ierr)
c     Set values to MSSM parameters (all masses in GeV)
c     tanb:   tan(beta)
c     am:     pseudoscalar mass
c     tm:     top mass
c     amiu:   miu (i.e. h) parameter in superpotential
c     amsq:   squark mass scale
c     amsl:   slepton mass scale
c     amg:    gaugino mass scale
c     ys:     "Yukawa" tri-scalar coupling (dimensionless, full coupling
c     is proportional to ys, sfermion mass and Yukawa coupling for fermion.
c
c     ierr reports possible errors
c     ierr=1     One or more scalar mass squares below 0
c                (unstable Higgs potential)
c     ierr=2     One or more sfermino mass squares below 0
c     ierr=3     Very light (below 1 MeV) chargino - warning only!
c     ierr=4     Very light (below 1 MeV) neutralino - warning only!
      implicit double precision (a-h,o-z)
      complex*16 h
      complex*16 gm2,gm3
      complex*16 ls,ks,ds,es,us,ws
      complex*16 lms,rms,ums,dms,qms
      logical hdiag,sqdiag,sldiag,cdiag,ndiag
      logical zstat,hstat,bstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/km_par/vkm1,vkm2,vkm3,phi0
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hpar/hm1,hm2,hs,h
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/msoft/lms(3,3),rms(3,3),ums(3,3),dms(3,3),qms(3,3)
      common/gmass/gm1,gm2,gm3
      common/zwidth/z_gam,zfact,zstat
      common/hm_stat/hstat
      common/bswitch/bstat
 
      ierr = 0
c     Initialize Kobayashi-Maskawa matrix
      call ckm_update(vkm1,vkm2,vkm3,phi0)
c     Calculate st,ct... in agreement with assumed zm,wm values
      zm_new = zm
      wm_new = wm
      call vpar_update(zm_new,wm_new)
c     Reset Z0 width calculations
      zstat = .false.
c     Switch off box contributions
      bstat = .false.
c     Physical Higgs masses have to be recalculated after parameter change
      hstat = .false.
      h = amiu
      gm2  = amg
      pm(1) = am
      um(3) = tm
c     U(1) and SU(2) gaugino masses not independent:
      gm3   = 5.d0/3*gm2*st2/ct2
      beta = atan(tanb)
      sg2   = pm(1)*pm(1)
      sigma = sg2 - 2*abs(h*h)
      diff  = - (sg2 + zm2)*cos(2*beta)
      hs    = - sg2/2*sin(2*beta)
      v1    = 2*zm*sct*cos(beta)/e
      v2    = 2*zm*sct*sin(beta)/e
      hm1   = (sigma + diff)/2
      hm2   = (sigma - diff)/2
      if (hdiag()) then
        ierr = 1
        return
      end if
      do 10 i=1,3
        lms(i,i) = amsl*abs(amsl)
        rms(i,i) = amsl*abs(amsl)
        ums(i,i) = amsq*abs(amsq)
        dms(i,i) = amsq*abs(amsq)
        qms(i,i) = amsq*abs(amsq)
        do 10 j=1,3
          ls(i,j) = 0
          ds(i,j) = 0
          us(i,j) = 0
          if (i.eq.j) then
            ls(i,i) = - abs(amsl)*em(i)*sq2/v1*ys
            ds(i,i) = - abs(amsq)*dm(i)*sq2/v1*ys
            us(i,i) =   abs(amsq)*um(i)*sq2/v2*ys
          end if
          ks(i,j) = 0
          es(i,j) = 0
10        ws(i,j) = 0
      if (sqdiag().or.sldiag()) then
        ierr = 2
        return
      end if
      if (cdiag()) ierr = 3
      if (ndiag()) ierr = 4
      call corr_EPA(tanb,am,tm,amiu,amsq,ys,ierr)
      ierr = - ierr
      return
      end
 
      subroutine fset_par(tanb,am,tm,amiu,amglu,amg,amgg,
     1                  amsq,atbl,abr,atr,all,alr,yb,yt,yl,ierr)
c     More complicated version including sfermion mass splitting 
c     ierr reports possible errors
c     ierr=1     One or more scalar mass squares below 0
c                (unstable Higgs potential)
c     ierr=2     One or more sfermino mass squares below 0
c     ierr=3     Very light (below 1 GeV) chargino - warning only!
c     ierr=4     Very light (below 1 GeV) neutralino - warning only!
c     ierr=5     Error in EPA Higgs mass calculations, or mass below 0.
 
      implicit double precision (a-h,o-z)
      complex*16 h
      complex*16 gm2,gm3
      complex*16 ls,ks,ds,es,us,ws
      complex*16 lms,rms,ums,dms,qms
      logical hdiag,sqdiag,sldiag,cdiag,ndiag
      logical zstat,hstat,bstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/km_par/vkm1,vkm2,vkm3,phi0
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hpar/hm1,hm2,hs,h
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/msoft/lms(3,3),rms(3,3),ums(3,3),dms(3,3),qms(3,3)
      common/gmass/gm1,gm2,gm3
      common/zwidth/z_gam,zfact,zstat
      common/hm_stat/hstat
      common/bswitch/bstat
 
      ierr = 0
      call ckm_update(vkm1,vkm2,vkm3,phi0)
      zm_new = zm
      wm_new = wm
      call vpar_update(zm_new,wm_new)
c     Reset Z0 width calculations
      zstat = .false.
c     Switch off box contributions
      bstat = .false.
c     Physical Higgs masses have to be recalculated after parameter change
      hstat = .false.

      h = amiu
      gm1 = amglu
      gm2 = amg
      if (amgg.ne.0.d0) then
        gm3 = amgg
      else
        gm3 = 5/3.d0*st2/ct2*amg
      end if
 
      pm(1) = am
      um(3) = tm
 
      beta = atan(tanb)
      sg2   = pm(1)*pm(1)
      sigma = sg2 - 2*abs(h*h)
      diff  = - (sg2 + zm2)*cos(2*beta)
      hs    = - sg2/2*sin(2*beta)
      v1    = 2*zm*sct*cos(beta)/e
      v2    = 2*zm*sct*sin(beta)/e
      hm1   = (sigma + diff)/2
      hm2   = (sigma - diff)/2
      if (hdiag()) then
        ierr = 1
        return
      end if
      do 10 i=1,3
        lms(i,i) = all*abs(all)
        rms(i,i) = alr*abs(alr)
        if (i.ne.3) then
          ums(i,i) = amsq*abs(amsq)
          dms(i,i) = amsq*abs(amsq)
          qms(i,i) = amsq*abs(amsq)
        else
          ums(3,3) = atr*abs(atr)
          dms(3,3) = abr*abs(abr)
          qms(3,3) = atbl*abs(atbl)
        end if
        do 10 j=1,3
          ls(i,j) = 0
          ds(i,j) = 0
          us(i,j) = 0
          if (i.eq.j) then
            ls(i,i) = - abs(alr)*em(i)*sq2/v1*yl
            if (i.ne.3) then
              ds(i,i) = - abs(atbl)*dm(i)*sq2/v1*yb
              us(i,i) =   abs(atbl)*um(i)*sq2/v2*yt
            else
              ds(3,3) = - abs(atbl)*dm(3)*sq2/v1*yb
              us(3,3) =   abs(atbl)*um(3)*sq2/v2*yt
            end if
          end if
          ks(i,j) = 0
          es(i,j) = 0
          ws(i,j) = 0
10    continue
      if (sldiag().or.sqdiag()) then
        ierr = 2
        return
      end if
      if (cdiag()) ierr = 3
      if (ndiag()) ierr = 4
      call fcorr_EPA(tanb,am,tm,amiu,stbl,sbr,str,ybs,yts,ierr)
      ierr = - ierr
      return
      end

      subroutine gset_par(tanb,amiu,amg,amgg,ierr)
c     Gaugino sector initialization only
c     ierr reports possible errors
c     ierr=1 - "inos" light enough to be detected at LEP1
 
      implicit double precision (a-h,o-z)
      complex*16 h
      complex*16 gm2,gm3
      logical cdiag,ndiag,blind,ino_check_0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/hpar/hm1,hm2,hs,h
      common/gmass/gm1,gm2,gm3
      external init_phys,init_const,init_control
 
      ierr = 0
      zm_new = zm
      wm_new = wm
      call vpar_update(zm_new,wm_new)

      h = amiu
      gm2 = amg
      if (amgg.ne.0.d0) then
        gm3 = amgg
      else
        gm3 = 5/3.d0*st2/ct2*amg
      end if
      beta = atan(tanb)
      v1    = 2*zm*sct*cos(beta)/e
      v2    = 2*zm*sct*sin(beta)/e

      blind = cdiag().and.ndiag() 
      if (ino_check_0()) ierr = 1
      return
      end

      double precision function sol_mu(cm,rat,tb,ierr)
c     Input parameters:
c     cm   - LIGHTER chargino mass
c     rat  - M2/mu ratio (M2 = 2*m2 where m2 taken from rosiek@PRD41!)
c     tb   - tan(beta)
c     ierr - error status, 0 if everything OK.
c     Output:
c     sol_mu gives mu parameter value giving required cm and rat.
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      ierr = 0
      sol_mu = 0
      rat2 = rat*rat
      cm2 = cm*cm/wm2
      c2b = (1 - tb*tb)/(1 + tb*tb)
      s2b = 2*tb/(1 + tb*tb)
      if (cm.eq.0) then
c     If cm=0, than solution possible only for r>0 
         if (rat.gt.0) then
            sol_mu = wm*sqrt(s2b/rat)
         else
            ierr = 1 
         end if
         return
      else
         if (rat.eq.0) then
c     Solution always exists, but if cm2>s2b, than HEAVIER chargino
c     has mass cm. In addition, we must keep mu^2 positive - see
c     second condition
            if ((cm2.le.s2b).and.(cm2.le.(1 - abs(c2b)))) then
               write(*,*)cm2 + s2b/cm2 -2
               sol_mu = wm*sqrt(cm2 + s2b*s2b/cm2 - 2)
            else
               ierr = 2
            end if
            return
         else
            a = rat2
            b = cm2*(1 + rat2) + 2*rat*s2b
            c = (1 - cm2)**2 - c2b*c2b
            delta = b*b - 4*a*c
            if (delta.lt.0.d0) then
c     No solutions
               ierr = 2
               return
            end if
            delta = sqrt(delta)
            x1 = (b - delta)/a/2
            x2 = (b + delta)/a/2
            if (x2.lt.0.d0) then
c     Both solutions for mu^2 negative
               ierr = 3
               return
            end if 
c     If more than one solution for mu exists, try find the 
c     lighter one. Start with x1 of course:
            if (x1.ge.0) then
               x1 = sign(sqrt(x1),rat)
               if (abs(fcn2_rel_min(x1,rat,s2b) - cm2).lt.1.d-3) then
                  sol_mu = wm*x1
                  return
               end if
            end if
c     x1 failed, try x2
            x2 = sign(sqrt(x2),rat)
            if (abs(fcn2_rel_min(x2,rat,s2b) - cm2).lt.1.d-3) then
               sol_mu = wm*x2
               return
            end if
c     No solutions? Something wrong, e.g. both x1,x2 give cm as HEAVIER
c     chargino mass. Is it really possible?
            ierr = 4
         end if
      end if
      return
      end
      
      double precision function fcn2_rel_min(x,r,s2b)
c     Find (lighter chargino mass)^2/MW^2 
c     for given x=mu/MW, r=M2/mu and s2b=sin(2 beta)
      implicit double precision (a-h,o-z)
      b = x*x*(1 + r*r) + 2
      c = r*r*x**4 - s2b*(2*r*x*x - s2b)
      delta = b*b - 4*c
      if (delta.lt.0) stop 'Delta<0 in fcn2_rel_min ?!'
      fcn2_rel_min = (b - sqrt(delta))/2  
      return
      end




