c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: SHH_VERT.FOR
c     Released: 24: 4:1996(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains 1-loop corrections to the                    c
c     scalar-charged Higgs-charged Higgs vertex                       c
c     in the simple (EPA) approximation: only                         c
c     top/stop/bottom/sbottom loops are included                      c
c     and all external momenta are set to 0                           c
c                                                                     c
c     Incoming scalar S(i)                                            c
c     Outgoing scalar H^+(j)                                          c
c     Outgoing scalar H^-(k)                                          c
c                                                                     c
c                                                                     c
c                               _______ H^+_j                         c
c                             /|                                      c
c                           /  |                                      c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______ H^-_k                         c
c                                                                     c
c                                                                     c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      double precision function shh_3vert1(i,j,k)
c     Top-top-bottom in loop
      implicit double precision (a-h,o-z)
c     common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      x = dm(3)*dm(3)/um(3)/um(3)
      shh_3vert1 = (2*(x*zh(1,j)*zh(1,k)/v1/v1 + zh(2,j)*zh(2,k)/v2/v2)
     $     - x*(zh(1,j)*zh(2,k) + zh(1,k)*zh(2,j))/v1/v2)
     $     * cp1(um(3),um(3),dm(3))
     $     - dm(3)*dm(3)*(zh(1,j)*zh(2,k) + zh(1,k)*zh(2,j))/v1/v2
     $     * cp0(um(3),um(3),dm(3))
      shh_3vert1 = - 4*um(3)**4*zr(2,i)/v2*shh_3vert1 
      return
      end

      double precision function shh_3vert2(i,j,k)
c     Top-bottom-bottom in loop
      implicit double precision (a-h,o-z)
c     common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      x = dm(3)*dm(3)/um(3)/um(3)
      shh_3vert2 = (2*(x*zh(1,j)*zh(1,k)/v1/v1 + zh(2,j)*zh(2,k)/v2/v2)
     $     - (zh(1,j)*zh(2,k) + zh(1,k)*zh(2,j))/v1/v2)
     $     * cp1(um(3),dm(3),dm(3))
     $     - dm(3)*dm(3)*(zh(1,j)*zh(2,k) + zh(1,k)*zh(2,j))/v1/v2
     $     * cp0(um(3),dm(3),dm(3))
      shh_3vert2 = - 4*um(3)*um(3)*dm(3)*dm(3)*zr(1,i)/v1*shh_3vert2 
      return
      end
 
      double precision function shh_3vert3(i,j,k)
c     Stop-stop-sbottom in loop
      implicit double precision (a-h,o-z)
      complex*16 v_uus,v_udh
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      shh_3vert3 = 0
      do 20 l=1,6
        do 20 m=1,6
          do 20 n=1,6
 20         shh_3vert3 = shh_3vert3 - v_uus(m,l,i)*v_udh(m,n,k)
     $            *conjg(v_udh(l,n,j))*cp0(sum(l),sum(m),sdm(n))
      return
      end
 
      double precision function shh_3vert4(i,j,k)
c     Sbottom-sbottom-stop in loop
      implicit double precision (a-h,o-z)
      complex*16 v_dds,v_udh
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      shh_3vert4 = 0
      do 20 l=1,6
        do 20 m=1,6
          do 20 n=1,6
 20         shh_3vert4 = shh_3vert4 - v_dds(m,l,i)*v_udh(n,m,k)
     $            *conjg(v_udh(n,l,j))*cp0(sdm(l),sdm(m),sum(n))
      return
      end
 
      double precision function shh_4vert1(i,j,k)
c     2 u-squarks in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_uus,v_uuhh
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      shh_4vert1 = 0
      do 20 m=1,6
        do 20 n=1,6
 20       shh_4vert1 = shh_4vert1 + v_uus(m,n,i)*v_uuhh(n,m,j,k)
     $          * b0(0.d0,sum(m),sum(n))
      return
      end
 
      double precision function shh_4vert2(i,j,k)
c     2 d-squarks in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_dds,v_ddhh
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      shh_4vert2 = 0
      do 20 m=1,6
        do 20 n=1,6
 20       shh_4vert2 = shh_4vert2 + v_dds(m,n,i)*v_ddhh(n,m,j,k)
     $          * b0(0.d0,sdm(m),sdm(n))
      return
      end
 
      double precision function shh_4vert3(i,j,k)
c     u- and d-squarks in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_udhs,v_udh
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      shh_4vert3 = 0
      do 20 m=1,6
        do 20 n=1,6
 20       shh_4vert3 = shh_4vert3 + (v_udhs(m,n,i,j)*conjg(v_udh(m,n,k))
     $          + conjg(v_udhs(m,n,i,k))*v_udh(m,n,j))
     $          * b0(0.d0,sum(m),sdm(n))
      return
      end
 
      double precision function shh_vert(i,j,k)
c     Full bare SHH vertex formfactor
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      shh_vert = shh_3vert1(i,j,k) + shh_3vert2(i,j,k) 
     $         + shh_3vert3(i,j,k) + shh_3vert4(i,j,k)
     $         + shh_4vert1(i,j,k) + shh_4vert2(i,j,k) 
     $         + shh_4vert3(i,j,k)
      shh_vert = shh_vert/16/pi/pi
      return
      end
 










