c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: SPP_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains scalar - 2 pseudoscalars vertex              c
c     and its renormalization                                         c
c                                                                     c
c     Incoming scalar S(i)      :  momentum (p+q)                     c
c     Outgoing pseudoscalar P(j):  momentum  q                        c
c     Outgoing pseudoscalar P(k):  momentum  p                        c
c                                                                     c
c                                                                     c
c                               _______ P_k                           c
c                             /|                                      c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  P_j                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 497.                   c
c                                                                     c
c       V = V_tree + i V_1(p,q,pq,i,j,k)                              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      complex*16 function spp_3vert1(p,q,pq,i,j,k)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
c     common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + 2*pq + q
      spp_3vert1 = 0
      do 10 l=1,3
        spp_3vert1 = spp_3vert1 - 8*em(l)*(em(l)/v1)**3
     1             * zr(1,i)*zh(1,j)*zh(1,k)
     2             * (pq*c0(em(l),em(l),em(l)) - b0(s,em(l),em(l)))
        call creset
        spp_3vert1 = spp_3vert1 - 24*dm(l)*(dm(l)/v1)**3
     1             * zr(1,i)*zh(1,j)*zh(1,k)
     2             * (pq*c0(dm(l),dm(l),dm(l)) - b0(s,dm(l),dm(l)))
        call creset
        spp_3vert1 = spp_3vert1 - 24*um(l)*(um(l)/v2)**3
     1             * zr(2,i)*zh(2,j)*zh(2,k)
     2             * (pq*c0(um(l),um(l),um(l)) - b0(s,um(l),um(l)))
10      call creset
      return
      end
 
      complex*16 function spp_3vert2(p,q,pq,i,j,k)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 v_llp,v_uup,v_ddp,v_lls,v_dds,v_uus
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      spp_3vert2 = 0
      do 20 n=1,6
        do 20 l=1,6
          do 20 m=1,6
            tmp = 2*dble(v_lls(l,m,i)*v_llp(n,l,j)*v_llp(m,n,k))
            if (abs(tmp).gt.epsf) then
              spp_3vert2 = spp_3vert2 + tmp*c0(slm(l),slm(n),slm(m))
              call creset
            end if
            tmp = 6*dble(v_uus(l,m,i)*v_uup(n,l,j)*v_uup(m,n,k))
            if (abs(tmp).gt.epsf) then
              spp_3vert2 = spp_3vert2 + tmp*c0(sum(l),sum(n),sum(m))
              call creset
            end if
            tmp = 6*dble(v_dds(l,m,i)*v_ddp(n,l,j)*v_ddp(m,n,k))
            if (abs(tmp).gt.epsf) then
              spp_3vert2 = spp_3vert2 + tmp*c0(sdm(l),sdm(n),sdm(m))
              call creset
            end if
20    continue
      return
      end
 
      complex*16 function spp_3vert3(p,q,pq,i,j,k)
c     3 charged Higgses (or Goldstones) in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert3 = 0
      if (j*k.eq.1) then
        spp_3vert3 = 2*wm2*(e/st/2)**3
     1             *(v_hhs(i,1,1)*c0(cm(1),cm(2),cm(1))
     2             + v_hhs(i,2,2)*c0(cm(2),cm(1),cm(2)))
        call creset
      end if
      return
      end
 
      complex*16 function spp_3vert4(p,q,pq,i,j,k)
c     2 scalars 1 pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert4 = 0
      do 10 n=1,2
        do 10 m=1,2
          do 10 l=1,2
            spp_3vert4 = spp_3vert4 + (e/sct/2)**6*br(l)*br(m)*ah(j,n)
     1                 *ah(k,n)*v_sss(i,l,m)*c0(rm(l),pm(n),rm(m))
10          call creset
      return
      end
 
      complex*16 function spp_3vert5(p,q,pq,i,j,k)
c     1 scalar 2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert5 = 0
      do 10 n=1,2
        do 10 m=1,2
          do 10 l=1,2
            spp_3vert5 = spp_3vert5 + (e2/sct2/4)**3*br(i)*br(n)**2
     1                 *ah(l,m)*ah(l,j)*ah(m,k)*c0(pm(l),rm(n),pm(m))
10          call creset
      return
      end
 
      complex*16 function spp_3vert6(p,q,pq,i,j,k)
c     2 charged Higgses + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert6 = 0
      if (j.eq.1) then
        spp_3vert6 = spp_3vert6 + 2*wm*(e/st/2)**3*ap(i,k)
     1             *( - b0(p,cm(k),wm) - 2*pq*c11(cm(3 - k),cm(k),wm)
     2             - 2*p*c12(cm(3 - k),cm(k),wm)
     3             + (cm(3 - k)**2 + p - q)*c0(cm(3 - k),cm(k),wm))
        call creset
      end if
      if (k.eq.1) then
        spp_3vert6 = spp_3vert6 + 2*wm*(e/st/2)**3*ap(i,j)
     1             *( - b0(p,cm(j),cm(3 - j))
     2             + (wm2 + 4*pq + 4*q)*c0(wm,cm(j),cm(3 - j))
     3             + 2*(pq + 2*q)*c11(wm,cm(j),cm(3 - j))
     4             + 2*(p + 2*pq)*c12(wm,cm(j),cm(3 - j)))
        call creset
      end if
      spp_3vert6 = spp_3vert6 - 2*(e/st/2)**3*v_hhs(i,j,k)
     1           *( - b0(p,wm,cm(k))
     2           + (cm(j)*cm(j) - 2*pq - q)*c0(cm(j),wm,cm(k))
     3           + 2*pq*c11(cm(j),wm,cm(k))
     4           + 2*p*c12(cm(j),wm,cm(k)))
      call creset
      continue
      return
      end
 
      complex*16 function spp_3vert7(p,q,pq,i,j,k)
c     1 pseudoscalar 1 scalar and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert7 = 0
      do 10 l=1,2
        do 10 n=1,2
          spp_3vert7 = spp_3vert7 + (e/sct/2)**4
     1               *am(i,l)*am(n,k)*ah(l,j)*br(n)*( - b0(p,rm(n),zm)
     2               + (pm(l)*pm(l) + p - q)*c0(pm(l),rm(n),zm)
     3               - 2*pq*c11(pm(l),rm(n),zm)
     4               - 2*p*c12(pm(l),rm(n),zm))
          call creset
          spp_3vert7 = spp_3vert7 + (e/sct/2)**4
     1               *am(i,l)*am(n,j)*ah(l,k)*br(n)*(- b0(p,pm(n),rm(l))
     2               + (zm2 + 4*pq + 4*q)*c0(zm,pm(n),rm(l))
     3               + 2*(pq + 2*q)*c11(zm,pm(n),rm(l))
     4               + 2*(p + 2*pq)*c12(zm,pm(n),rm(l)))
          call creset
          spp_3vert7 = spp_3vert7 - (e/sct/2)**4*v_sss(i,l,n)
     1               * am(l,j)*am(n,k)*( - b0(p,zm,rm(n))
     2               + (rm(l)*rm(l) - 2*pq - q)*c0(rm(l),zm,rm(n))
     3               + 2*pq*c11(rm(l),zm,rm(n))
     4               + 2*p*c12(rm(l),zm,rm(n)))
          call creset
10    continue
      return
      end
 
      complex*16 function spp_3vert8(p,q,pq,i,j,k)
c     Charged Higgs + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert8 = 0
      if (k.eq.j) then
        spp_3vert8 = - (e/st)**4*cr(i)/4
     1             *((wm2 + 2*q - 2*pq)*c0(wm,cm(j),wm)
     2             + (3*q - pq)*c11(wm,cm(j),wm)
     3             + (3*pq - p)*c12(wm,cm(j),wm) - b0(p,cm(j),wm))
        call creset
      end if
      return
      end
 
      complex*16 function spp_3vert9(p,q,pq,i,j,k)
c     scalar Higgs + 2 Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      spp_3vert9 = 0
      do 10 n=1,2
        spp_3vert9 = spp_3vert9 - (e/sct)**4*am(n,k)*am(n,j)*cr(i)/8
     1             *((zm2 + 2*q - 2*pq)*c0(zm,rm(n),zm)
     2             + (3*q - pq)*c11(zm,rm(n),zm)
     3             + (3*pq - p)*c12(zm,rm(n),zm) - b0(p,rm(n),zm))
        call creset
10    continue
      return
      end
 
      complex*16 function spp_3vert10(p,q,pq,i,j,k)
c     three W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      spp_3vert10 = 0
      if ((j.eq.2).and.(k.eq.2)) then
        spp_3vert10 = 4*wm2*(e/st/2)**4*cr(i)*c0(wm,wm,wm)
        call creset
      end if
      return
      end
 
      complex*16 function spp_3vert12(p,q,pq,i,j,k)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      complex*16 v_ccs, v_ccp
      complex*16 zpos,zneg
      complex*16 Si,CSi,Pj,CPj,Pk,CPk
      complex*16 tmp,tmp1,tmp2,tmp3,tmp4
      double precision mn,ml,mm
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hangle/ca,sa,cb,sb
      common/vev/v1,v2
      spp_3vert12 = 0
      s = p + 2*pq + q
      do 10 n=1,2
        do 10 l=1,2
          do 10 m=1,2
            mn  =  fcm(n)
            ml  =  fcm(l)
            mm  =  fcm(m)
            Si  =  v_ccs(l,m,i)
            Pj  =  v_ccp(n,l,j)
            Pk  =  v_ccp(m,n,k)
            CSi =  conjg(v_ccs(m,l,i))
            CPj =  conjg(v_ccp(l,n,j))
            CPk =  conjg(v_ccp(n,m,k))
 
      tmp1 =  2*dble(Si*Pj*Pk + CSi*CPj*CPk)*mm*mn*ml*c0(ml,mn,mm)
 
      tmp2 = - dble(Si*Pj*CPk + CSi*CPj*Pk)*ml
     1     *( - b0(q,mn,ml) - b0(s,mm,ml)
     2     + (mm*mm + mn*mn - p)*c0(ml,mn,mm))
 
      tmp3 = dble(Si*CPj*CPk + CSi*Pj*Pk)*mn
     1     *( - b0(q,mn,ml) - b0(p,mm,mn)
     2     + (mm*mm + ml*ml - s)*c0(ml,mn,mm))
 
      tmp4 = - dble(Si*CPj*Pk + CSi*Pj*CPk)*mm
     1     *( - b0(s,mm,ml) - b0(p,mm,mn)
     2     + (mn*mn + ml*ml - q)*c0(ml,mn,mm))
 
      tmp = tmp1 + tmp2 + tmp3 + tmp4
 
            call creset
10          spp_3vert12 = spp_3vert12 + 2*(e/sq2/st)**3*tmp
      return
      end
 
      complex*16 function spp_3vert13(p,q,pq,i,j,k)
c     3 neutralinos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      complex*16 v_nns,v_nnp
      complex*16 zn
      complex*16 Si,Pj,Pk,CSi,CPj,CPk
      complex*16 tmp,tmp1,tmp2,tmp3,tmp4
      double precision mn,ml,mm
      common/neut/fnm(4),zn(4,4)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hangle/ca,sa,cb,sb
      common/vev/v1,v2
      spp_3vert13 = 0
      s = p + 2*pq + q
      do 10 n=1,4
        do 10 l=1,4
          do 10 m=1,4
            mn  =  fnm(n)
            ml  =  fnm(l)
            mm  =  fnm(m)
            Si  =  v_nns(l,m,i)
            Pj  =  v_nnp(n,l,j)
            Pk  =  v_nnp(m,n,k)
            CSi =  conjg(v_nns(m,l,i))
            CPj =  conjg(v_nnp(l,n,j))
            CPk =  conjg(v_nnp(n,m,k))
 
      tmp1 =  2*dble(Si*Pj*Pk + CSi*CPj*CPk)*mm*mn*ml*c0(ml,mn,mm)
 
      tmp2 = - dble(Si*Pj*CPk + CSi*CPj*Pk)*ml
     1     *( - b0(q,mn,ml) - b0(s,mm,ml)
     2     + (mm*mm + mn*mn - p)*c0(ml,mn,mm))
 
      tmp3 =   dble(Si*CPj*CPk + CSi*Pj*Pk)*mn
     1     *( - b0(q,mn,ml) - b0(p,mm,mn)
     2     + (mm*mm + ml*ml - s)*c0(ml,mn,mm))
 
      tmp4 = - dble(Si*CPj*Pk + CSi*Pj*CPk)*mm
     1     *( - b0(s,mm,ml) - b0(p,mm,mn)
     2     + (mn*mn + ml*ml - q)*c0(ml,mn,mm))
 
       tmp = tmp1 + tmp2 + tmp3 + tmp4
 
            call creset
10          spp_3vert13 = spp_3vert13 - (e/2/sct)**3*tmp
      return
      end
 
      complex*16 function spp_4vert1(p,q,pq,i,j,k)
c     sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_llpp,v_uupp,v_ddpp,v_lls,v_dds,v_uus
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hangle/ca,sa,cb,sb
      common/vev/v1,v2
      spp_4vert1 = 0
      s = p + 2*pq + q
      do 10 n=1,3
10      spp_4vert1 = spp_4vert1 - (e/2/sct)**4*br(i)*ah(j,k)
     1             *b0(s,vm(n),vm(n))
      do 20 n=1,6
        do 20 m=1,6
          spp_4vert1 = spp_4vert1 - v_lls(m,n,i)*v_llpp(j,k,n,m)
     1               *b0(s,slm(n),slm(m))
          spp_4vert1 = spp_4vert1 - 3*v_uus(m,n,i)*v_uupp(j,k,n,m)
     1               *b0(s,sum(n),sum(m))
20        spp_4vert1 = spp_4vert1 - 3*v_dds(m,n,i)*v_ddpp(j,k,n,m)
     1               *b0(s,sdm(n),sdm(m))
      return
      end
 
      complex*16 function spp_4vert2(p,q,pq,i,j,k)
c     charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + 2*pq + q
      spp_4vert2 =0
      do 10 m=1,2
        do 10  n=1,2
10        spp_4vert2 = spp_4vert2 - (e/2/st)**3
     1               *v_hhs(i,n,m)*v_hhpp(k,j,m,n)*b0(s,cm(m),cm(n))
      if (k.eq.1) spp_4vert2 = spp_4vert2 - 2*wm*(e/st/2)**3
     1                       *ap(i,j)*b0(p,wm,cm(1))
      if (j.eq.1) spp_4vert2 = spp_4vert2 - 2*wm*(e/st/2)**3
     1                       *ap(i,k)*b0(q,wm,cm(1))
      return
      end
 
      complex*16 function spp_4vert3(p,q,pq,i,j,k)
c     scalars and pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + 2*pq + q
      spp_4vert3 = 0
      do 10 n=1,2
        do 10 m=1,2
          spp_4vert3 = spp_4vert3 - (e/sct/2)**4*v_sss(i,m,n)
     1               *ar(n,m)*ah(j,k)*b0(s,rm(m),rm(n))/2
          spp_4vert3 = spp_4vert3 - (e/sct/2)**4*v_pppp(m,n,k,j)
     1               *br(i)*ah(n,m)*b0(s,pm(m),pm(n))/2
          spp_4vert3 = spp_4vert3 - (e/sct/2)**4*ar(i,m)*ah(j,n)
     1               *br(m)*ah(n,k)*b0(p,rm(m),pm(n))
10        spp_4vert3 = spp_4vert3 - (e/sct/2)**4*ar(i,m)*ah(k,n)
     1               *br(m)*ah(n,j)*b0(q,rm(m),pm(n))
      return
      end
 
      complex*16 function spp_4vert4(p,q,pq,i,j,k)
c     W+W-  and 2 Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      spp_4vert4=0
      if (j.eq.k) then
        s = p + q + 2*pq
        spp_4vert4 = - (e2/st2)**2*cr(i)*(b0(s,wm,wm)
     1             + b0(s,zm,zm)/ct2/ct2/2)
      end if
      return
      end
 
      complex*16 function spp_vert(p,q,pq,i,j,k)
c     Full bare SPP vertex formfactor
      implicit double precision (a-h,o-z)
      complex*16 spp_3vert1, spp_3vert2, spp_3vert3, spp_3vert4,
     1           spp_3vert5, spp_3vert6, spp_3vert7, spp_3vert8,
     2           spp_3vert9, spp_3vert10,spp_3vert12,spp_3vert13
      complex*16 spp_4vert1, spp_4vert2, spp_4vert3, spp_4vert4
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      spp_vert = (0,0)
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) spp_vert = spp_vert  + spp_3vert1(p,q,pq,i,j,k)
      if (is.eq.1) spp_vert = spp_vert  + spp_3vert2(p,q,pq,i,j,k)
     1                                  + spp_4vert1(p,q,pq,i,j,k)
      if (ig.eq.1) spp_vert = spp_vert  + spp_3vert3(p,q,pq,i,j,k)
     1      + spp_3vert4(p,q,pq,i,j,k)  + spp_3vert5(p,q,pq,i,j,k)
     2      + spp_3vert6(p,q,pq,i,j,k)  + spp_3vert7(p,q,pq,i,j,k)
     3      + spp_3vert8(p,q,pq,i,j,k)  + spp_3vert9(p,q,pq,i,j,k)
     4      + spp_3vert10(p,q,pq,i,j,k) + spp_4vert2(p,q,pq,i,j,k)
     5      + spp_4vert3(p,q,pq,i,j,k)  + spp_4vert4(p,q,pq,i,j,k)
      if (ic.eq.1) spp_vert = spp_vert + spp_3vert12(p,q,pq,i,j,k)
      if (in.eq.1) spp_vert = spp_vert + spp_3vert13(p,q,pq,i,j,k)
      spp_vert = spp_vert/16/pi/pi
      return
      end
 
      complex*16 function spp_ren(p,q,pq,i,j,k)
c     TREE LEVEL EXPRESSION + full renormalized SPP vertex formfactor
      implicit double precision (a-h,o-z)
      complex*16 spp_vert
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      spp_ren = e2/sct2/4*br(i)*ah(j,k)
      if (.not.vstat) return
      spp_ren = spp_ren - e2/sct2/4*(dv1/v1 - 2*ct2*dz2 
     1        + 3*ct2*dza + st2*dzb)*br(i)*ah(j,k)
     2        + e2/sct2/4*(2*dzh1*v1*zr(1,i)*zh(1,j)*zh(1,k)
     3                   + 2*dzh2*v2*zr(2,i)*zh(2,j)*zh(2,k)
     4        - (dzh1 + dzh2)*(v1*zr(1,i)*zh(2,j)*zh(2,k)
     5                       + v2*zr(2,i)*zh(1,j)*zh(1,k)))
     6        + spp_vert(p,q,pq,i,j,k)
      return
      end




