c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: U_SELF.FOR
c     Released: 1: 4:1994 (P.Ch.)

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for up quarks self-energy          c
c     function and its renormalization.                                 c
c                                                                       c
c     The definition of the self energy as                              c
c     follows (arguments are s=k^2,i,j):                                c
c                                                                       c
c       k      ____    k                                                c
c             |    |          =    -i (G(k)uv_sig + G(k)G(5)ua_sig      c
c       ~~~~~~|____|~~~~~~               + us_sig +     G(5)up_sig)     c
c      l_i             l_j                                              c
c                                                                       c
c                                                                       c
c     i and j are the flavors of incoming and outgoing quark            c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Vector self-energy (proportional to k(mu)gamma(mu) = G(k)))       c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function uv_sig1(s,i,j)
c     Up quark and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        uv_sig1 = 0
      else
c     Full diagram:
c        uv_sig1 = 8.d0/9*e2*b1(s,um(i),0.d0)
c     1          + idflag*4.d0/9*e2
c     DRED-DIMREG difference:
        uv_sig1 = (idflag - 1)*4*e2/9.d0
      end if
      return
      end

      complex*16 function uv_sig10(s,i,j)
c     Up quark and gluon in loop
c     Since this diagram IN DIMREG is included into an overall QCD
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
      al = alfas(zm)
        uv_sig10 = 0
      else
c     Full diagram
c        uv_sig10 = 32*pi/3.d0*alfas(zm)*b1(s,um(i),0.d0)
c     1           + idflag*16*pi/3.d0*alfas(zm)
c     DRED-DIMREG difference:
        uv_sig10 = (idflag - 1)*16*pi/3.d0*al
      end if
      return
      end

      complex*16 function uv_sig2(s,i,j)
c     Up quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        uv_sig2 = 0
      else
        x = st2/3
        uv_sig2 = e2/4/sct2*(1 - 8*x + 32*x*x)*b1(s,um(i),zm)
     1          + idflag*e2/8/sct2*(1 - 8*x + 32*x*x)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function uv_sig3(s,i,j)
c     Down quark and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      uv_sig3 = 0
      do 10 k=1,3
10        uv_sig3 = uv_sig3
     1            + e2/st2/2*ckm(k,i)*conjg(ckm(k,j))*b1(s,dm(k),wm)
     2            + idflag*e2/st2/4*ckm(k,i)*conjg(ckm(k,j))
c     the last line vanishes in DRED
      return
      end

      complex*16 function uv_sig4(s,i,j)
c     Down quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      uv_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        uv_sig4 = uv_sig4 + (um(j)*um(i)*(zh(2,k)/v2)**2
     1            + (zh(1,k)*dm(l)/v1)**2)
     2            * ckm(l,i)*conjg(ckm(l,j))*b1(s,dm(l),cm(k))
      return
      end

      complex*16 function uv_sig5(s,i,j)
c     Up quark + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      uv_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      uv_sig5 = uv_sig5 + (um(i)/v2*zr(2,k))**2*b1(s,um(i),rm(k))
      return
      end

      complex*16 function uv_sig6(s,i,j)
c     Up quark + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      uv_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      uv_sig6 = uv_sig6 + (um(i)/v2*zh(2,k))**2*b1(s,um(i),pm(k))
      return
      end

      complex*16 function uv_sig7(s,i,j)
c     Neutralino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zn
      complex*16 vl_uun,vr_uun
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      uv_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        uv_sig7 = uv_sig7 + (vl_uun(i,k,l)*conjg(vl_uun(j,k,l))
     1            + vr_uun(i,k,l)*conjg(vr_uun(j,k,l)))/2
     2            * b1(s,fnm(l),sum(k))
      return
      end

      complex*16 function uv_sig8(s,i,j)
c     Chargino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_udc,vr_udc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      uv_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        uv_sig8 = uv_sig8 + (vl_udc(i,k,l)*conjg(vl_udc(j,k,l))
     1            + vr_udc(i,k,l)*conjg(vr_udc(j,k,l)))/2
     2            * b1(s,fcm(l),sdm(k))
      return
      end

      complex*16 function uv_sig9(s,i,j)
c     gluino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      al = alfas(zm)
      uv_sig9 = 0
      do 10 k=1,6
10      uv_sig9 = uv_sig9 + 16*pi*al*(zu(j,k)*conjg(zu(i,k))
     1          + zu(j+3,k)*conjg(zu(i+3,k)))*b1(s,2*gm1,sum(k))/3.d0
      return
      end

      complex*16 function uv_sig(s,i,j)
c     Full bare up quark self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 uv_sig1,uv_sig2,uv_sig3,uv_sig4,uv_sig10,
     1           uv_sig5,uv_sig6,uv_sig7,uv_sig8,uv_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      uv_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in uv_sig!'
      if (if*ig*iq.eq.1) uv_sig = uv_sig + uv_sig1(s,i,j)
     1                                   + uv_sig10(s,i,j)
     2       + uv_sig2(s,i,j) + uv_sig3(s,i,j) + uv_sig4(s,i,j)
     3       + uv_sig5(s,i,j) + uv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) uv_sig = uv_sig + uv_sig7(s,i,j)
     1                     + uv_sig8(s,i,j) + uv_sig9(s,i,j)
      uv_sig = uv_sig/16/pi/pi
      return
      end

      complex*16 function uv_ren(s,i,j)
c     Full renormalized up quark self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 uv_sig
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      uv_ren = uv_sig(s,i,j) - (dzlq(i) + dzru(i))/2
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Axial self-energy (proportional to k(mu)gamma(mu)gamma(5))        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ua_sig2(s,i,j)
c     Up quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        ua_sig2 = 0
      else
        ua_sig2 = - e2/4/sct2*(1 - 8*st2/3.d0)*b1(s,um(i),zm)
     1            - idflag*e2/8/sct2*(1 - 8*st2/3.d0)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ua_sig3(s,i,j)
c     Down quark and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      ua_sig3 = 0
      do 10 k=1,3
10      ua_sig3 = ua_sig3
     1          - e2/st2/2*ckm(k,i)*conjg(ckm(k,j))*b1(s,dm(k),wm)
     2          - idflag*e2/st2/4*ckm(k,i)*conjg(ckm(k,j))
c     the last line vanishes in DRED
      return
      end

      complex*16 function ua_sig4(s,i,j)
c     Down quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      ua_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        ua_sig4 = ua_sig4 + (um(i)*um(j)*(zh(2,k)/v2)**2
     1            - (zh(1,k)*dm(l)/v1)**2)
     2            * ckm(l,i)*conjg(ckm(l,j))*b1(s,dm(l),cm(k))
      return
      end

      complex*16 function ua_sig7(s,i,j)
c     Neutralino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zn
      complex*16 vl_uun,vr_uun
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      ua_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        ua_sig7 = ua_sig7 - (vl_uun(i,k,l)*conjg(vl_uun(j,k,l))
     1            - vr_uun(i,k,l)*conjg(vr_uun(j,k,l)))/2
     2            * b1(s,fnm(l),sum(k))
      return
      end

      complex*16 function ua_sig8(s,i,j)
c     Chargino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_udc,vr_udc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ua_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        ua_sig8 = ua_sig8 - (vl_udc(i,k,l)*conjg(vl_udc(j,k,l))
     1            - vr_udc(i,k,l)*conjg(vr_udc(j,k,l)))/2
     2            * b1(s,fcm(l),sdm(k))
      return
      end

      complex*16 function ua_sig9(s,i,j)
c     gluino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      al = alfas(zm)
      ua_sig9 = 0
      do 10 k=1,6
10      ua_sig9 = ua_sig9 - 16*pi*al*(zu(j,k)*conjg(zu(i,k))
     1          - zu(j+3,k)*conjg(zu(i+3,k)))*b1(s,2*gm1,sum(k))/3.d0
      return
      end

      complex*16 function ua_sig(s,i,j)
c     Full bare up quark self-energy, axial part
      implicit double precision (a-h,o-z)
      complex*16 ua_sig2,ua_sig3,ua_sig4,ua_sig7,ua_sig8,ua_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ua_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in).or.(is.ne.il))
     1   stop 'if=ig and is=ic=in=il required in ua_sig!'
      if (if*ig.eq.1) ua_sig = ua_sig + ua_sig2(s,i,j) + ua_sig3(s,i,j)
     1                                + ua_sig4(s,i,j)
      if (is*in*ic*il.eq.1) ua_sig = ua_sig + ua_sig7(s,i,j)
     1                     + ua_sig8(s,i,j) + ua_sig9(s,i,j)
      ua_sig = ua_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Scalar self-energy                                                c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function us_sig1(s,i,j)
c     Up quark and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        us_sig1 = 0
      else
c     Full diagram:
c        us_sig1 = 16/9.d0*e2*um(i)*b0(s,um(i),0.d0)
c     1          - idflag*8/9.d0*e2*um(i)
c     DRED-DIMREG difference:
        us_sig1 = (1 - idflag)*8/9.d0*e2*um(i)
      end if
      return
      end

      complex*16 function us_sig10(s,i,j)
c     Up quark and gluon in loop
c     Since this diagram IN DIMREG is included into an overall QCD
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      al = alfas(zm)
      if (i.ne.j) then
        us_sig10 = 0
      else
c     Full diagram:
c        us_sig10 = 64*pi/3.d0*alfas(zm)*um(i)*b0(s,um(i),0.d0)
c     1           - idflag*32*pi/3.d0*alfas(zm)*um(i)
c     DRED-DIMREG difference:
        us_sig10 = (1 - idflag)*32*pi/3.d0*al*um(i)
      end if
      return
      end

      complex*16 function us_sig2(s,i,j)
c     Up quark and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        us_sig2 = 0
      else
        us_sig2 = - 4*e2/ct2/9.d0*um(i)*(3 - 4*st2)*b0(s,um(i),zm)
     1            + idflag*2*e2/ct2/9.d0*um(i)*(3 - 4*st2)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function us_sig4(s,i,j)
c     Down quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      us_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        us_sig4 = us_sig4 - (zh(2,k)*zh(1,k)*dm(l)*dm(l)/v1/v2)
     1            *(um(i) + um(j))*ckm(l,i)*conjg(ckm(l,j))
     2            * b0(s,dm(l),cm(k))
      return
      end

      complex*16 function us_sig5(s,i,j)
c     Up quark + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      us_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      us_sig5 = us_sig5 - um(i)**3*(zr(2,k)/v2)**2*b0(s,um(i),rm(k))
      return
      end

      complex*16 function us_sig6(s,i,j)
c     Up quark + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      us_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      us_sig6 = us_sig6 + um(i)**3*(zh(2,k)/v2)**2*b0(s,um(i),pm(k))
      return
      end

      complex*16 function us_sig7(s,i,j)
c     Neutralino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zn
      complex*16 vl_uun,vr_uun
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      us_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        us_sig7 = us_sig7 - (vl_uun(i,k,l)*conjg(vr_uun(j,k,l))
     1            + vr_uun(i,k,l)*conjg(vl_uun(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),sum(k))
      return
      end

      complex*16 function us_sig8(s,i,j)
c     Chargino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_udc,vr_udc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      us_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        us_sig8 = us_sig8 - (vl_udc(i,k,l)*conjg(vr_udc(j,k,l))
     1            + vr_udc(i,k,l)*conjg(vl_udc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),sdm(k))
      return
      end

      complex*16 function us_sig9(s,i,j)
c     gluino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      al = alfas(zm)
      us_sig9 = 0
      do 10 k=1,6
10      us_sig9 = us_sig9 + 32*pi*al*(zu(j,k)*conjg(zu(i+3,k))
     1          + zu(j+3,k)*conjg(zu(i,k)))*gm1*b0(s,2*gm1,sum(k))/3.d0
      return
      end

      complex*16 function us_sig(s,i,j)
c     Full bare up quark self-energy, scalar part
      implicit double precision (a-h,o-z)
      complex*16 us_sig1,us_sig2,us_sig4,us_sig5,us_sig6,us_sig7,
     1           us_sig8,us_sig9,us_sig10
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      us_sig = (0,0)
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in us_sig!'
      if (if*ig*iq.eq.1) us_sig = us_sig + us_sig1(s,i,j)
     1                                   + us_sig10(s,i,j)
     2                  + us_sig2(s,i,j) + us_sig4(s,i,j)
     3                  + us_sig5(s,i,j) + us_sig6(s,i,j)
      if (is*in*ic*il.eq.1) us_sig = us_sig + us_sig7(s,i,j)
     1                     + us_sig8(s,i,j) + us_sig9(s,i,j)
      us_sig = us_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Pseudoscalar self-energy (proportional to G(5)                    c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function up_sig4(s,i,j)
c     Down quark + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      up_sig4 = 0
      do 10 l=1,3
        do 10 k=1,2
10        up_sig4 = up_sig4 + (zh(2,k)*zh(1,k)*dm(l)*dm(l)/v1/v2)
     1            * (um(i) - um(j))*ckm(l,i)*conjg(ckm(l,j))
     2            * b1(s,dm(l),cm(k))
      return
      end

      complex*16 function up_sig7(s,i,j)
c     Neutralino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zn
      complex*16 vl_uun,vr_uun
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      up_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        up_sig7 = up_sig7 + (vl_uun(i,k,l)*conjg(vr_uun(j,k,l))
     1            - vr_uun(i,k,l)*conjg(vl_uun(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),sum(k))
      return
      end

      complex*16 function up_sig8(s,i,j)
c     Chargino and down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zu,zd,zpos,zneg
      complex*16 vl_udc,vr_udc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      up_sig8 = 0
      do 10 k=1,6
        do 10 l=1,2
10        up_sig8 = up_sig8 + (vl_udc(i,k,l)*conjg(vr_udc(j,k,l))
     1            - vr_udc(i,k,l)*conjg(vl_udc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),sdm(k))
      return
      end

      complex*16 function up_sig9(s,i,j)
c     gluino and up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zu,zd
      complex*16 gm2,gm3
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/gmass/gm1,gm2,gm3
      al = alfas(zm)
      up_sig9 = 0
      do 10 k=1,6
10      up_sig9 = up_sig9 - 32*pi*al*(zu(j,k)*conjg(zu(i+3,k))
     1          - zu(j+3,k)*conjg(zu(i,k)))*gm1*b1(s,2*gm1,sum(k))/3.d0
      return
      end

      complex*16 function up_sig(s,i,j)
c     Full bare up quark self-energy, pseudoscalar part
      implicit double precision (a-h,o-z)
      complex*16 up_sig4,up_sig7,up_sig8,up_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      up_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in).or.(is.ne.il))
     1   stop 'if=ig and is=ic=in=il required in up_sig!'
      if (if*ig.eq.1) up_sig = up_sig + up_sig4(s,i,j)
      if (is*in*ic*il.eq.1) up_sig = up_sig + up_sig7(s,i,j)
     1                     + up_sig8(s,i,j) + up_sig9(s,i,j)
      up_sig = up_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Left and right self-energy                                        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ul_sig(s,i,j)
c     Full bare up quark self-energy, left part
      implicit double precision (a-h,o-z)
      complex*16 uv_sig1,uv_sig2,uv_sig3,uv_sig4,
     1           uv_sig5,uv_sig6,uv_sig7,uv_sig8,uv_sig9,uv_sig10
      complex*16 ua_sig2,ua_sig3,ua_sig4,ua_sig7,ua_sig8,ua_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ul_sig = (0,0)
      if (if*ig*iq.eq.1) ul_sig = ul_sig + uv_sig1(s,i,j)
     1                                   + uv_sig10(s,i,j)
     2                  + uv_sig2(s,i,j) - ua_sig2(s,i,j)
     3                  + uv_sig3(s,i,j) - ua_sig3(s,i,j)
     4                  + uv_sig4(s,i,j) - ua_sig4(s,i,j)
     5                  + uv_sig5(s,i,j) + uv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) ul_sig = ul_sig
     1                  + uv_sig7(s,i,j) - ua_sig7(s,i,j)
     2                  + uv_sig8(s,i,j) - ua_sig8(s,i,j)
     3                  + uv_sig9(s,i,j) - ua_sig9(s,i,j)
      ul_sig = ul_sig/16/pi/pi
      return
      end

      complex*16 function ur_sig(s,i,j)
c     Full bare up quark self-energy, right part
      implicit double precision (a-h,o-z)
      complex*16 uv_sig1,uv_sig2,uv_sig3,uv_sig4,
     1           uv_sig5,uv_sig6,uv_sig7,uv_sig8,uv_sig9,uv_sig10
      complex*16 ua_sig2,ua_sig3,ua_sig4,ua_sig7,ua_sig8,ua_sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ur_sig = (0,0)
      if (if*ig*iq.eq.1) ur_sig = ur_sig + uv_sig1(s,i,j)
     1                                   + uv_sig10(s,i,j)
     2                  + uv_sig2(s,i,j) + ua_sig2(s,i,j)
     3                  + uv_sig3(s,i,j) + ua_sig3(s,i,j)
     4                  + uv_sig4(s,i,j) + ua_sig4(s,i,j)
     5                  + uv_sig5(s,i,j) + uv_sig6(s,i,j)
      if (is*in*ic*il.eq.1) ur_sig = ur_sig
     1                  + uv_sig7(s,i,j) + ua_sig7(s,i,j)
     2                  + uv_sig8(s,i,j) + ua_sig8(s,i,j)
     3                  + uv_sig9(s,i,j) + ua_sig9(s,i,j)
      ur_sig = ur_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Constant terms in uv_sig,us_sig                                   c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      double precision function uv_sigc()
c     Constant contribution to uv_sig
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      al = alfas(zm)
      if (if.ne.ig) stop 'if=ig required in uv_sigc!'
      uv_sigc = 0
      if (if*ig.ne.1) return
c     DIMREG:
      if (idflag.eq.1) uv_sigc = (e2/8/sct2*(1 - 8*st2/3.d0
     1                         + 32*st2*st2/9.d0) + e2/st2/4)/16/pi/pi
c     DRED:
      if (idflag.eq.0) uv_sigc = ( - 4*e2/9.d0 - 16*pi/3.d0*al)/16/pi/pi
      return
      end

      double precision function us_sigc()
c     Constant contribution to us_sig; um(i) factorized
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      al = alfas(zm)
      if (if.ne.ig) stop 'if=ig required in us_sigc!'
      us_sigc = 0
      if (if*ig.ne.1) return
c     DIMREG:
      if (idflag.eq.1) us_sigc = 2*e2/ct2/9.d0*(3 - 4*st2)/16/pi/pi
c     DRED:
      if (idflag.eq.0) us_sigc = (8*e2/9.d0 + 32*pi/3.d0*al)/16/pi/pi
      return
      end




