c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: VF_DEF.FOR
c     Released: 5: 1:1993(J.R.)
c     Last revised: 28: 1:1993 (P.Ch.)
c     Vertices vl(r)_lsnc (lepton-sneutrino-chargino) added
 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for fermion vertices              c
c     Convention is such that the Feynman rule for the vertex is       c
c     (-i)*(expression calculated below)*(projector P_l or P_R)        c
c     Compare with the paper: J.Rosiek@Phys.Rev.D41(1990)p.3464;       c
c     erratum, hep-ph/9511250                                          c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      complex*16 function v_nnn(i,j,k)
c     Neutrino-sneutrino-neutralino vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      v_nnn = -e/sct/sq2*conjg(zv(i,j))*(zn(1,k)*st - zn(2,k)*ct)
      return
      end
 
      complex*16 function vl_lln(i,j,k)
c     Lepton-slepton-neutralino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vl_lln = -e/sct/sq2*zl(i,j)*(zn(1,k)*st + zn(2,k)*ct)
     1       + em(i)*sq2/v1*zl(i+3,j)*zn(3,k)
      return
      end
 
      complex*16 function vr_lln(i,j,k)
c     Lepton-slepton-neutralino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vr_lln = sq2*(e/ct*zl(i+3,j)*conjg(zn(1,k))
     1       + em(i)/v1*zl(i,j)*conjg(zn(3,k)))
      return
      end
 
      complex*16 function vl_lsnc(i,j,k)
c     Lepton-sneutrino-chargino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zpos,zneg
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      vl_lsnc = e/st*conjg(zv(i,j))*zpos(1,k)
      return
      end
 
      complex*16 function vr_lsnc(i,j,k)
c     Lepton-sneutrino-chargino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zpos,zneg
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vr_lsnc = -em(i)*sq2/v1*conjg(zv(i,j)*zneg(2,k))
      return
      end
 
      complex*16 function v_nlc(i,j,k)
c     Neutrino-slepton-chargino vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zpos,zneg
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      v_nlc = e/st*zl(i,j)*zneg(1,k) - em(i)*sq2/v1*zl(i+3,j)*zneg(2,k)
      return
      end
 
      complex*16 function vl_uun(i,j,k)
c     Up quark-up squark-neutralino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vl_uun =  e/sct/sq2*conjg(zu(i,j))*(zn(1,k)*st/3 + zn(2,k)*ct)
     1       + um(i)*sq2/v2*conjg(zu(i+3,j))*zn(4,k)
      return
      end
 
      complex*16 function vr_uun(i,j,k)
c     Up quark-up squark-neutralino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vr_uun = -2*sq2*e/3.d0/ct*conjg(zu(i+3,j)*zn(1,k))
     1       + um(i)*sq2/v2*conjg(zu(i,j)*zn(4,k))
      return
      end
 
      complex*16 function vl_ddn(i,j,k)
c     Down quark-down squark-neutralino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vl_ddn =  e/sct/sq2*zd(i,j)*(zn(1,k)*st/3 - zn(2,k)*ct)
     1       + dm(i)*sq2/v1*zd(i+3,j)*zn(3,k)
      return
      end
 
      complex*16 function vr_ddn(i,j,k)
c     Down quark-down squark-neutralino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zn
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/neut/fnm(4),zn(4,4)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vr_ddn = sq2*(e/3/ct*zd(i+3,j)*conjg(zn(1,k))
     1       + dm(i)/v1*zd(i,j)*conjg(zn(3,k)))
      return
      end
 
      complex*16 function vl_duc(i,j,k)
c     Down quark-up squark-chargino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zpos,zneg
      complex*16 ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/km_mat/ckm(3,3)
      vl_duc = 0
      do 10 l=1,3
10      vl_duc = vl_duc + conjg(ckm(i,l))*(e/st*conjg(zu(l,j))*zpos(1,k)
     1         - um(l)*sq2/v2*conjg(zu(l+3,j))*zpos(2,k))
      return
      end
 
      complex*16 function vr_duc(i,j,k)
c     Down quark-up squark-chargino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zpos,zneg
      complex*16 ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/km_mat/ckm(3,3)
      vr_duc = 0
      do 10 l=1,3
10      vr_duc = vr_duc - dm(i)*sq2/v1*conjg(zu(l,j)*zneg(2,k)*ckm(i,l))
      return
      end
 
      complex*16 function vl_udc(i,j,k)
c     Up quark-down squark-chargino left vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zpos,zneg
      complex*16 ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/km_mat/ckm(3,3)
      vl_udc = 0
      do 10 l=1,3
10      vl_udc = vl_udc + (e/st*zd(l,j)*zneg(1,k)
     1         - dm(l)*sq2/v1*zd(l+3,j)*zneg(2,k))*ckm(l,i)
      return
      end
 
      complex*16 function vr_udc(i,j,k)
c     Up quark-down squark-chargino right vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,zpos,zneg
      complex*16 ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/km_mat/ckm(3,3)
      vr_udc = 0
      do 10 l=1,3
10      vr_udc = vr_udc - um(i)*sq2/v2*zd(l,j)*conjg(zpos(2,k))*ckm(l,i)
      return
      end



