c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: VFF_FUN.FOR
c     Released: 19: 2: 1994(J.R. )
c     Corrected: 2: 3: 1994(P.Ch.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains standard functions for the                   c 
c     Z0-fermion-fermion vertex formfactor                            c        
c                                                                     c
c     Incoming Z0:          momentum (p+q)(\mu)                       c
c     Outgoing antifermion: momentum  p                               c
c     Outgoing fermion:     momentum  q                               c
c                                                                     c
c                              V3            _                        c
c                               ____________ f                        c
c                             /|      p (outgoing)                    c
c                        L1 /  |                                      c
c                         /    |                                      c
c        Z^0_{\mu}      /      | L2                                   c
c               ~~~~~~~~\V1    |                                      c
c       p+q (incoming)    \    |                                      c
c                        L3 \  |                                      c
c                             \|_____________ f'                      c
c                              V2     q (outgoing)                    c
c                                                                     c
c       General form of the vertex (G(mu) = gamma(mu),                c 
c       G(5)= gamma(5)):                                              c
c                                                                     c
c       V = V_tree                                                    c
c         + i(F_1 G(mu) - F_2 G(mu)G(5) + F_3 p(mu)                   c
c           - F_4 p(mu)G(5) + F_5 q(mu) - F_6 q(mu)G(5))              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c      Other arguments:                                               c
c       f1,f2:           masses of incoming and outgoing fermion      c
c       d1,d2,d3:        masses of particles circulating in loop      c 
c                        on lines L1,L2,L3 respectively               c
c       v_i,a_i,s_i,p_i: vector and axial parts of couplings          c
c                        in the vertices (complex in general)         c
c       form:      complex output array containing formfactor values  c
c                                                                     c
c      Only F_1, F_2 require renormalization.                         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine sff_vert(d1,d2,d3,v1,a1,s2,p2,s3,p3,form)
c     Vector boson - fermion - fermion vertex
c     Fermion-fermion-scalar loop
c     Vertices in loop:
c       V1: -i G(mu)(v1 - a1 G(5))
c       V2: -i (s2 - p2 G(5))
c       V3: -i (s3 - p3 G(5))
      implicit double precision (a-h,o-z)
      complex*16 v1,a1,s2,p2,s3,p3
      complex*16 form(6)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = (v1*(s2*s3 - p2*p3) + a1*(p2*s3 - s2*p3))
     1        * (2*c24(d1,d2,d3) + 2*pq*c23(d1,d2,d3) + p*c21(d1,d2,d3)
     2        + q*c22(d1,d2,d3) + (p + f1*f2)*c11(d1,d2,d3)
     3        + (2*pq + q - f1*f2)*c12(d1,d2,d3) + 0.5d0)
     4        - (v1*(s2*s3 + p2*p3) + a1*(p2*s3 + s2*p3))*d1
     5        * ((f1 + f2)*c0(d1,d2,d3) + f1*c11(d1,d2,d3)
     6        + f2*c12(d1,d2,d3))
     7        + (v1*(s2*s3 + p2*p3) - a1*(p2*s3 + s2*p3))*d3
     8        * (f1*c11(d1,d2,d3) + f2*c12(d1,d2,d3))
     9        - (v1*(s2*s3 - p2*p3) - a1*(p2*s3 - s2*p3))*d1*d3
     a        * c0(d1,d2,d3)
c     Axial formfactor
      form(2) = (v1*(p2*s3 - s2*p3) + a1*(s2*s3 - p2*p3))
     1        * (2*c24(d1,d2,d3) + 2*pq*c23(d1,d2,d3) + p*c21(d1,d2,d3)
     2        + q*c22(d1,d2,d3) + (p - f1*f2)*c11(d1,d2,d3)
     3        + (2*pq + q + f1*f2)*c12(d1,d2,d3) + 0.5d0)
     4        - (v1*(p2*s3 + s2*p3) + a1*(s2*s3 + p2*p3))*d1
     5        * ((f1 - f2)*c0(d1,d2,d3) + f1*c11(d1,d2,d3)
     6        - f2*c12(d1,d2,d3))
     7        + (v1*(p2*s3 + s2*p3) - a1*(s2*s3 + p2*p3))*d3
     8        * (f1*c11(d1,d2,d3) - f2*c12(d1,d2,d3))
     9        - (v1*(p2*s3 - s2*p3) - a1*(s2*s3 - p2*p3))*d1*d3
     a        * c0(d1,d2,d3)
c     Scalar formfactor proportional to p(mu)
      form(3) = - 2*(v1*(s2*s3 - p2*p3) + a1*(p2*s3 - s2*p3))
     1        * (f2*(c12(d1,d2,d3) + c23(d1,d2,d3))
     2        - f1*(c11(d1,d2,d3) + c21(d1,d2,d3)))
     3        - 2*(v1*(s2*s3 + p2*p3) + a1*(p2*s3 + s2*p3))*d1
     4        * (c0(d1,d2,d3) + c11(d1,d2,d3))
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = - 2*(v1*(p2*s3 - s2*p3) + a1*(s2*s3 - p2*p3))
     1        * (f2*(c12(d1,d2,d3) + c23(d1,d2,d3))
     2        + f1*(c11(d1,d2,d3) + c21(d1,d2,d3)))
     3        + 2*(v1*(p2*s3 + s2*p3) + a1*(s2*s3 + p2*p3))*d1
     4        * (c0(d1,d2,d3) + c11(d1,d2,d3))
c     Scalar formfactor proportional to q(mu)
      form(5) = - 2*(v1*(s2*s3 - p2*p3) + a1*(p2*s3 - s2*p3))
     1        * ((f2 - f1)*c12(d1,d2,d3) + f2*c22(d1,d2,d3)
     2        - f1*c23(d1,d2,d3))
     3        - 2*(v1*(s2*s3 + p2*p3) - a1*(p2*s3 + s2*p3))*d3
     4        * c12(d1,d2,d3)
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = - 2*(v1*(p2*s3 - s2*p3) + a1*(s2*s3 - p2*p3))
     1        * ((f2 + f1)*c12(d1,d2,d3) + f2*c22(d1,d2,d3)
     2        + f1*c23(d1,d2,d3))
     3        + 2*(v1*(p2*s3 + s2*p3) - a1*(s2*s3 + p2*p3))*d3
     4        * c12(d1,d2,d3)
      call creset  
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end

      subroutine fss_vert(d1,d2,d3,s2,p2,s3,p3,form)
c     Vector boson - fermion - fermion vertex
c     Scalar-scalar-fermion loop
c     Vertices in loop:
c       V1: -i c^v (2k+p+q)_{\mu}  c^v  - factorized constant
c       V2: -i (s2 - p2 G(5))
c       V3: -i (s3 - p3 G(5)) 
      implicit double precision (a-h,o-z)
      complex*16 s2,p2,s3,p3
      complex*16 form(6)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = - 2*(s2*s3 - p2*p3)*c24(d1,d2,d3)
c     Axial formfactor
      form(2) = - 2*(p2*s3 - s2*p3)*c24(d1,d2,d3)
c     Scalar formfactor proportional to p(mu)
      form(3) = (s2*s3 - p2*p3)*(f1*(c0(d1,d2,d3) 
     1        + 3*c11(d1,d2,d3) + 2*c21(d1,d2,d3))
     2        - f2*(c12(d1,d2,d3) + 2*c23(d1,d2,d3)))
     3        + (s2*s3 + p2*p3)*d2*(c0(d1,d2,d3) + 2*c11(d1,d2,d3))
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = - (p2*s3 - s2*p3)*(f1*(c0(d1,d2,d3) 
     1        + 3*c11(d1,d2,d3) + 2*c21(d1,d2,d3))
     2        + f2*(c12(d1,d2,d3) + 2*c23(d1,d2,d3)))
     3        - (p2*s3 + s2*p3)*d2*(c0(d1,d2,d3) + 2*c11(d1,d2,d3))
c     Scalar formfactor proportional to q(mu)
      form(5) = (s2*s3 - p2*p3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3)
     1        + 2*c12(d1,d2,d3) + 2*c23(d1,d2,d3))
     2        - f2*(c12(d1,d2,d3) + 2*c22(d1,d2,d3)))
     3        + (s2*s3 + p2*p3)*d2*(c0(d1,d2,d3) + 2*c12(d1,d2,d3))
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = - (p2*s3 - s2*p3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3)
     1        + 2*c12(d1,d2,d3) + 2*c23(d1,d2,d3))
     2        + f2*(c12(d1,d2,d3) + 2*c22(d1,d2,d3)))
     3        - (p2*s3 + s2*p3)*d2*(c0(d1,d2,d3) + 2*c12(d1,d2,d3))
      call creset
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end

      subroutine vff_vert(d1,d2,d3,v1,a1,v2,a2,v3,a3,form)
c     Vector boson - fermion - fermion vertex
c     Fermion-fermion-vector boson loop
c     Vertices in loop:
c       V1: -i G(mu)(v1 - a1 G(5))
c       V2: -i G(al)(v2 - a2 G(5))
c       V3: -i G(be)(v3 - a3 G(5))
      implicit double precision (a-h,o-z)
      complex*16 v1,v2,v3,a1,a2,a3
      complex*16 form(6)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = 2*(v1*(v2*v3 + a2*a3) + a1*(a2*v3 + v2*a3))
     1        * (2*c24(d1,d2,d3) + 2*pq*c23(d1,d2,d3) + p*c21(d1,d2,d3)
c     Add this line to get the DIMREG result:
     1        + 0.5d0
     2        + q*c22(d1,d2,d3) + (2*pq + p - f1*f2)*c11(d1,d2,d3)
     3        + (q + f1*f2)*c12(d1,d2,d3) + 0.5d0)
     4        - 2*(v1*(v2*v3 + a2*a3) - a1*(a2*v3 + v2*a3))*d1*d3
     5        * c0(d1,d2,d3)
c     Axial formfactor
      form(2) = - 2*(v1*(a2*v3 + v2*a3) + a1*(v2*v3 + a2*a3))
     1        * (2*c24(d1,d2,d3) + 2*pq*c23(d1,d2,d3) + p*c21(d1,d2,d3)
c     Add this line to get the DIMREG result:
     1        + 0.5d0
     2        + q*c22(d1,d2,d3) + (2*pq + p + f1*f2)*c11(d1,d2,d3)
     3        + (q - f1*f2)*c12(d1,d2,d3) + 0.5d0)
     4        + 2*(v1*(a2*v3 + v2*a3) - a1*(v2*v3 + a2*a3))*d1*d3
     5        * c0(d1,d2,d3)
c     Scalar formfactor proportional to p(mu)
      form(3) = 4*(v1*(v2*v3 + a2*a3) + a1*(a2*v3 + v2*a3))
     1        * (f1*c21(d1,d2,d3) - f2*c23(d1,d2,d3)
     2        + (f1 - f2)*c11(d1,d2,d3))
     3        + 4*(v1*(v2*v3 - a2*a3) + a1*(a2*v3 - v2*a3))*d1
     4        * (c0(d1,d2,d3) + c11(d1,d2,d3))
     5        + 4*(v1*(v2*v3 - a2*a3) - a1*(a2*v3 - v2*a3))*d3
     6        * c11(d1,d2,d3)
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = 4*(v1*(a2*v3 + v2*a3) + a1*(v2*v3 + a2*a3))
     1        * (f1*c21(d1,d2,d3) + f2*c23(d1,d2,d3)
     2        + (f1 + f2)*c11(d1,d2,d3))
     3        + 4*(v1*(a2*v3 - v2*a3) + a1*(v2*v3 - a2*a3))*d1
     4        * (c0(d1,d2,d3) + c11(d1,d2,d3))
     5        + 4*(v1*(a2*v3 - v2*a3) - a1*(v2*v3 - a2*a3))*d3
     6        * c11(d1,d2,d3)
c     Scalar formfactor proportional to q(mu)
      form(5) = 4*(v1*(v2*v3 + a2*a3) + a1*(a2*v3 + v2*a3))
     1        * (f1*(c23(d1,d2,d3) + c11(d1,d2,d3))
     2        - f2*(c22(d1,d2,d3) + c12(d1,d2,d3)))
     3        + 4*(v1*(v2*v3 - a2*a3) + a1*(a2*v3 - v2*a3))*d1
     4        * (c0(d1,d2,d3) + c12(d1,d2,d3))
     5        + 4*(v1*(v2*v3 - a2*a3) - a1*(a2*v3 - v2*a3))*d3
     6        * c12(d1,d2,d3)
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = 4*(v1*(a2*v3 + v2*a3) + a1*(v2*v3 + a2*a3))
     1        * (f1*(c23(d1,d2,d3) + c11(d1,d2,d3))
     2        + f2*(c22(d1,d2,d3) + c12(d1,d2,d3)))
     3        + 4*(v1*(a2*v3 - v2*a3) + a1*(v2*v3 - a2*a3))*d1
     4        * (c0(d1,d2,d3) + c12(d1,d2,d3))
     5        + 4*(v1*(a2*v3 - v2*a3) - a1*(v2*v3 - a2*a3))*d3
     6        * c12(d1,d2,d3)
      call creset
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end

      subroutine fww_vert(d1,d2,d3,v2,a2,v3,a3,form)
c     Vector boson - fermion - fermion vertex
c     W-W-fermion loop
c     Vertices in loop:
c       V1: +i c^v [ g(nu,la) (2k+p1+p2)^mu
c                  - g(mu,la) (k+2p1+2p2)^nu - g(mu,nu) (k-p1-p2)^la ]
c                  c^v factorized (pedy wedlug mojej notacji) 
c       V2: -i G(nu)(v2 - a2 G(5))
c       V3: -i G(la)(v3 - a3 G(5))
      implicit double precision (a-h,o-z)
      complex*16 v2,a2,v3,a3
      complex*16 form(6)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = - (v2*v3 + a2*a3)*(1 + 12*c24(d1,d2,d3) 
c     Add this line to get the DIMREG result:
     1        + 1
     1        + 4*pq*c23(d1,d2,d3)
     2        + 2*q*c22(d1,d2,d3) + 2*p*c21(d1,d2,d3)
     3        + (q + 3*f1*f2)*c12(d1,d2,d3) 
     4        + (4*pq + 3*p - 3*f1*f2)*c11(d1,d2,d3)
     5        + (4*pq + p - 3*f1*f2)*c0(d1,d2,d3))
     6        - 3*(v2*v3 - a2*a3)*(f1+f2)*d2*c0(d1,d2,d3)
c     Axial formfactor
      form(2) = (v2*a3 + a2*v3)*(1 + 12*c24(d1,d2,d3) 
c     Add this line to get the DIMREG result:
     1        + 1
     1        + 4*pq*c23(d1,d2,d3)
     2        + 2*q*c22(d1,d2,d3) + 2*p*c21(d1,d2,d3)
     3        + (q - 3*f1*f2)*c12(d1,d2,d3) 
     4        + (4*pq + 3*p + 3*f1*f2)*c11(d1,d2,d3)
     5        + (4*pq + p + 3*f1*f2)*c0(d1,d2,d3))
     6        - 3*(v2*a3 - a2*v3)*(f1-f2)*d2*c0(d1,d2,d3)
c     Scalar formfactor proportional to p(mu)
      form(3) = 2*(v2*v3 + a2*a3)*((f1+f2)*c0(d1,d2,d3)
     1        + (3*f1+f2)*c11(d1,d2,d3) - 3*f2*c12(d1,d2,d3)
     2        + 2*f1*c21(d1,d2,d3) - 2*f2*c23(d1,d2,d3))
     3        - 6*(v2*v3 - a2*a3)*(c0(d1,d2,d3)+c11(d1,d2,d3))*d2
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = 2*(v2*a3 + a2*v3)*((f1-f2)*c0(d1,d2,d3)
     1        + (3*f1-f2)*c11(d1,d2,d3) + 3*f2*c12(d1,d2,d3)
     2        + 2*f1*c21(d1,d2,d3) + 2*f2*c23(d1,d2,d3))
     3        + 6*(v2*a3 - a2*v3)*(c0(d1,d2,d3)+c11(d1,d2,d3))*d2
c     Scalar formfactor proportional to q(mu)
      form(5) = 2*(v2*v3 + a2*a3)*((3*f1-f2)*c12(d1,d2,d3)
     1        - f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        - 2*f2*c22(d1,d2,d3) + 2*f1*c23(d1,d2,d3))
     3        - 6*(v2*v3 - a2*a3)*c12(d1,d2,d3)*d2
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = 2*(v2*a3 + a2*v3)*((3*f1+f2)*c12(d1,d2,d3)
     1        - f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        + 2*f2*c22(d1,d2,d3) + 2*f1*c23(d1,d2,d3))
     3        + 6*(v2*a3 - a2*v3)*c12(d1,d2,d3)*d2
      call creset
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end

      subroutine fsv_vert(d1,d2,d3,v2,a2,s3,p3,form)
c     Vector boson - fermion - fermion vertex
c     Scalar-vector boson-fermion loop
c     Vertices in loop:
c       V1: +i c^v   c^v - factorized constant
c       V2: -i G(al)(v2 - a2 G(5))
c       V3: -i (s3 - p3 G(5))
      implicit double precision (a-h,o-z)
      complex*16 v2,a2,s3,p3
      complex*16 form(6)
      complex*16 c0,c11,c12
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = - (v2*s3 + a2*p3)*d2*c0(d1,d2,d3) 
     1        - (v2*s3 - a2*p3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        + f2*c12(d1,d2,d3))
c     Axial formfactor
      form(2) = (a2*s3 + v2*p3)*d2*c0(d1,d2,d3) 
     1        + (a2*s3 - v2*p3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        - f2*c12(d1,d2,d3))
c     Scalar formfactor proportional to p(mu)
      form(3) = 0
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = 0
c     Scalar formfactor proportional to q(mu)
      form(5) = 2*(v2*s3 - v2*p3)*c12(d1,d2,d3)
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = 2*(a2*s3 - v2*p3)*c12(d1,d2,d3)
      call creset
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end

      subroutine fvs_vert(d1,d2,d3,s2,p2,v3,a3,form)
c     Vector boson - fermion - fermion vertex
c     Vector boson-scalar-fermion loop
c     Vertices in loop:
c       V1: +i c^v   c^v - factorized constant
c       V2: -i (s2 - p2 G(5))
c       V3: -i G(al)(v3 - a3 G(5))
      implicit double precision (a-h,o-z)
      complex*16 s2,p2,v3,a3
      complex*16 form(6)
      complex*16 c0,c11,c12
      common/cargs/p,q,pq
      f1 = sqrt(p)
      f2 = sqrt(q)
c     Vector formfactor
      form(1) = - (s2*v3 - p2*a3)*d2*c0(d1,d2,d3) 
     1        + (s2*v3 + p2*a3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        + f2*c12(d1,d2,d3))
c     Axial formfactor
      form(2) = - (p2*v3 - s2*a3)*d2*c0(d1,d2,d3) 
     1        + (p2*v3 + s2*a3)*(f1*(c0(d1,d2,d3) + c11(d1,d2,d3))
     2        - f2*c12(d1,d2,d3))
c     Scalar formfactor proportional to p(mu)
      form(3) = 2*(s2*v3 + p2*a3)*(c0(d1,d2,d3) + c11(d1,d2,d3))
c     Pseudoscalar formfactor proportional to p(mu)gamma(5)
      form(4) = - 2*(p2*v3 + s2*a3)*(c0(d1,d2,d3) + c11(d1,d2,d3))
c     Scalar formfactor proportional to q(mu)
      form(5) = 0
c     Pseudoscalar formfactor proportional to q(mu)gamma(5)
      form(6) = 0
      call creset
      do 10 i=1,3
10      form(2*i) = - form(2*i)    
      return
      end





