c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: Z_SELF.FOR
c     Last revised: 25: 9:1992
c     Last correction: 15: 02:1993 (PCh)
c     gauge boson loop contribution adjusted to the DIMENSIONAL
c     REDUCTION regularization

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for Z0 self energy functions    c
c     and their renormalizations.                                    c
c     See: Chankowski,Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437     c
c     available as  hep-ph-9303309.                                  c
c                                                                    c
c     The definition of the self energy as follows:                  c
c                                                                    c
c       k      ____    k                                             c
c             |    |             = i g(mu,nu) zt_sig(k^2)            c
c       ~~~~~~|____|~~~~~~       + i (k^\mu k^\nu /k^2) zl_sig(k^2)  c
c       Z0^\mu         Z0^\nu                                        c
c                                                                    c
c                            (or = i g(mu,nu) zt_ren(k^2)            c
c                                + i (k^\mu m^\nu /k^2) zl_ren(k^2)  c
c                             for the renormalized version)          c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

***********************************************
*     First part - transversal self-energy    *
***********************************************

      complex*16 function zt_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      logical zstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/zwidth/z_gam,zfact,zstat
      ca2 = e2/sct2/16
      zt_3sig1 = - 12*ca2*(4*b22(s,0.d0,0.d0) + s*b0(s,0.d0,0.d0))
      do 10 k=1,3
        cv2 = ca2*(4*st2 - 1)**2
        zt_3sig1 = zt_3sig1 - 4*(cv2 + ca2)*(2*b22(s,em(k),em(k))
     1            + a(em(k)) + (s/2 - em(k)*em(k))*b0(s,em(k),em(k)))
     2            - 4*(cv2 - ca2)*em(k)*em(k)*b0(s,em(k),em(k))
        cv2 = ca2*(4*st2/3.d0 - 1)**2
        zt_3sig1 = zt_3sig1 - 12*zfact*(cv2 + ca2)*(2*b22(s,dm(k),dm(k))
     1            + a(dm(k)) + (s/2 - dm(k)*dm(k))*b0(s,dm(k),dm(k)))
     2            - 12*(cv2 - ca2)*dm(k)*dm(k)*b0(s,dm(k),dm(k))
        cv2 = ca2*(8*st2/3.d0 - 1)**2
10      zt_3sig1 = zt_3sig1 - 12*zfact*(cv2 + ca2)*(2*b22(s,um(k),um(k))
     1            + a(um(k)) + (s/2 - um(k)*um(k))*b0(s,um(k),um(k)))
     2            - 12*(cv2 - ca2)*um(k)*um(k)*b0(s,um(k),um(k))
      return
      end

      complex*16 function zt_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      zt_3sig2 = 0
      do 10 k=1,3
10      zt_3sig2 = zt_3sig2 + e2/sct2*b22(s,vm(k),vm(k))
      do 20 k=1,6
        do 20 l=1,6
          zt_3sig2 = zt_3sig2 + e2/sct2*abs(v_llz(k,l))**2
     1             * b22(s,slm(k),slm(l))
          zt_3sig2 = zt_3sig2 + 3*e2/sct2*abs(v_uuz(k,l))**2
     1             * b22(s,sum(k),sum(l))
20        zt_3sig2 = zt_3sig2 + 3*e2/sct2*abs(v_ddz(k,l))**2
     1             * b22(s,sdm(k),sdm(l))
      return
      end

      complex*16 function zt_3sig3(s)
c     Scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_3sig3 = 0
      do 10 k=1,2
        do 10 l=1,2
10        zt_3sig3 = zt_3sig3 + e2/sct2*am(k,l)**2*b22(s,pm(l),rm(k))
      return
      end

      complex*16 function zt_3sig4(s)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_3sig4 = 0
      do 10 k=1,2
10      zt_3sig4 = zt_3sig4 + e2*(ct2 - st2)**2/sct2*b22(s,cm(k),cm(k))
      return
      end

      complex*16 function zt_3sig5(s)
c     Z0 + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_3sig5 = 0
      do 10 k=1,2
10      zt_3sig5 = zt_3sig5 - e2*e2/sct2/sct2/4*cr(k)**2*b0(s,rm(k),zm)
      return
      end

      complex*16 function zt_3sig6(s)
c     Charged Goldstone + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zt_3sig6 = - 2*e2*zm2*st2*b0(s,wm,wm)
      return
      end

      complex*16 function zt_3sig7(s)
c     2 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zt_3sig7 = - 2*e2*ct2/st2*b22(s,wm,wm)
      return
      end

      complex*16 function zt_3sig8(s)
c     Neutralino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      complex*16 zn
      complex*16 vl_nnz,vr_nnz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      zt_3sig8 = 0
      do 10 k=1,4
        do 10 l=1,4
10        zt_3sig8 = zt_3sig8 - e2/sct2*((vl_nnz(k,l)*vl_nnz(l,k)
     1             + vr_nnz(k,l)*vr_nnz(l,k))*(4*b22(s,fnm(k),fnm(l))
     2             + (s - fnm(k)*fnm(k) - fnm(l)*fnm(l))
     3             * b0(s,fnm(l),fnm(k)) + a(fnm(k)) + a(fnm(l)))
     4             + (vr_nnz(l,k)*vl_nnz(k,l) + vr_nnz(k,l)*vl_nnz(l,k))
     5             * 2*fnm(k)*fnm(l)*b0(s,fnm(k),fnm(l)))/2
      return
      end

      complex*16 function zt_3sig9(s)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zt_3sig9 = 0
      do 10 k=1,2
        do 10 l=1,2
10        zt_3sig9 = zt_3sig9 - e2/sct2*((abs(vl_ccz(k,l))**2
     1             + abs(vr_ccz(k,l))**2)/4*(4*b22(s,fcm(l),fcm(k))
     2             + (s - fcm(k)*fcm(k) - fcm(l)*fcm(l))
     3             * b0(s,fcm(l),fcm(k)) + a(fcm(k)) + a(fcm(l)))
     4             + dble(vl_ccz(k,l)*vr_ccz(l,k))
     5             * fcm(k)*fcm(l)*b0(s,fcm(k),fcm(l)))
      return
      end

      complex*16 function zt_3sig10(s)
c     2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b22
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      zt_3sig10 = 2*e2*ct2/st2*((2*s + wm2)*b0(s,wm,wm) - a(wm)
     1          + 5*b22(s,wm,wm))
     2          - idflag*2*e2*ct2/st2*(2*wm2 - s/3)
c     the last term (in the third continuation line) vanishes in DRED.
      return
      end

      double precision function zt_4sig1()
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zu,zd
      complex*16 v_llzz,v_ddzz,v_uuzz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      zt_4sig1 = 0
      do 10 k=1,3
10      zt_4sig1 = zt_4sig1 + e2/sct2/2*a(vm(k))
      do 20 k=1,6
        zt_4sig1 = zt_4sig1 + 2*e2*dble(v_llzz(k,k))*a(slm(k))
        zt_4sig1 = zt_4sig1 + 6*e2*dble(v_uuzz(k,k))*a(sum(k))
20      zt_4sig1 = zt_4sig1 + 6*e2*dble(v_ddzz(k,k))*a(sdm(k))
      return
      end

      double precision function zt_4sig2()
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_4sig2 = 0
      do 10 k=1,2
10      zt_4sig2 = zt_4sig2 + e2*(ct2 - st2)**2/sct2/2*a(cm(k))
      return
      end

      double precision function zt_4sig3()
c     Scalars in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_4sig3 = 0
      do 10 k=1,2
10      zt_4sig3 = zt_4sig3 + e2/sct2/4*a(rm(k))
      return
      end

      double precision function zt_4sig4()
c     Pseudoscalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zt_4sig4 = 0
      do 10 k=1,2
10      zt_4sig4 = zt_4sig4 + e2/sct2/4*a(pm(k))
      return
      end

      double precision function zt_4sig5()
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      zt_4sig5 = e2*ct2/st2*6*a(wm)
     1         + idflag*e2*ct2/st2*4*wm2
c     the last term (in the continuation line) vanishes in DRED.
      return
      end

      complex*16 function zt_sig(s)
c     Full bare transversal Z0 self-energy
      implicit double precision (a-h,o-z)
      complex*16 zt_3sig1,zt_3sig2,zt_3sig3,zt_3sig4,
     1           zt_3sig5,zt_3sig6,zt_3sig7,zt_3sig8,
     2           zt_3sig9,zt_3sig10
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      zt_sig = 0
      if (if.eq.1) zt_sig = zt_sig  + zt_3sig1(s)
      if (is.eq.1) zt_sig = zt_sig  + zt_3sig2(s) + zt_4sig1()
      if (ig.eq.1) zt_sig = zt_sig  + zt_3sig3(s) + zt_3sig4(s)
     1               + zt_3sig5(s)  + zt_3sig6(s) + zt_3sig7(s)
     2               + zt_3sig10(s) + zt_4sig2()  + zt_4sig3()
     3               + zt_4sig4()   + zt_4sig5()
      if (ic.eq.1) zt_sig = zt_sig + zt_3sig9(s)
      if (in.eq.1) zt_sig = zt_sig + zt_3sig8(s)
      zt_sig = zt_sig/16/pi/pi
      return
      end

      complex*16 function zt_ren(s)
c     Full renormalized transversal Z0 self-energy
      implicit double precision (a-h,o-z)
      complex*16 zt_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      zt_ren = zt_sig(s) - s*(st2*dzb + ct2*dza) + 2*wm2*(dz2 - dza)
     1     + e2/sct2*dx/4
      return
      end

************************************************
*     Second part - longitudinal self energy   *
************************************************

      complex*16 function zl_3sig1(s)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      ca2 = e2/sct2/16
      zl_3sig1 = 24*ca2*(b0(s,0.d0,0.d0) + 2*x21(s,0.d0,0.d0)/s)
      do 10 k=1,3
        cv2 = ca2*(4*st2 - 1)**2
        zl_3sig1 = zl_3sig1 + 4*(cv2 + ca2)*(b0(s,em(k),em(k))
     1            + 2*x21(s,em(k),em(k))/s)
        cv2 = ca2*(4*st2/3.d0 - 1)**2
        zl_3sig1 = zl_3sig1 + 12*(cv2 + ca2)*(b0(s,dm(k),dm(k))
     1            + 2*x21(s,dm(k),dm(k))/s)
        cv2=ca2*(8*st2/3.d0 - 1)**2
10      zl_3sig1 = zl_3sig1 + 12*(cv2 + ca2)*(b0(s,um(k),um(k))
     1            + 2*x21(s,um(k),um(k))/s)
      return
      end

      complex*16 function zl_3sig2(s)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zv,zl,zu,zd
      complex*16 v_llz,v_uuz,v_ddz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      zl_3sig2 = 0
      do 10 k=1,3
10      zl_3sig2 = zl_3sig2 - e2/sct2*(x21(s,vm(k),vm(k))/s
     1           + b0(s,vm(k),vm(k))/4)
      do 20 k=1,6
        do 20 l=1,6
        zl_3sig2 = zl_3sig2 - e2/sct2*abs(v_llz(k,l)*v_llz(l,k))
     1           * (x21(s,slm(l),slm(k))/s + b0(s,slm(l),slm(k))/4)
        zl_3sig2 = zl_3sig2 - 3*e2/sct2*abs(v_uuz(k,l)*v_uuz(l,k))
     1           * (x21(s,sum(l),sum(k))/s + b0(s,sum(l),sum(k))/4)
20      zl_3sig2 = zl_3sig2 - 3*e2/sct2*abs(v_ddz(k,l)*v_ddz(l,k))
     1           * (x21(s,sdm(l),sdm(k))/s + b0(s,sdm(l),sdm(k))/4)
      return
      end

      complex*16 function zl_3sig3(s)
c     Scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zl_3sig3 = 0
      do 10 k=1,2
        do 10 l=1,2
10        zl_3sig3 = zl_3sig3 - e2/sct2/4*am(k,l)*am(l,k)
     1             * (4*x21(s,pm(l),rm(k))/s - b0(s,pm(l),rm(k))
     2             + 2*(a(rm(k)) - a(pm(l)) + (s + rm(k)*rm(k)
     3             - pm(l)*pm(l))*b0(s,pm(l),rm(k)))/s)
      return
      end

      complex*16 function zl_3sig4(s)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      zl_3sig4 = 0
      do 10 k=1,2
10      zl_3sig4 = zl_3sig4 - e2*(ct2 - st2)**2/sct2
     1           * (x21(s,cm(k),cm(k))/s + b0(s,cm(k),cm(k))/4)
      return
      end

      complex*16 function zl_3sig7(s)
c     2 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zl_3sig7 = e2*ct2/st2*(2*x21(s,wm,wm)/s + b0(s,wm,wm))
      return
      end

      complex*16 function zl_3sig8(s)
c     Neutralino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zn
      complex*16 vl_nnz,vr_nnz
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      zl_3sig8 = 0
      do 10 k=1,4
        do 10 l=1,4
10        zl_3sig8 = zl_3sig8 + e2/sct2*(vl_nnz(k,l)*vl_nnz(l,k)
     1             + vr_nnz(k,l)*vr_nnz(l,k))
     2             * ((s - fnm(l)*fnm(l) + fnm(k)*fnm(k))
     3             * b0(s,fnm(l),fnm(k)) - a(fnm(l)) + a(fnm(k))
     4             + 2*x21(s,fnm(l),fnm(k)))/s
      return
      end

      complex*16 function zl_3sig9(s)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,x21
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      zl_3sig9 = 0
      do 10 k=1,2
        do 10 l=1,2
10        zl_3sig9 = zl_3sig9 + e2/sct2*(abs(vl_ccz(k,l))**2
     1             + abs(vr_ccz(k,l))**2)*(b0(s,fcm(l),fcm(k))/2
     2             + x21(s,fcm(l),fcm(k))/s)
      return
      end

      complex*16 function zl_3sig10(s)
c     2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      zl_3sig10 = - e2*ct2/st2*(10*a(wm) + (11*s + 10*wm2)*b0(s,wm,wm)
     1          + 10*wm2 - 5.d0*s/3)/3.d0/s
     2          - idflag*e2*ct2/st2 * 2.d0*s/3.d0/s
c     the last term (in the second continuation line) vanishes in DRED.
      return
      end

      complex*16 function zl_sig(s)
c     Full bare longitudinal Z0 self-energy
      implicit double precision (a-h,o-z)
      complex*16 zl_3sig1,zl_3sig2,zl_3sig3,zl_3sig4,
     1           zl_3sig7,zl_3sig8,zl_3sig9,zl_3sig10
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      zl_sig = 0
      if (if.eq.1) zl_sig = zl_sig + zl_3sig1(s)
      if (is.eq.1) zl_sig = zl_sig + zl_3sig2(s)
      if (ig.eq.1) zl_sig = zl_sig  + zl_3sig3(s) + zl_3sig4(s)
     1                              + zl_3sig7(s) + zl_3sig10(s)
      if (ic.eq.1) zl_sig = zl_sig + zl_3sig9(s)
      if (in.eq.1) zl_sig = zl_sig + zl_3sig8(s)
      zl_sig = zl_sig/16/pi/pi
      return
      end

      complex*16 function zl_ren(s)
c     Full renormalized longitudinal Z0 self-energy
      implicit double precision (a-h,o-z)
      complex*16 zl_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      zl_ren = zl_sig(s) + st2*dzb + ct2*dza
      return
      end



