c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZDD_VERT.FOR
c     Released: 15: 3:1994(P.Ch.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains Z-down q-down q vertex formfactors           c
c                                                                     c
c     Incoming Z0:          momentum (p+q)(\mu)                       c
c     Outgoing antiquark :  momentum  p                               c
c     Outgoing quark :      momentum  q                               c
c                                                                     c
c                              V3            _                        c
c                               ____________ d (i)                    c
c                             /|      p (outgoing)                    c
c                        L2 /  |                                      c
c                         /    |                                      c
c        Z^0_{\mu}      /      | L1                                   c
c               ~~~~~~~~\V1    |                                      c
c       p+q (incoming)    \    |                                      c
c                        L3 \  |                                      c
c                             \|_____________ d'  (j)                 c
c                              V2     q (outgoing)                    c
c                                                                     c
c       General form of the vertex (G(mu) = gamma(mu),                c
c       G(5)= gamma(5)):                                              c
c                                                                     c
c       V = V_tree                                                    c
c         + i(F_1 G(mu) - F_2 G(mu)G(5) + F_3 p(mu)                   c
c           - F_4 p(mu)G(5) + F_5 q(mu) - F_6 q(mu)G(5))              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c      Other arguments:                                               c
c       form:      complex output array containing formfactor values  c
c                                                                     c
c      Only F_1, F_2 require renormalization.                         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine zdd_vert1(i,j,form)
c     up-up-W in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1
      complex*16 cz,co,ci,ckm
      common/km_mat/ckm(3,3)
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      a1 = cmplx(1 - 8*st2/3.d0,zero)
      do 10 l=1,3
        call vff_vert(um(l),wm,um(l),a1,co,co,co,co,co,tmp)
        do 10 k=1,6
10        form(k) = form(k)
     1            + e*e2*ckm(j,l)*conjg(ckm(i,l))/32/sct/st2*tmp(k)
      return
      end
 
      subroutine zdd_vert2(i,j,form)
c     Down-down-photon in loop
      implicit double precision (a-h,o-z)
      complex*16 form(6),a1,tmp(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/dimreg/idflag
      if (i.ne.j) return
c     This is more tricky: This diagram should be omitted, because it
c     combine together with the bremsstrahlung to yield a QED factor.
c     This factor is however calculated taking this diagram in DIMREG.
c     Therefore the difference between its value in DRED and DIMREG
c     should be included here.
      a1 = cmplx(1 - 4*st2/3.d0,zero)
c     Full diagram:
c      call vff_vert(dm(i),zero,dm(i),a1,co,co,cz,co,cz,tmp)
c      do 10 k=1,6
c10      form(k) = form(k) - e*e2/36.d0/sct*tmp(k)
c     DRED-DIMREG difference:
      if (idflag.eq.1) return
      form(1) = form(1) + e2*e/36/sct*a1
      form(2) = form(2) + e2*e/36/sct*co
      return
      end
 
      subroutine zdd_vert20(i,j,form)
c     Down-down-gluon in loop
      implicit double precision (a-h,o-z)
      complex*16 form(6),a1,tmp(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/dimreg/idflag
      if (i.ne.j) return
c     This is more tricky: This diagram should be omitted, because it
c     combine together with the bremsstrahlung to yield a QCD factor.
c     This factor is however calculated taking this diagram in DIMREG.
c     Therefore the difference between its value in DRED and DIMREG
c     should be included here.
      al = alfas(zm)
      a1 = cmplx(1 - 4*st2/3.d0,zero)
c     Full diagram:
c      call vff_vert(dm(i),zero,dm(i),a1,co,co,cz,co,cz,tmp)
c      do 10 k=1,6
c10      form(k) = form(k) - e*4/3.d0*pi*al/sct*tmp(k)
c     DRED-DIMREG difference:
      if (idflag.eq.1) return
      form(1) = form(1) + e*4/3.d0*pi*al/sct*a1
      form(2) = form(2) + e*4/3.d0*pi*al/sct*co
      return
      end
 
      subroutine zdd_vert3(i,j,form)
c     Down-down-Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      a1 = cmplx(1 - 4*st2/3.d0,zero)
      call vff_vert(dm(i),zm,dm(i),a1,co,a1,co,a1,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) - e*e2/64/sct/sct2*tmp(k)
      return
      end
 
      subroutine zdd_vert4(i,j,form)
c     W-W-up quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci,ckm
      common/km_mat/ckm(3,3)
      common/fmass/em(3),um(3),dm(3)
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      do 10 l=1,3
        call fww_vert(wm,um(l),wm,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k)
     1          + e*e2*ct/8/st/st2*ckm(j,l)*conjg(ckm(i,l))*tmp(k)
      return
      end
 
      subroutine zdd_vert56(i,j,form)
c     Charged Goldstone-W-up quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6),a1,b1,a2,b2
      complex*16 cz,co,ci,ckm
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      do 10 l = 1,3
        a1 = cmplx(dm(i) - um(l),zero)
        b1 = cmplx(dm(i) + um(l),zero)
        a2 = cmplx(dm(j) - um(l),zero)
        b2 = cmplx(dm(j) + um(l),zero)
        call fsv_vert(wm,um(l),wm,co,co,a1,-b1,tmp1)
        call fvs_vert(wm,um(l),wm,a2,b2,co,co,tmp2)
      do 10 k=1,6
10      form(k) = form(k) - e*e2/8/sct
     1          * ckm(j,l)*conjg(ckm(i,l))*(tmp1(k) + tmp2(k))
      return
      end
 
      subroutine zdd_vert78(i,j,form)
c     Scalar-Z0-down quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2/3.d0,zero)
      do 10 l=1,2
        call fsv_vert(rm(l),dm(i),zm,vv,co,co,cz,tmp1)
        call fvs_vert(zm,dm(i),rm(l),co,cz,vv,co,tmp2)
        do 10 k=1,6
10        form(k) = form(k) - (e/2/sct)**3*dm(i)*cr(l)*zr(1,l)/v1
     1            * (tmp1(k) + tmp2(k))
      return
      end
 
      subroutine zdd_vert9(i,j,form)
c     Charged Higgs-up quark - up quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv,a2,b2,a3,b3
      complex*16 cz,co,ci,ckm
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/km_mat/ckm(3,3)
      common/fmass/em(3),um(3),dm(3)
      vv = cmplx(1 - 8*st2/3.d0,zero)
      do 10 l=1,2
        do 10 n=1,3
          a2 = cmplx(dm(j)*zh(1,l)/v1 + um(n)*zh(2,l)/v2,zero)
          b2 = cmplx(dm(j)*zh(1,l)/v1 - um(n)*zh(2,l)/v2,zero)
          a3 = cmplx(dm(i)*zh(1,l)/v1 + um(n)*zh(2,l)/v2,zero)
          b3 = cmplx(dm(i)*zh(1,l)/v1 - um(n)*zh(2,l)/v2,zero)
          call sff_vert(um(n),cm(l),um(n),vv,co,a2,b2,a3,-b3,tmp)
          do 10 k=1,6
10          form(k) = form(k) + e/8/sct*ckm(j,n)*conjg(ckm(i,n))*tmp(k)
      return
      end
 
      subroutine zdd_vert10(i,j,form)
c     Scalar-down quark - down quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2/3.d0,zero)
      do 10 l=1,2
        call sff_vert(dm(i),rm(l),dm(i),vv,co,co,cz,co,cz,tmp)
        do 10 k=1,6
10        form(k) = form(k) - e/4/sct*(dm(i)*zr(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zdd_vert11(i,j,form)
c     Pseudoscalar-down quark-down quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2/3.d0,zero)
      do 10 l=1,2
        call sff_vert(dm(i),pm(l),dm(i),vv,co,cz,co,cz,co,tmp)
        do 10 k=1,6
10        form(k) = form(k) + e/4/sct*(dm(i)*zh(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zdd_vert12(i,j,form)
c     Down squark-neutralino-neutralino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1,a2,a3,b1,b2,b3
      complex*16 vl_nnz,vr_nnz,vl_ddn,vr_ddn
      complex*16 zu,zd,zn
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/neut/fnm(4),zn(4,4)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,4
        do 10 m=1,4
          do 10 n=1,6
            a1 = vl_nnz(l,m) + vr_nnz(l,m)
            b1 = vl_nnz(l,m) - vr_nnz(l,m)
            a2 = conjg(vr_ddn(j,n,l) + vl_ddn(j,n,l))
            b2 = conjg(vr_ddn(j,n,l) - vl_ddn(j,n,l))
            a3 = vl_ddn(i,n,m) + vr_ddn(i,n,m)
            b3 = vl_ddn(i,n,m) - vr_ddn(i,n,m)
            call sff_vert(fnm(m),sdm(n),fnm(l),a1,b1,a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) - e/8/sct*tmp(k)
      return
      end
 
      subroutine zdd_vert13(i,j,form)
c     Up squark-chargino-chargino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1,a2,a3,b1,b2,b3
      complex*16 vl_ccz,vr_ccz,vl_duc,vr_duc
      complex*16 zu,zd,zpos,zneg
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,2
        do 10 m=1,2
          do 10 n=1,6
            a1 = - vr_ccz(m,l) - vl_ccz(m,l)
            b1 = - vr_ccz(m,l) + vl_ccz(m,l)
            a2 = conjg(vr_duc(j,n,l) + vl_duc(j,n,l))
            b2 = conjg(vr_duc(j,n,l) - vl_duc(j,n,l))
            a3 = vl_duc(i,n,m) + vr_duc(i,n,m)
            b3 = vl_duc(i,n,m) - vr_duc(i,n,m)
            call sff_vert(fcm(m),sum(n),fcm(l),a1,b1,a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) + e/16.d0/sct*tmp(k)
      return
      end
 
      subroutine zdd_vert14(i,j,form)
c     Charged Higgs - charged Higgs- up quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a2,b2,a3,b3
      complex*16 cz,co,ci,ckm
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      do 10 l=1,2
        do 10 n=1,3
          a2 = cmplx(dm(j)*zh(1,l)/v1 + um(n)*zh(2,l)/v2,zero)
          b2 = cmplx(dm(j)*zh(1,l)/v1 - um(n)*zh(2,l)/v2,zero)
          a3 = cmplx(dm(i)*zh(1,l)/v1 + um(n)*zh(2,l)/v2,zero)
          b3 = cmplx(dm(i)*zh(1,l)/v1 - um(n)*zh(2,l)/v2,zero)
          call fss_vert(cm(l),um(n),cm(l),a2,b2,a3,-b3,tmp)
          do 10 k=1,6
10          form(k) = form(k)+ e*(ct2 - st2)/4/sct
     1              * ckm(j,n)*conjg(ckm(i,n))*tmp(k)
      return
      end
 
      subroutine zdd_vert156(i,j,form)
c     Scalar-pseudoscalar-down quark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      do 10 l=1,2
        do 10 m=1,2
          call fss_vert(rm(l),dm(i),pm(m),cz,co,co,cz,tmp1)
          call fss_vert(pm(m),dm(i),rm(l),co,cz,cz,co,tmp2)
          do 10 k=1,6
10          form(k) = form(k) - e/2/sct*(dm(i)/v1)**2
     1              * am(l,m)*zr(1,l)*zh(1,m)*(tmp1(k) - tmp2(k))
      return
      end
 
      subroutine zdd_vert17(i,j,form)
c     Chargino-up squark-up squark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a2,a3,b2,b3
      complex*16 vl_duc,vr_duc,v_uuz
      complex*16 zu,zd,zpos,zneg
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,6
        do 10 n=1,6
          do 10 m=1,2
            a3 = vl_duc(i,n,m) + vr_duc(i,n,m)
            b3 = vl_duc(i,n,m) - vr_duc(i,n,m)
            a2 = conjg(vr_duc(j,l,m) + vl_duc(j,l,m))
            b2 = conjg(vr_duc(j,l,m) - vl_duc(j,l,m))
            call fss_vert(sum(n),fcm(m),sum(l),a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) - e/8/sct*v_uuz(l,n)*tmp(k)
      return
      end
 
      subroutine zdd_vert18(i,j,form)
c     Neutralino-down squark- down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a2,a3,b2,b3
      complex*16 vl_ddn,vr_ddn,v_ddz
      complex*16 zu,zd,zn
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/neut/fnm(4),zn(4,4)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,6
        do 10 m=1,6
          do 10 n=1,4
            a3 = vl_ddn(i,l,n) + vr_ddn(i,l,n)
            b3 = vl_ddn(i,l,n) - vr_ddn(i,l,n)
            a2 = conjg(vr_ddn(j,m,n) + vl_ddn(j,m,n))
            b2 = conjg(vr_ddn(j,m,n) - vl_ddn(j,m,n))
            call fss_vert(sdm(l),fnm(n),sdm(m),a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) + e/8/sct*v_ddz(l,m)*tmp(k)
      return
      end
 
      subroutine zdd_vert19(i,j,form)
c     Gluino-down squark- down squark in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a2,a3,b2,b3
      complex*16 v_ddz
      complex*16 zu,zd
      complex*16 cz,co,ci
      complex*16 gm2,gm3
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/gmass/gm1,gm2,gm3
      common/fmass/em(3),um(3),dm(3)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      al = alfas(zm)
      do 10 l=1,6
        do 10 m=1,6
          a3 = zd(i,l) + zd(i+3,l)
          b3 = zd(i,l) - zd(i+3,l)
          a2 =   conjg(zd(j,m) + zd(j+3,m))
          b2 = - conjg(zd(j,m) - zd(j+3,m))
          call fss_vert(sdm(l),2*gm1,sdm(m),a2,b2,a3,b3,tmp)
          do 10 k=1,6
10          form(k) = form(k) + 4*e/sct/3.d0*pi*al*v_ddz(l,m)*tmp(k)
      return
      end
 
      subroutine zdd_vert(s,i,j,form)
c     Full bare Zdd formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p,q,pq
      common/fmass/em(3),um(3),dm(3)
      common/parcont/if,is,ig,ic,in,iq,il
      if ((if.ne.ig).or.(if.ne.iq).or.(is.ne.ic).or.(is.ne.in)
     1              .or.(is.ne.il))
     2   stop 'if=ig=iq and is=ic=in=il required in zdd_vert!'
      do 10 k=1,6
10      form(k) = (0,0)
      p  = dm(i)*dm(i)
      q  = dm(j)*dm(j)
      pq = (s - p - q)/2
      if (if*ig*iq.eq.1) then
        call zdd_vert1(i,j,form)
        call zdd_vert2(i,j,form)
        call zdd_vert20(i,j,form)
        call zdd_vert3(i,j,form)
        call zdd_vert4(i,j,form)
        call zdd_vert56(i,j,form)
        call zdd_vert78(i,j,form)
        call zdd_vert9(i,j,form)
        call zdd_vert10(i,j,form)
        call zdd_vert11(i,j,form)
        call zdd_vert14(i,j,form)
        call zdd_vert156(i,j,form)
      end if
      if (is*in*ic*il.eq.1) then
        call zdd_vert12(i,j,form)
        call zdd_vert13(i,j,form)
        call zdd_vert17(i,j,form)
        call zdd_vert18(i,j,form)
        call zdd_vert19(i,j,form)
      end if
      do 20 k=1,6
20      form(k) = form(k)/16/pi/pi
      return
      end
 
      subroutine zdd_ren(s,i,j,form)
c     Full renormalized Zdd formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6),tmp(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/grconst/dza,dzb,dz2,dx
      form(1) = cmplx(e/4/sct*(1 - 4*st2/3.d0),0.d0)
      form(2) = cmplx(e/4/sct,0.d0)
      do 10 k=3,6
10      form(k) = (0,0)
      if (.not.fstat) return
      call zdd_vert(s,i,j,tmp)
      do 20 k=1,6
20      form(k) = form(k) + tmp(k)
      form(1) = form(1) + e/4/sct*((1 - 2*st2/3.d0)*dzlq(i)
     1                  - 2*st2/3.d0*dzrd(i) + ct2*(dz2 - dza))
      form(2) = form(2) + e/4/sct*((1 - 2*st2/3.d0)*dzlq(i)
     1                  + 2*st2/3.d0*dzrd(i) + ct2*(dz2 - dza))
      return
      end
 
 
 
 
 
 
 
 
 
 
 
