c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZPS_CR.FOR
c     Last revised: 29:03:1995(J.R.)
c     Evaluation of differential cross section added
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the cross section for                           c
c     the associated scalar-pseudoscalar production                 c
c     sigma (e^-e^+ --> P_j S_i) at CMS energy = sqrt{s}            c
c     (on-shell version). Functions zps_cross(i,j,s) and            c
c     zps_crdif(i,j,s,cteta) give the cross section in [picobarns]  c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function zps_cross(i,j,s)
      implicit double precision (a-h,o-z)
      complex*16 fact,zt,ft,fzt
      complex*16 zt_ren,fzt_ren,ft_ren
      complex*16 vps,wps,dz,df
      complex*16 aa,bb,ze
      complex*16 zps(2),fps(2),cva(6)
      complex*16 zms,zmp
      logical zps_stat,bstat
      common/bswitch/bstat
      common/zps_stat/zps_cr,ss,nh,zps_stat
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/crdat/pbarn,a,v
      external init_zps
      if (zps_stat.and.(s.eq.ss).and.(i.eq.nh)) then
        zps_cross = zps_cr
        if (bstat) zps_cross = zps_cross + zps_box(i,s)
        return
      end if
      zps_stat = .true.
      ss = s
      nh = i
      if ((frm(i).gt.0.d0).and.(sqrt(s).le.frm(i) + pm(j))) then
        zps_cross = 0
        zps_cr = 0
        return
      end if
      p = pm(j)*pm(j)
      q = frm2(i)
      pq = (s - p - q)/2
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      zt  = zt_ren(s)
      ft  = ft_ren(s)
      fzt = fzt_ren(s)
      df = s - ft - fzt**2/(s - zm2 - zt)
      dz = s - zm2 - zt - fzt**2/(s - ft)
      fact = e*zs(i)*zp(j)/2/sct/dz
      ze = 0
      vps = 0
      wps = 0
      do 10 k=1,2
        do 10 l=1,2
          kk = i_sup(i,k)
          ll = i_sup(j,l)
          call zps_ren(p,q,pq,kk,ll,zps)
          call fps_ren(p,q,pq,kk,ll,fps)
          vps = vps + 2*sct/e*(zps(1) + zps(2))*zms(i,k)*zmp(j,l)
          wps = wps + 2*sct/e*(fps(1) + fps(2))*zms(i,k)*zmp(j,l)
10        ze = ze + am(kk,ll)*zms(i,k)*zmp(j,l)

      call zee_ren(s,1,1,cva)

      aa = - cva(1)*(2*ze + vps) + 2*e*ze*fzt/df + e*wps*dz/df
      bb = - cva(2)*(2*ze + vps)
      am0 = alam**2*abs(fact)**2/8*(abs(aa)**2 + abs(bb)**2)
      zps_cross = pbarn*alam*am0/24/pi/s/s
      zps_cr = zps_cross
      if (bstat) zps_cross = zps_cross + zps_box(i,s)
      return
      end
 
      double precision function zps_crdif(i,j,s,cteta)
      implicit double precision (a-h,o-z)
      logical zps_stat,bstat
      common/bswitch/bstat
      common/zps_stat/zps_cr,ss,nh,zps_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if ((.not.zps_stat).or.(s.ne.ss).or.(i.ne.nh)) 
     $     zps_crdif = zps_cross(i,j,s)
      zps_crdif = 3*zps_cr/pi/8.d0*(1 - cteta*cteta)
      if (bstat) zps_crdif = zps_crdif + zps_box_d(i,s,cteta)
      return
      end
 
      block data init_zps
      implicit double precision (a-h,o-z)
      logical zps_stat
      common/zps_stat/zps_cr,ss,nh,zps_stat
      data zps_stat,nh,zps_cr,ss/.false.,0,2*0.d0/
      end
 
 
  
 
 


