c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZPS_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains Z0-scalar-pseudoscalar vertex formfactors    c
c     and their renormalization.                                      c
c                                                                     c
c     Incoming    Z0:              momentum (p+q)(\mu)                c
c     Outgoing pseudoscalar P(j):  momentum  p     (P_j = H^0_{j+2}   c
c     Outgoing scalar S(i)      :  momentum  q     (S_i = H^0_i)      c
c                                                                     c
c                                                                     c
c                               _______ P_j                           c
c                             /|                                      c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       Z^0_{\mu}       /      |                                      c
c               ~~~~~~~~\      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  S_i                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437 available as       c
c       hep-ph-9303309:                                               c
c                                                                     c
c       V = V_tree +  p(mu) F_p + q(mu) F_q                           c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
 
      subroutine zps_3vert1(p,q,pq,i,j,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        form(1) = form(1) - 2*e/sct*em(k)*em(k)/v1/v1
     1          *zh(1,j)*zr(1,i)*(b0(q,em(k),em(k)) - 2*em(k)*em(k) 
     2          *c0(em(k),em(k),em(k)) + p*(c11(em(k),em(k),em(k))
     3          + 2*c21(em(k),em(k),em(k))) + 2*c24(em(k),em(k),em(k))
     4          - q*c12(em(k),em(k),em(k)) +2*pq*c23(em(k),em(k),em(k)))
        form(2) = form(2) - 2*e/sct*em(k)*em(k)/v1/v1
     1          *zh(1,j)*zr(1,i)*(p*(c11(em(k),em(k),em(k))
     2          + 2*c23(em(k),em(k),em(k)) + c12(em(k),em(k),em(k)))
     3          + 2*pq*(c12(em(k),em(k),em(k)) + c22(em(k),em(k),em(k)))
     4          - b0(q,em(k),em(k)) - b1(q,em(k),em(k)))
        call creset
        form(1) = form(1) + 6*e/sct*um(k)*um(k)/v2/v2
     1          *zh(2,j)*zr(2,i)*(b0(q,um(k),um(k)) - 2*um(k)*um(k) 
     2          *c0(um(k),um(k),um(k)) + p*(c11(um(k),um(k),um(k))
     3          + 2*c21(um(k),um(k),um(k))) - q*c12(um(k),um(k),um(k))
     4          + 2*pq*c23(um(k),um(k),um(k))
     5          + 2*c24(um(k),um(k),um(k)))
        form(2) = form(2) + 6*e/sct*um(k)*um(k)/v2/v2
     1          *zh(2,j)*zr(2,i)*(p*(c11(um(k),um(k),um(k))
     2          + 2*c23(um(k),um(k),um(k)) + c12(um(k),um(k),um(k)))
     3          + 2*pq*(c12(um(k),um(k),um(k)) + c22(um(k),um(k),um(k)))
     4          - b0(q,um(k),um(k)) - b1(q,um(k),um(k)))
        call creset
        form(1) = form(1) - 6*e/sct*dm(k)*dm(k)/v1/v1
     1          *zh(1,j)*zr(1,i)*(b0(q,dm(k),dm(k)) - 2*dm(k)*dm(k) 
     2          *c0(dm(k),dm(k),dm(k)) + p*(c11(dm(k),dm(k),dm(k))
     3          + 2*c21(dm(k),dm(k),dm(k))) - q*c12(dm(k),dm(k),dm(k))
     4          + 2*pq*c23(dm(k),dm(k),dm(k))
     5          + 2*c24(dm(k),dm(k),dm(k)))        
        form(2) = form(2) - 6*e/sct*dm(k)*dm(k)/v1/v1
     1          *zh(1,j)*zr(1,i)*(p*(c11(dm(k),dm(k),dm(k))
     2          + 2*c23(dm(k),dm(k),dm(k)) + c12(dm(k),dm(k),dm(k)))
     3          + 2*pq*(c12(dm(k),dm(k),dm(k)) + c22(dm(k),dm(k),dm(k)))
     4          - b0(q,dm(k),dm(k)) - b1(q,dm(k),dm(k)))
10      call creset
      return
      end
 
      subroutine zps_3vert2(p,q,pq,i,j,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_lls,v_uus,v_dds
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        do 20 l=1,6
          do 20 m=1,6
            tmp = e/sct*dble(v_llz(l,k)*v_llp(k,m,j)*v_lls(m,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) + tmp*(c0(slm(k),slm(l),slm(m))
     1                + 2*c11(slm(k),slm(l),slm(m)))
              form(2) = form(2) + tmp*(c0(slm(k),slm(l),slm(m))
     1                + 2*c12(slm(k),slm(l),slm(m)))
              call creset
            end if
            tmp = 3*e/sct*dble(v_uuz(l,k)*v_uup(k,m,j)*v_uus(m,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) + tmp*(c0(sum(k),sum(l),sum(m))
     1                + 2*c11(sum(k),sum(l),sum(m)))
              form(2) = form(2) + tmp*(c0(sum(k),sum(l),sum(m))
     1                + 2*c12(sum(k),sum(l),sum(m)))
              call creset
            end if
            tmp = 3*e/sct*dble(v_ddz(l,k)*v_ddp(k,m,j)*v_dds(m,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) + tmp*(c0(sdm(k),sdm(l),sdm(m))
     1                + 2*c11(sdm(k),sdm(l),sdm(m)))
              form(2) = form(2) + tmp*(c0(sdm(k),sdm(l),sdm(m))
     1                + 2*c12(sdm(k),sdm(l),sdm(m)))
              call creset
            end if
20    continue
      return
      end
 
      subroutine zps_3vert3(p,q,pq,i,j,form)
c     3 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/eps/eps(2,2)
      if (j.eq.1) then
        do 10 k=1,2
          do 10 l=1,2
            form(1) = form(1) + (e/st)**3/4/ct*wm*(ct2 - st2)
     1              *eps(k,l)*v_hhs(i,k,l)*(c0(cm(k),cm(l),cm(k))
     2              + 2*c11(cm(k),cm(l),cm(k)))
            form(2) = form(2) + (e/st)**3/4/ct*wm*(ct2 - st2)
     1              *eps(k,l)*v_hhs(i,k,l)*(c0(cm(k),cm(l),cm(k))
     2              + 2*c12(cm(k),cm(l),cm(k)))
10          call creset
      end if
      return
      end
 
      subroutine zps_3vert4(p,q,pq,i,j,form)
c     2 scalars + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
            form(1) = form(1) + (e/2/sct)**5*am(l,k)*ah(j,k)
     1              *br(m)*v_sss(i,l,m)*(c0(pm(k),rm(m),rm(l))
     2              + 2*c11(pm(k),rm(m),rm(l)))
            form(2) = form(2) + (e/2/sct)**5*am(l,k)*ah(j,k)
     1              *br(m)*v_sss(i,l,m)*(c0(pm(k),rm(m),rm(l))
     2              + 2*c12(pm(k),rm(m),rm(l)))
10          call creset
      return
      end
 
      subroutine zps_3vert5(p,q,pq,i,j,form)
c     Scalar + 2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
            form(1) = form(1) - (e/2/sct)**5*am(k,l)*ah(j,m)*ah(l,m)
     1              *br(k)*br(i)*(c0(rm(k),pm(m),pm(l))
     2              + 2*c11(rm(k),pm(m),pm(l)))
            form(2) = form(2) - (e/2/sct)**5*am(k,l)*ah(j,m)
     1              *ah(l,m)*br(k)*br(i)*(c0(rm(k),pm(m),pm(l))
     2              + 2*c12(rm(k),pm(m),pm(l)))
10          call creset
      return
      end
 
      subroutine zps_3vert6(p,q,pq,i,j,form)
c     Charged Higgs + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e*e2*ct/2/st**3*am(i,j)*(6*c24(wm,cm(j),wm)
     1        + q*(2*c0(wm,cm(j),wm) + c11(wm,cm(j),wm)
     2        - c12(wm,cm(j),wm) + 2*c22(wm,cm(j),wm)
     3        + 2*c23(wm,cm(j),wm)) + pq*(6*c0(wm,cm(j),wm)
     4        + 7*c11(wm,cm(j),wm) + c12(wm,cm(j),wm)        
     5        + 2*c21(wm,cm(j),wm) + 2*c23(wm,cm(j),wm)) + 1)
      form(2) = form(2) - e*e2*ct/2/st**3*am(i,j)*(6*c24(wm,cm(j),wm)
     1        + p*(6*c0(wm,cm(j),wm) + 7*c11(wm,cm(j),wm)
     2        + c12(wm,cm(j),wm) + 2*c21(wm,cm(j),wm)
     3        + 2*c23(wm,cm(j),wm)) + pq*(2*c0(wm,cm(j),wm)
     4        + c11(wm,cm(j),wm) - c12(wm,cm(j),wm)
     5        + 2*c22(wm,cm(j),wm) + 2*c23(wm,cm(j),wm)) + 1)
      call creset
      return
      end
 
      subroutine zps_3vert7(p,q,pq,i,j,form)
c     Charged Goldstone + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (j.eq.1) return      
      form(1) = form(1) + e2*e2*zm/4/st2*cr(i)*(c0(wm,wm,wm) 
     1        - c11(wm,wm,wm))
      form(2) = form(2) - e2*e2*zm/4/st2*cr(i)*c12(wm,wm,wm)
      call creset
      return
      end
 
      subroutine zps_3vert8(p,q,pq,i,j,form)
c     2 charged Higgs + W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e**3/2*zm*v_hhs(i,2,j)*(c11(wm,cm(j),wm)
     1        + 2*c0(wm,cm(j),wm))
      form(2) = form(2) + e**3/2*zm*v_hhs(i,2,j)*c12(wm,cm(j),wm)
      call creset
      return
      end
 
      subroutine zps_3vert9(p,q,pq,i,j,form)
c     Charged Higgs + charged Goldstone + W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      if (j.eq.2) return
      form(1) = form(1) + e**3/4/sct*wm2*am(i,1)*(c11(wm,cm(1),wm)
     1        + c0(wm,cm(1),wm))
      form(2) = form(2) + e**3/4/sct*wm2*am(i,1)*(c12(wm,cm(1),wm)
     1        - c0(wm,cm(1),wm))
      call creset
      return
      end
 
      subroutine zps_3vert10(p,q,pq,i,j,form)
c     Z0 + 2 scalars in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) - (e/sct)**5/16*cr(k)*am(l,j)*v_sss(k,l,i)
     1            *(c11(zm,rm(l),rm(k)) + 2*c0(zm,rm(l),rm(k)))
          form(2) = form(2) - (e/sct)**5/16*cr(k)*am(l,j)*v_sss(k,l,i)
     2            *c12(zm,rm(l),rm(k))
10        call creset
      return
      end
 
      subroutine zps_3vert11(p,q,pq,i,j,form)
c     Z0 + scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) - (e/sct)**5/16*cr(k)*br(k)*ah(l,j)*am(i,l)
     1            *(c11(rm(k),pm(l),zm) + c0(rm(k),pm(l),zm))
          form(2) = form(2) - (e/sct)**5/16*cr(k)*br(k)*ah(l,j)*am(i,l)
     1            *(c12(rm(k),pm(l),zm) - c0(rm(k),pm(l),zm))
10        call creset
      return
      end
 
      subroutine zps_3vert12(p,q,pq,i,j,form)
c     2 Z0 + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        form(1) = form(1) + (e/sct)**5/8*cr(k)*cr(i)*am(k,j)
     1          *(c11(rm(k),zm,zm) - c0(rm(k),zm,zm))
        form(2) = form(2) + (e/sct)**5/8*cr(k)*cr(i)*am(k,j)
     1          *c12(rm(k),zm,zm)
10      call creset
      return
      end
 
      subroutine zps_3vert13(p,q,pq,i,j,form)
c     3 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 form(2)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (j.eq.1) return
      form(1) = form(1) + (e/st)**4*wm*ct/8*cr(i)*c0(wm,wm,wm)
      form(2) = form(2) + (e/st)**4*wm*ct/8*cr(i)*c0(wm,wm,wm)
      call creset
      return
      end
 
      subroutine zps_3vert14(p,q,pq,i,j,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz,v_ccp,v_ccs
      complex*16 a,b,c,x,y,z
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
            a  = vr_ccz(m,k) + vl_ccz(m,k)
            x  = vr_ccz(m,k) - vl_ccz(m,k)
            b  = conjg(v_ccs(k,l,i)) + v_ccs(l,k,i)
            y  = conjg(v_ccs(k,l,i)) - v_ccs(l,k,i)
            c =  conjg(v_ccp(l,m,j)) - v_ccp(m,l,j)
            z =  conjg(v_ccp(l,m,j)) + v_ccp(m,l,j)
            form(1) = form(1) + e*e2/4/st2/sct
     1         *(dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2         *((p + fcm(m)*fcm(m))*c11(fcm(m),fcm(l),fcm(k))
     3         + 2*p*c21(fcm(m),fcm(l),fcm(k))
     4         - q*c12(fcm(m),fcm(l),fcm(k))
     5         + 2*pq*c23(fcm(m),fcm(l),fcm(k)) + b0(q,fcm(l),fcm(k))
     6         + 2*c24(fcm(m),fcm(l),fcm(k)))
     7         + fcm(k)*fcm(l)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8         *c11(fcm(m),fcm(l),fcm(k))
     9         + fcm(k)*fcm(m)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     a         *(c0(fcm(m),fcm(l),fcm(k)) + c11(fcm(m),fcm(l),fcm(k)))
     b         + fcm(m)*fcm(l)*dble(a*b*c - x*y*c - x*b*z + a*y*z)
     c         *(c0(fcm(m),fcm(l),fcm(k)) + c11(fcm(m),fcm(l),fcm(k))))
            form(2) = form(2) + e*e2/4/st2/sct
     1         *(dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2         *(p*c11(fcm(m),fcm(l),fcm(k)) + 0.5d0
     3         + p*c21(fcm(m),fcm(l),fcm(k)) - b1(q,fcm(l),fcm(k))
     4         + (p + 2*pq + fcm(m)*fcm(m))*c12(fcm(m),fcm(l),fcm(k))
     5         + 2*(p + pq)*c23(fcm(m),fcm(l),fcm(k))
     6         + (q + 2*pq)*c22(fcm(m),fcm(l),fcm(k))
     7         + 4*c24(fcm(m),fcm(l),fcm(k)))
     8         + fcm(k)*fcm(l)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     9         *c12(fcm(m),fcm(l),fcm(k))
     a         + fcm(k)*fcm(m)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     b         *c12(fcm(m),fcm(l),fcm(k))
     c         + fcm(m)*fcm(l)*dble(a*b*c - x*y*c - x*b*z + a*y*z)
     d         *(c0(fcm(m),fcm(l),fcm(k)) + c12(fcm(m),fcm(l),fcm(k))))
10          call creset
      return
      end
 
      subroutine zps_3vert15(p,q,pq,i,j,form)
c     3 neutralinos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      complex*16 zn
      complex*16 vl_nnz,vr_nnz,v_nnp,v_nns
      complex*16 a,b,c,x,y,z
      common/neut/fnm(4),zn(4,4)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,4
        do 10 l=1,4
          do 10 m=1,4
            a  = vr_nnz(m,k) + vl_nnz(m,k)
            x  = vr_nnz(m,k) - vl_nnz(m,k)
            b  = conjg(v_nns(k,l,i)) + v_nns(l,k,i)
            y  = conjg(v_nns(k,l,i)) - v_nns(l,k,i)
            c =  conjg(v_nnp(l,m,j)) - v_nnp(m,l,j)
            z =  conjg(v_nnp(l,m,j)) + v_nnp(m,l,j)
            form(1) = form(1) - (e/sct/2)**3
     1         *(dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2         *((p + fnm(m)*fnm(m))*c11(fnm(m),fnm(l),fnm(k))
     3         + 2*p*c21(fnm(m),fnm(l),fnm(k))
     4         - q*c12(fnm(m),fnm(l),fnm(k))
     5         + 2*pq*c23(fnm(m),fnm(l),fnm(k)) + b0(q,fnm(l),fnm(k))
     6         + 2*c24(fnm(m),fnm(l),fnm(k)))
     7         + fnm(k)*fnm(l)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8         *c11(fnm(m),fnm(l),fnm(k))
     9         + fnm(k)*fnm(m)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     a         *(c0(fnm(m),fnm(l),fnm(k)) + c11(fnm(m),fnm(l),fnm(k)))
     b         + fnm(m)*fnm(l)*dble(a*b*c - x*y*c - x*b*z + a*y*z)
     c         *(c0(fnm(m),fnm(l),fnm(k)) + c11(fnm(m),fnm(l),fnm(k))))
            form(2) = form(2) - (e/sct/2)**3
     1         *(dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2         *(p*c11(fnm(m),fnm(l),fnm(k)) + 0.5d0
     3         + p*c21(fnm(m),fnm(l),fnm(k)) - b1(q,fnm(l),fnm(k))
     4         + (p + 2*pq + fnm(m)*fnm(m))*c12(fnm(m),fnm(l),fnm(k))
     5         + 2*(p + pq)*c23(fnm(m),fnm(l),fnm(k))
     6         + (q + 2*pq)*c22(fnm(m),fnm(l),fnm(k))
     7         + 4*c24(fnm(m),fnm(l),fnm(k)))
     8         + fnm(k)*fnm(l)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     9         *c12(fnm(m),fnm(l),fnm(k))
     a         + fnm(k)*fnm(m)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     b         *c12(fnm(m),fnm(l),fnm(k))
     c         + fnm(m)*fnm(l)*dble(a*b*c - x*y*c - x*b*z + a*y*z)
     d         *(c0(fnm(m),fnm(l),fnm(k)) + c12(fnm(m),fnm(l),fnm(k))))
10          call creset
      return
      end
 
      subroutine zps_3vert16(p,q,pq,i,j,form)
c     2 charged Higgs + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e*e2*(ct2 - st2)/4/st2/sct*am(i,j)*(0.5d0
     1        + 2*b0(q,wm,cm(j)) + 4*c24(cm(j),wm,cm(j))
     2        + 2*cm(j)*cm(j)*c11(cm(j),wm,cm(j))
     3        + p*(c21(cm(j),wm,cm(j)) - c0(cm(j),wm,cm(j))
     4        - 2*c11(cm(j),wm,cm(j))) + q*(2*c12(cm(j),wm,cm(j))
     5        + c22(cm(j),wm,cm(j)) + 4*c23(cm(j),wm,cm(j)))
     6        + 2*pq*(2*c21(cm(j),wm,cm(j)) + c23(cm(j),wm,cm(j))
     7        - c0(cm(j),wm,cm(j)) - c11(cm(j),wm,cm(j))))
      form(2) = form(2) + e*e2*(ct2 - st2)/4/st2/sct*am(i,j)*(0.5d0
     1        - 2*b1(q,wm,cm(j)) + 8*c24(cm(j),wm,cm(j))
     2        + 2*cm(j)*cm(j)*c12(cm(j),wm,cm(j))
     3        + p*(c21(cm(j),wm,cm(j)) - c0(cm(j),wm,cm(j))
     4        - 2*c12(cm(j),wm,cm(j))) + q*(2*c12(cm(j),wm,cm(j))
     5        + 5*c22(cm(j),wm,cm(j))) - 2*pq*(c0(cm(j),wm,cm(j))
     6        - c11(cm(j),wm,cm(j)) + 2*c12(cm(j),wm,cm(j))
     7        - 3*c23(cm(j),wm,cm(j))))
      call creset
      return
      end
 
      subroutine zps_3vert17(p,q,pq,i,j,form)
c     Z0 + skalar + pseudoskalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) - (e/2/sct)**3*am(i,l)*am(k,j)*am(k,l)
     1            *(2*b0(q,zm,pm(l)) + 4*c24(rm(k),zm,pm(l))
     2            + 2*rm(k)*rm(k)*c11(rm(k),zm,pm(l)) + 0.5d0
     3            + p*(c21(rm(k),zm,pm(l)) - c0(rm(k),zm,pm(l))
     4            - 2*c11(rm(k),zm,pm(l))) + q*(2*c12(rm(k),zm,pm(l))
     5            + c22(rm(k),zm,pm(l)) + 4*c23(rm(k),zm,pm(l)))
     6            - 2*pq*(c0(rm(k),zm,pm(l)) + c11(rm(k),zm,pm(l))
     7            - 2*c21(rm(k),zm,pm(l)) - c23(rm(k),zm,pm(l))))
          form(2) = form(2) - (e/2/sct)**3*am(i,l)*am(k,j)*am(k,l)
     1            *( - 2*b1(q,zm,pm(l)) + 8*c24(rm(k),zm,pm(l))
     2            + 2*rm(k)*rm(k)*c12(rm(k),zm,pm(l)) + 0.5d0
     3            + p*(c21(rm(k),zm,pm(l)) - c0(rm(k),zm,pm(l))
     4            - 2*c12(rm(k),zm,pm(l))) + q*(2*c12(rm(k),zm,pm(l))
     5            + 5*c22(rm(k),zm,pm(l))) - 2*pq*(c0(rm(k),zm,pm(l))
     6            - c11(rm(k),zm,pm(l)) + 2*c12(rm(k),zm,pm(l))
     7            - 3*c23(rm(k),zm,pm(l))))
10        call creset
      return
      end
 
      subroutine zps_4vert1(p,q,pq,i,j,form)
c     Z0 + skalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + (e/sct)**3/4*am(i,j)*(2*b0(p,zm,rm(i))
     1        + b1(p,zm,rm(i)))
      return
      end

      subroutine zps_4vert2(p,q,pq,i,j,form)
c     Z0 + pseudoskalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(2) = form(2) - (e/sct)**3/4*am(i,j)*(2*b0(q,zm,pm(j))
     1        + b1(q,zm,pm(j)))
      return
      end
 
      subroutine zps_4vert3(p,q,pq,i,j,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + e*e2/sct/2*am(i,j)*(2*b0(p,wm,cm(j))
     1        + b1(p,wm,cm(j)))
      return
      end

      subroutine zps_4vert4(p,q,pq,i,j,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(2) = form(2) - e*e2/sct/2*am(i,j)*(2*b0(q,wm,cm(j))
     1        + b1(q,wm,cm(j)))
      return
      end 

      subroutine zps_4vert6(p,q,pq,i,j,form)
c     Scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,b1
      complex*16 form(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + q + 2*pq
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) - (e/sct/2)**3*am(l,k)*ar(i,l)*ah(k,j)
     1            *(b0(s,pm(k),rm(l)) + 2*b1(s,pm(k),rm(l)))
10        form(2) = form(2) - (e/sct/2)**3*am(l,k)*ar(i,l)*ah(k,j)
     1            *(b0(s,pm(k),rm(l)) + 2*b1(s,pm(k),rm(l)))
      return
      end
 
      subroutine zps_vert(p,q,pq,i,j,form)
c     Full bare ZPS formfactor
      implicit double precision (a-h,o-z)
      complex*16 form(2)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      common/cargs/p1,q1,pq1
      do 10 k=1,2
 10     form(k) = (0,0)
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call zps_3vert1(p,q,pq,i,j,form)
      if (is.eq.1) call zps_3vert2(p,q,pq,i,j,form)
      if (ig.eq.1) then
        call zps_3vert3(p,q,pq,i,j,form)
        call zps_3vert4(p,q,pq,i,j,form)
        call zps_3vert5(p,q,pq,i,j,form)
        call zps_3vert6(p,q,pq,i,j,form)
        call zps_3vert7(p,q,pq,i,j,form)
        call zps_3vert8(p,q,pq,i,j,form)
        call zps_3vert9(p,q,pq,i,j,form)
        call zps_3vert10(p,q,pq,i,j,form)
        call zps_3vert11(p,q,pq,i,j,form)
        call zps_3vert12(p,q,pq,i,j,form)
        call zps_3vert13(p,q,pq,i,j,form)
        call zps_3vert16(p,q,pq,i,j,form)
        call zps_3vert17(p,q,pq,i,j,form)
        call zps_4vert1(p,q,pq,i,j,form)
        call zps_4vert2(p,q,pq,i,j,form)
        call zps_4vert3(p,q,pq,i,j,form)
        call zps_4vert4(p,q,pq,i,j,form)
        call zps_4vert6(p,q,pq,i,j,form)
      end if
      if (ic.eq.1) call zps_3vert14(p,q,pq,i,j,form)
      if (in.eq.1) call zps_3vert15(p,q,pq,i,j,form)
      do 20 k=1,2
 20     form(k) = form(k)/16/pi/pi
      return
      end
 
      subroutine zps_ren(p,q,pq,i,j,form)
c     Full renormalized ZPS formfactor
      implicit double precision (a-h,o-z)
      complex*16 form(2)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
 10     form(k) = (0,0)
      if (.not.vstat) return
      call zps_vert(p,q,pq,i,j,form)
      form(1) = e/2/sct*(dzh1*zr(1,i)*zh(1,j) - dzh2*zr(2,i)*zh(2,j))
     1        + e*ct/2/st*(dz2 - dza)*am(i,j) - form(1)
      form(2) = e/2/sct*(dzh1*zr(1,i)*zh(1,j) - dzh2*zr(2,i)*zh(2,j))
     1        + e*ct/2/st*(dz2 - dza)*am(i,j) + form(2)
      return
      end
 






