c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZZP_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains pseudoscalar - Z0- Z0 vertex formfactors     c
c                                                                     c
c     Incoming pseudoscalar P(i):  momentum (p+q)                     c
c     Outgoing Z0               :  momentum  p^{\mu}                  c
c     Outgoing Z0               :  momentum  q^{\nu}                  c
c                                                                     c
c                                                                     c
c                                       Z0^\mu                        c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       P_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  Z0^\nu                       c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 497).                  c
c                                                                     c
c       V = i (F_1 g(mu,nu) + F_2 p(mu)p(nu) + F_3 q(mu)q(nu)         c
c            + F_4 p(mu)q(nu) + F_5 q(mu)p(nu))                       c
c            + F_6 eps(mu,nu,p,q)                                     c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine zzp_vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        v = 1 - 4*st2
        form(6) = form(6) + e2/2/sct2*em(k)*em(k)*zh(1,i)/v1
     1          * ((1 + v*v)*c0(em(k),em(k),em(k))
     2          + 2*c11(em(k),em(k),em(k))
     3          - 2*c12(em(k),em(k),em(k)))
        call creset
        v = 1 - 8.d0/3*st2
        form(6) = form(6) + 1.5d0*e2/sct2*um(k)*um(k)*zh(2,i)/v2
     1          * ((1 + v*v)*c0(um(k),um(k),um(k))
     2          + 2*c11(um(k),um(k),um(k))
     3          - 2*c12(um(k),um(k),um(k)))
        call creset
        v = 1 - 4.d0/3*st2
        form(6) = form(6) + 1.5d0*e2/sct2*dm(k)*dm(k)*zh(1,i)/v1
     1          * ((1 + v*v)*c0(dm(k),dm(k),dm(k))
     2          + 2*c11(dm(k),dm(k),dm(k))
     3          - 2*c12(dm(k),dm(k),dm(k)))
10      call creset
      return
      end
 
      subroutine zzp_vert2(p,q,pq,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz,v_ccp
      complex*16 a,b,c,r,s,t
      complex*16 tmp1,tmp2,tmp3
      complex*16 form(6)
      double precision mk,ml,mm
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
            mk  =  fcm(k)
            ml  =  fcm(l)
            mm  =  fcm(m)
            a = (v_ccp(k,l,i) - conjg(v_ccp(l,k,i)))/2
            r = (v_ccp(k,l,i) + conjg(v_ccp(l,k,i)))/2
            b = (vl_ccz(k,m) + vr_ccz(k,m))/2
            s = (vl_ccz(k,m) - vr_ccz(k,m))/2
            c = (vl_ccz(m,l) + vr_ccz(m,l))/2
            t = (vl_ccz(m,l) - vr_ccz(m,l))/2
            tmp1 = - mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(0.5d0 + p*(c0(mk,mm,ml) + 2*c11(mk,mm,ml)
     2           + c21(mk,mm,ml)) + q*(c12(mk,mm,ml) + c22(mk,mm,ml))
     3           + pq*(c0(mk,mm,ml) + c11(mk,mm,ml) + 2*c12(mk,mm,ml)
     4           + 2*c23(mk,mm,ml)) + 2*c24(mk,mm,ml))
            tmp2 = - ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(0.5d0 + p*(c11(mk,mm,ml) + c21(mk,mm,ml))
     2           + q*c22(mk,mm,ml) + pq*(c12(mk,mm,ml)
     3           + 2*c23(mk,mm,ml)) + 2*c24(mk,mm,ml))
            tmp3 = mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(0.5d0 + p*(c11(mk,mm,ml) + c21(mk,mm,ml))
     2           + q*(c12(mk,mm,ml) + c22(mk,mm,ml))
     3           + pq*(c11(mk,mm,ml) + c12(mk,mm,ml)
     4           + 2*c23(mk,mm,ml)) + 4*c24(mk,mm,ml))
            form(1) = form(1) - e*e2*sq2/st/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = 2*mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + 2*c11(mk,mm,ml) + c21(mk,mm,ml))
            tmp2 = 2*ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c11(mk,mm,ml) + c21(mk,mm,ml))
            form(2) = form(2) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
            tmp1 = 2*mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + c22(mk,mm,ml))
            tmp2 = 2*ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *c22(mk,mm,ml)
            form(3) = form(3) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
            tmp1 = mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + c11(mk,mm,ml)
     2           + 2*c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp2 = ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp3 = mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(c11(mk,mm,ml) - c12(mk,mm,ml))
            form(4) = form(4) - e*e2*sq2/st/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + c11(mk,mm,ml)
     2           + 2*c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp2 = ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp3 = - mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(c11(mk,mm,ml) - c12(mk,mm,ml))
            form(5) = form(5) - e*e2*sq2/st/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = - mk*dble(r*b*c - a*s*c - a*b*t + r*s*t)
     1           * (c0(mk,mm,ml) + c11(mk,mm,ml))
            tmp2 = ml*dble(r*b*c + a*s*c + a*b*t + r*s*t)*c12(mk,mm,ml)
            tmp3 = mm*dble(r*b*c + a*s*c - a*b*t - r*s*t)
     1           * (c11(mk,mm,ml) - c12(mk,mm,ml))
            form(6) = form(6) + e*e2*sq2/st/sct2*(tmp1 + tmp2 + tmp3)
10          call creset
      return
      end
 
      subroutine zzp_vert3(p,q,pq,i,form)
c     3 neutralinos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 zn
      complex*16 vl_nnz,vr_nnz,v_nnp
      complex*16 a,b,c,r,s,t
      complex*16 tmp1,tmp2,tmp3
      complex*16 form(6)
      double precision mk,ml,mm
      common/neut/fnm(4),zn(4,4)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,4
        do 10 l=1,4
          do 10 m=1,4
            mk  =  fnm(k)
            ml  =  fnm(l)
            mm  =  fnm(m)
            a = (v_nnp(k,l,i) - conjg(v_nnp(l,k,i)))/2
            r = (v_nnp(k,l,i) + conjg(v_nnp(l,k,i)))/2
            b = (vl_nnz(k,m) + vr_nnz(k,m))/2
            s = (vl_nnz(k,m) - vr_nnz(k,m))/2
            c = (vl_nnz(m,l) + vr_nnz(m,l))/2
            t = (vl_nnz(m,l) - vr_nnz(m,l))/2
            tmp1 = - mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(0.5d0 + p*(c0(mk,mm,ml) + 2*c11(mk,mm,ml)
     2           + c21(mk,mm,ml)) + q*(c12(mk,mm,ml) + c22(mk,mm,ml))
     3           + pq*(c0(mk,mm,ml) + c11(mk,mm,ml) + 2*c12(mk,mm,ml)
     4           + 2*c23(mk,mm,ml)) + 2*c24(mk,mm,ml))
            tmp2 = - ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(0.5d0 + p*(c11(mk,mm,ml) + c21(mk,mm,ml))
     2           + q*c22(mk,mm,ml) + pq*(c12(mk,mm,ml)
     3           + 2*c23(mk,mm,ml)) + 2*c24(mk,mm,ml))
            tmp3 = mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(0.5d0 + p*(c11(mk,mm,ml) + c21(mk,mm,ml))
     2           + q*(c12(mk,mm,ml) + c22(mk,mm,ml))
     3           + pq*(c11(mk,mm,ml) + c12(mk,mm,ml)
     4           + 2*c23(mk,mm,ml)) + 4*c24(mk,mm,ml))
            form(1) = form(1) - e*e2/sct/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = 2*mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + 2*c11(mk,mm,ml) + c21(mk,mm,ml))
            tmp2 = 2*ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c11(mk,mm,ml) + c21(mk,mm,ml))
            form(2) = form(2) - e*e2/sct/sct2*(tmp1 + tmp2)
            tmp1 = 2*mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + c22(mk,mm,ml))
            tmp2 = 2*ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *c22(mk,mm,ml)
            form(3) = form(3) - e*e2/sct/sct2*(tmp1 + tmp2)
            tmp1 = mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + c11(mk,mm,ml)
     2           + 2*c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp2 = ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp3 = mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(c11(mk,mm,ml) - c12(mk,mm,ml))
            form(4) = form(4) - e*e2/sct/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = mk*dimag(r*b*c - a*s*c - a*b*t + r*s*t)
     1           *(c0(mk,mm,ml) + c11(mk,mm,ml)
     2           + 2*c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp2 = ml*dimag(r*b*c + a*s*c + a*b*t + r*s*t)
     1           *(c12(mk,mm,ml) + 2*c23(mk,mm,ml))
            tmp3 = - mm*dimag(r*b*c + a*s*c - a*b*t - r*s*t)
     1           *(c11(mk,mm,ml) - c12(mk,mm,ml))
            form(5) = form(5) - e*e2/sct/sct2*(tmp1 + tmp2 + tmp3)
            tmp1 = - mk*dble(r*b*c - a*s*c - a*b*t + r*s*t)
     1           * (c0(mk,mm,ml) + c11(mk,mm,ml))
            tmp2 = ml*dble(r*b*c + a*s*c + a*b*t + r*s*t)*c12(mk,mm,ml)
            tmp3 = mm*dble(r*b*c + a*s*c - a*b*t - r*s*t)
     1           * (c11(mk,mm,ml) - c12(mk,mm,ml))
            form(6) = form(6) - 2*e*e2/sct/sct2*(tmp1 + tmp2 + tmp3)
10          call creset
      return
      end
 
      subroutine zzp_vert4(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 20 k=1,6
        do 20 l=1,6
          do 20 m=1,6
            tmp = 2*e2/sct2*dimag(v_llz(l,m)*v_llz(m,k)*v_llp(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(slm(k),slm(m),slm(l))
              form(2) = form(2) - tmp/2*(c0(slm(k),slm(m),slm(l))
     1                + 3*c11(slm(k),slm(m),slm(l))
     2                + 2*c21(slm(k),slm(m),slm(l)))
              form(3) = form(3) - tmp/2*(c12(slm(k),slm(m),slm(l))
     1                + c22(slm(k),slm(m),slm(l)))
              form(4) = form(4) - tmp/4*(c0(slm(k),slm(m),slm(l))
     1                + 2*c11(slm(k),slm(m),slm(l))
     2                + 2*c12(slm(k),slm(m),slm(l))
     3                + 4*c23(slm(k),slm(m),slm(l)))
              form(5) = form(5) - tmp*(c12(slm(k),slm(m),slm(l))
     1                + c23(slm(k),slm(m),slm(l)))
              call creset
            end if
            tmp = 6*e2/sct2*dimag(v_uuz(l,m)*v_uuz(m,k)*v_uup(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(sum(k),sum(m),sum(l))
              form(2) = form(2) - tmp/2*(c0(sum(k),sum(m),sum(l))
     1                + 3*c11(sum(k),sum(m),sum(l))
     2                + 2*c21(sum(k),sum(m),sum(l)))
              form(3) = form(3) - tmp/2*(c12(sum(k),sum(m),sum(l))
     1                + c22(sum(k),sum(m),sum(l)))
              form(4) = form(4) - tmp/4*(c0(sum(k),sum(m),sum(l))
     1                + 2*c11(sum(k),sum(m),sum(l))
     2                + 2*c12(sum(k),sum(m),sum(l))
     3                + 4*c23(sum(k),sum(m),sum(l)))
              form(5) = form(5) - tmp*(c12(sum(k),sum(m),sum(l))
     1                + c23(sum(k),sum(m),sum(l)))
              call creset
            end if
            tmp = 6*e2/sct2*dimag(v_ddz(l,m)*v_ddz(m,k)*v_ddp(k,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(sdm(k),sdm(m),sdm(l))
              form(2) = form(2) - tmp/6*(c0(sdm(k),sdm(m),sdm(l))
     1                + 3*c11(sdm(k),sdm(m),sdm(l))
     2                + 2*c21(sdm(k),sdm(m),sdm(l)))
              form(3) = form(3) - tmp/2*(c12(sdm(k),sdm(m),sdm(l))
     1                + c22(sdm(k),sdm(m),sdm(l)))
              form(4) = form(4) - tmp/4*(c0(sdm(k),sdm(m),sdm(l))
     1                + 2*c11(sdm(k),sdm(m),sdm(l))
     2                + 2*c12(sdm(k),sdm(m),sdm(l))
     3                + 4*c23(sdm(k),sdm(m),sdm(l)))
              form(5) = form(5) - tmp*(c12(sdm(k),sdm(m),sdm(l))
     1                + c23(sdm(k),sdm(m),sdm(l)))
              call creset
            end if
20    continue
      return
      end
 
      subroutine zzp_vert5(p,q,pq,i,form)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_llzz,v_uuzz,v_ddzz
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      s = p + 2*pq + q
      do 20 k=1,6
        do 20 l=1,6
          form(1) = form(1) - 2*e2*dimag(v_llzz(l,k)*v_llp(k,l,i))
     1            * b0(s,slm(l),slm(k))
          form(1) = form(1) - 6*e2*dimag(v_uuzz(l,k)*v_uup(k,l,i))
     1            * b0(s,sum(l),sum(k))
20        form(1) = form(1) - 6*e2*dimag(v_ddzz(l,k)*v_ddp(k,l,i))
     1            * b0(s,sdm(l),sdm(k))
      return
      end
 
      subroutine zzp_vert(p,q,pq,i,form)
c     Full ZZP formfactor
c     Array form(6) returns formfactors F_1,...,F_6
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call zzp_vert1(p,q,pq,i,form)
      if (is.eq.1) then
        call zzp_vert4(p,q,pq,i,form)
        call zzp_vert5(p,q,pq,i,form)
      end if
      if (ic.eq.1) call zzp_vert2(p,q,pq,i,form)
      if (in.eq.1) call zzp_vert3(p,q,pq,i,form)
      do j=1,6
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end
 
 



