c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZZS_CR.FOR
c     Last revised: 29:03:1995(J.R.)
c     Evaluation of differential cross section added
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the cross section for the Bjorken process       c
c     sigma (e^-e^+ --> Z0 S_i) at CMS energy = sqrt{s}             c
c     (on-shell version). Functions zzs_cross(i,s) and              c
c     zzs_crdif(i,s,cteta) output the cross section in [picobarns]  c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function zzs_cross(i,s)
      implicit double precision (a-h,o-z)
      complex*16 fact,zt,ft,fzt
      complex*16 zt_ren,fzt_ren,ft_ren
      complex*16 fg,fp,gg,gp
      complex*16 ze,dz,df
      complex*16 zms,zmp
      complex*16 a1,b1,a2,b2
      complex*16 zzs(6),fzs(6),cva(6)
      logical zzs_stat,bstat
      common/bswitch/bstat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/hm_phys/frm(2),frm2(2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/crdat/pbarn,a,v
      external init_zzs
      if (zzs_stat.and.(s.eq.ss).and.(i.eq.nh)) then
        zzs_cross = zzs_cr
        if (bstat) zzs_cross = zzs_cross + zzs_box(i,s)
        return
      end if
      zzs_stat = .true.
      ss = s
      nh = i
      if ((frm(i).gt.0.d0).and.(sqrt(s).le.frm(i) + zm)) then
        zzs_cross = 0
        zzs_cr  = 0
        zzs_cra = 0
        zzs_crb = 0
        return
      end if
      p = zm2
      q = frm2(i)
      pq = (s - p - q)/2
      alam = sqrt(s*s - 2*s*(p + q) + (p - q)**2)
      zt  = zt_ren(s)
      ft  = ft_ren(s)
      fzt = fzt_ren(s)
      df = s - ft - fzt**2/(s - zm2 - zt)
      dz = s - zm2 - zt - fzt**2/(s - ft)
      fact = e2*zs(i)*zz/2/sct2/dz
      ze = 0
      fg = 0
      fp = 0
      gg = 0
      gp = 0
      do 10 j=1,2
        k = i_sup(i,j)
        ze = ze + cr(k)*zms(i,j)
        call zzs_ren(p,q,pq,k,zzs)
        call fzs_ren(p,q,pq,k,fzs)
        fg = fg + 2*sct2/e2*zzs(1)*zms(i,j)
        fp = fp + 2*sct2/e2*(zzs(3) - zzs(4))*zms(i,j)
        gg = gg + 2*sct2/e2*fzs(1)*zms(i,j)
10      gp = gp + 2*sct2/e2*(fzs(3) - fzs(4))*zms(i,j)

      call zee_ren(s,1,1,cva)      

      a1 = - cva(1)*(ze + fg) + e*ze*fzt/df + e*gg*dz/df
      b1 = - cva(1)*fp + e*gp*dz/df
      a2 = - cva(2)*(ze + fg)
      b2 = - cva(2)*fp
 
      en = s + p - q
      amx = abs(2*a1 - en*b1)**2 - 4*s*p*abs(b1)**2
      amy = abs(2*a2 - en*b2)**2 - 4*s*p*abs(b2)**2
      am2 = alam**2/48/zm2/s*(amx + amy)
      am1 = abs(a1)**2 + abs(a2)**2 + 1.5d0*am2
 
      afact = abs(fact)**2
      zzs_cross = pbarn*alam*afact*(am1 - am2/2)/16/pi/s
      zzs_cr  = zzs_cross
      zzs_cra = pbarn*alam*afact*am1/64/pi/s
      zzs_crb = 3.d0*pbarn*alam*afact*am2/128/pi/s
      if (bstat) zzs_cross = zzs_cross + zzs_box(i,s)
      return
      end
  
      double precision function zzs_crdif(i,s,cteta)
      implicit double precision (a-h,o-z)
      logical zzs_stat,bstat
      common/bswitch/bstat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if ((.not.zzs_stat).or.(s.ne.ss).or.(i.ne.nh)) 
     1     zzs_crdif = zzs_cross(i,s)
      zzs_crdif = (zzs_cra - zzs_crb*cteta*cteta)/pi
      if (bstat) zzs_crdif = zzs_crdif + zzs_box_d(i,s,cteta)
      return
      end
  
      block data init_zzs
      implicit double precision (a-h,o-z)
      logical zzs_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      data zzs_stat,nh,zzs_cra,zzs_crb,zzs_cr,ss/.false.,0,4*0.d0/
      end
 

 
 
 
