c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: DELTA_R.FOR
c     Released: 1: 5:1994

c     This file contains expressions for delta_r in the MSSM and calculation
c     of the physical W mass

      subroutine wmass(tanb,pm,tm,amiu,gm1,gm2,gm3,xmsq,stbl,sbr,str,
     1                 sll,slr,ybs,yts,yls,ierr,eps)
      implicit double precision(a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fermi/G_fermi
      wm_old = wm
10    wm_new = zm/sq2*sqrt((1 + sqrt(1 - 2*sq2*pi*alpha/G_fermi/zm2
     1       /(1 - dr_mssm(wm_old,tanb,pm,tm,amiu,gm1,gm2,gm3,xmsq,
     2                     stbl,sbr,str,sll,slr,ybs,yts,yls,ierr)))))
      if (ierr.ne.0) return
      if (abs(wm_new - wm_old).le.eps) goto 20
      wm_old = wm_new
      goto 10
20    wm_new = (wm_old + wm_new)/2
      zm_new = zm
      call vpar_update(zm_new,wm_new)
      return
      end

      double precision function dr_mssm(wm_new,tanb,pm,tm,amiu,
     1                                  gm1,gm2,gm3, xmsq,stbl,sbr,str,
     2                                  sll,slr,ybs,yts,yls,ierr)
      implicit double precision (a-h,o-z)
      complex*16 box
      complex*16 wln_ren0,v_ren0
      complex*16 wt_ren
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fermi/G_fermi
      common/thdm/alph,bet,am0,hm1,hm2,hmc,istat0
      common/parcont/if,is,ig,ic,in,iq,il
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in delta_r!'
      dr_mssm = 0
      call vpar_update(zm,wm_new)
      call fset_par(tanb,pm,tm,amiu,gm1,gm2,gm3,
     1              xmsq,stbl,sbr,str,sll,slr,ybs,yts,yls,ierr)
      if (ierr.ne.0) return
c     Set temporary Higgs masses and alpha mixing angles to 1-loop EPA
c     values for delta_r calculations
      if (istat0.ne.2) then
        ist_old = istat0
        call set_2hdm(alph,bet,am0,hm1,hm2,hmc,2)
      end if
c     Gauge sector renormalization
      call gr_const
c     Delta_R value
      dr_mssm = - dble(wt_ren(0.d0))/wm2
      if (if*ig.eq.1) dr_mssm = dr_mssm
     1               + e2*(6 + (7/st2 - 4)*log(ct2)/2)/16/pi/pi/st2
      if (is*ic*in.eq.1) dr_mssm = dr_mssm + dble(box(2,2,1,1)
     2        + wln_ren0(1) + wln_ren0(2) + (v_ren0(1) + v_ren0(2))/2)
c     Restore initial Higgs masses and alpha mixing angle
      if (ist_old.ne.2) call set_2hdm(alph,bet,am0,hm1,hm2,hmc,ist_old)
      return
      end

      complex*16 function wln_ren0(i)
c     renormalized vertex function W-lepton(I)-neutrino(I)
      implicit double precision (a-h,o-z)
      complex*16 wln_ver0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      wln_ren0 = wln_ver0(i,i) + ddzll(i)
      return
      end

      complex*16 function wln_ver0(m,mm)
c     unrenormalized vertex function W-lepton(I)-neutrino(J)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0,zzvl
      complex*16 v_nnn,vl_cnw,vr_cnw,vl_lln,v_nlc,vl_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      wln_ver0 = 0.d0
      do 10 i=1,2
        do 10 j=1,4
          do 10 k=1,6
10          wln_ver0 = wln_ver0 + conjg(v_nlc(mm,k,i))*vl_lln(m,k,j)
     1               * (vr_cnw(j,i)/sq2*( - b0(0.d0,fcm(i),fnm(j))
     2               + 0.5d0 - slm(k)**2*cc(slm(k),fcm(i),fnm(j)))
     3               + fnm(j)*fcm(i)*sq2*vl_cnw(j,i)
     4               * cc(slm(k),fcm(i),fnm(j)))
      do 20 i=1,2
        do 20 j=1,4
          do 20 l=1,3
20          wln_ver0 = wln_ver0 + conjg(v_nnn(mm,l,j))*vl_lsnc(m,l,i)
     1               * (vl_cnw(j,i)/sq2*(b0(0.d0,fcm(i),fnm(j))
     2               - 0.5d0 + vm(l)**2*cc(vm(L),fcm(i),fnm(j)))
     3               - fnm(j)*fcm(i)*sq2*vr_cnw(j,i)
     4               * cc(vm(l),fcm(i),fnm(j)))
      do 30 i=1,6
        do 30 j=1,4
          do 30 l=1,3
            zzvl = 0
            do 40 k=1,3
40            zzvl = zzvl + zv(k,l)*zl(k,i)
30          wln_ver0 = wln_ver0 + conjg(v_nnn(MM,L,j))*vl_lln(M,i,j)
     1               * conjg(zzvl)*(b0(0.d0,vm(L),slm(i))
     2               + 0.5d0 + fnm(j)**2*cc(vm(L),slm(i),fnm(j)))/2
      wln_ver0 = wln_ver0/16/pi/pi
      return
      end

      complex*16 function v_ren0(i)
c     renormalized neutrino self-energy(I)
      implicit double precision (a-h,o-z)
      complex*16 v_self0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      v_ren0 = v_self0(i,i) - ddzll(i)
      return
      end

      complex*16 function v_self0(i,j)
c     unrenormalized neutrino self-energy(I,J)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0,db0
      complex*16 v_nnn,v_nlc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
      v_self0 = 0.d0
      do 10 l=1,2
        do 10 k=1,6
10        v_self0 = v_self0 - v_nlc(i,k,l)*conjg(v_nlc(j,k,l))
     1            * (b0(0.d0,slm(k),fcm(l))
     2            + (fcm(l)**2 - slm(k)**2)*db0(0.d0,slm(k),fcm(l)))/2
      do 20 l=1,3
        do 20 k=1,4
20        v_self0 = v_self0 - v_nnn(i,l,k)*conjg(v_nnn(j,l,k))
     1            * (b0(0.d0,vm(l),fnm(k))
     2            + (fnm(k)**2 - vm(l)**2)*db0(0.d0,vm(l),fnm(k)))/2
      v_self0 = v_self0/16/pi/pi
      return
      end

      complex*16 function box(M,MM,N,NN)
c     contribution of the box diagrams giving (V-A)*(V-A)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 v_nnn,vl_lln,v_nlc,vl_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      box = 0.d0
      do 10 i=1,2
        do 10 j=1,4
          do 10 L=1,3
            do 10 k=1,6
              box = box + vl_lsnc(M,L,i)*v_nlc(NN,k,i)
     1            * conjg(v_nnn(MM,L,j)*vl_lln(N,k,j))
     2            * fcm(i)*fnm(j)* d0(slm(k),vm(L),fcm(i),fnm(j))
10            box = box + vl_lln(M,k,j)*v_nnn(NN,L,j)
     1            * conjg(v_nlc(MM,k,i)*vl_lsnc(N,L,i))
     2            * fcm(i)*fnm(j)* d0(slm(k),vm(L),fcm(i),fnm(j))
      do 20 i=1,2
        do 20 j=1,4
          do 20 k=1,6
            do 20 l=1,6
20            box = box + vl_lln(M,k,j)*v_nlc(NN,l,i)
     1            * conjg(vl_lln(N,l,j)*v_nlc(MM,k,i))
     2            * 2*d11(fcm(i),fnm(j),slm(k),slm(l))
      do 30 K=1,3
        do 30 L=1,3
          do 30 i=1,2
            do 30 j=1,4
30            box = box + vl_lsnc(M,K,i)*v_nnn(NN,L,j)
     1            * conjg(vl_lsnc(N,L,i)*v_nnn(MM,K,j))
     2            * 2*d11(fcm(i),fnm(j),vm(K),vm(L))
      do 40 i=1,4
        do 40 j=1,4
          do 40 L=1,3
            do 40 k=1,6
              box = box + vl_lln(M,k,i)*v_nnn(NN,L,j)
     1            * conjg(v_nnn(MM,L,i)*vl_lln(N,k,j))
     2            * 2*d11(slm(k),vm(L),fnm(i),fnm(j))
40            box = box + vl_lln(M,k,i)*v_nnn(NN,L,i)
     1            * conjg(v_nnn(MM,L,j)*vl_lln(N,k,j))
     2            * fnm(i)*fnm(j)*d0(slm(k),vm(L),fnm(i),fnm(j))
      do 50 i=1,2
        do 50 j=1,2
          do 50 L=1,3
            do 50 k=1,6
50            box = box + vl_lsnc(M,L,i)*v_nlc(NN,k,i)
     1            * conjg(v_nlc(MM,k,j)*vl_lsnc(N,L,j))
     2            * fcm(i)*fcm(j)*d0(slm(k),vm(L),fcm(i),fcm(j))
      box = - wm2*st2/e2*box
      return
      end

      complex*16 function boxR(M,MM,N,NN)
c     contribution of the box diagrams giving (V-A)*(V+A)
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 v_nnn,vr_lln,v_nlc,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      boxR = 0.d0
      do 40 k=1,6
        do 40 L=1,3
          do 40 i=1,4
            do 40 j=1,4
              boxR = boxR - vr_lln(M,k,i)*v_nnn(NN,L,j)
     1             * conjg(v_nnn(MM,L,i)*vr_lln(N,k,j))
     2             * fnm(i)*fnm(j)*d0(slm(k),vm(L),fnm(i),fnm(j))/2
40            boxR = boxR - vr_lln(M,k,i)*v_nnn(NN,L,i)
     1             * conjg(v_nnn(MM,L,j)*vr_lln(N,k,j))
     2             * d11(slm(k),vm(L),fnm(i),fnm(j))
      do 50 k=1,6
        do 50 L=1,3
          do 50 i=1,2
            do 50 j=1,2
50            boxR = boxR - vr_lsnc(M,L,i)*v_nlc(NN,k,i)
     1             * conjg(v_nlc(MM,k,j)*vr_lsnc(N,L,j))
     2             * d11(slm(k),vm(L),fcm(i),fcm(j))
      return
      end

      double precision function d11(xm1,xm2,xm3,xm4)
c     This is the function H as defined in notes
c     masses xm3, xm4 can be equal; xm1,xm2 cannot!
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      a1 = xm1*xm1
      a2 = xm2*xm2
      if (abs((a1 - a2)/a1).gt.1.d-6) then
        d11 = (a1*cc(xm1,xm3,xm4) - a2*cc(xm2,xm3,xm4))
     1      /(a1 - a2)/64/pi/pi
      else
        d11 = (cc(xm2,xm3,xm4) + a1*ccpr(xm2,xm3,xm4)
     1      + a2*(a1 - a2)/2*ccppr(xm2,xm3,xm4))/64/pi/pi
      end if
      return
      end

      double precision function d0(xm1,xm2,xm3,xm4)
c     This is the function F as defined in notes
c     masses xm3,xm4 can be equal; xm1,xm2 cannot!
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      a1 = xm1*xm1
      a2 = xm2*xm2
      if (abs((a1 - a2)/a1).gt.1.d-6) then
        d0 = (cc(xm1,xm3,xm4) - cc(xm2,xm3,xm4))/(a1 - a2)/16/pi/pi
      else
        d0 = (ccpr(xm2,xm3,xm4)
     1     + (a1 - a2)/2*ccppr(xm2,xm3,xm4))/16/pi/pi
      end if
      return
      end

      double precision function cc(xm,xm1,xm2)
c     masses xm1, xm2 can be equal
      implicit double precision (a-h,o-z)
      aa = xm*xm
      a1 = xm1*xm1
      a2 = xm2*xm2
      al1 = log(a1/aa)
      al2 = log(a2/aa)
      if (abs((a1 - a2)/a1).gt.1.d-6) then
        cc = (a1/(aa - a1)*al1 - a2/(aa - a2)*al2)/(a1 - a2)
      else
        cc = (1 + aa/(aa - a2)*al2)/(aa - a2)
     1     + (a1 - a2)/2*(1 + aa/a2 + 2*aa/(aa - a2)*al2)
     2     /(aa - a2)/(aa - a2)
      end if
      return
      end

      double precision function ccpr(xm,xm1,xm2)
c     masses xm1, xm2 can be equal
      implicit double precision (a-h,o-z)
      aa = xm*xm
      a1 = xm1*xm1
      a2 = xm2*xm2
      al1 = log(a1/aa)
      al2 = log(a2/aa)
      if (abs((a1 - a2)/a1).gt.1.d-6) then
        ccpr = ((a2/aa + a2/(aa - a2)*al2)/(aa - a2)
     1       -  (a1/aa + a1/(aa - a1)*al1)/(aa - a1))/(a1 - a2)
      else
        ccpr = - (2 + (aa + a2)/(aa - a2)*al2)/(aa - a2)/(aa - a2)
     1       - (a1 - a2)/2*(5 + aa/a2 + 2*(2*aa + a2)
     2       /(aa - a2)*al2)/(aa - a2)/(aa - a2)/(aa - a2)
      end if
      return
      end

      double precision function ccppr(xm,xm1,xm2)
c     masses xm1, xm2 can be equal
      implicit double precision (a-h,o-z)
      aa = xm*xm
      a1 = xm1*xm1
      a2 = xm2*xm2
      al1 = log(a1/aa)
      al2 = log(a2/aa)
      if (abs((a1-a2)/a1).gt.1.d-6) then
        ccppr = ((3*a1/aa - a1*a1/aa/aa + 2*a1/(aa - a1)*al1)
     1           /(aa - a1)/(aa - a1)
     2         - (3*a2/aa - a2*a2/aa/aa + 2*a2/(aa - a2)*al2)
     1           /(aa - a2)/(aa - a2))/(a1 - a2)
      else
        ccppr = (5 + a2/aa + (2*aa + 4*a2)/(aa -a2)*al2)/(aa - a2)**3
     1       + (a1 - a2)/2*(12*(aa + a2)/(aa - a2)*al2
     2       + 20 + 4*aa/a2)/(aa - a2)**4
      end if
      return
      end

      double precision function ddzll(I)
c     calculation of left lepton renormalization constant
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,zn,zpos,zneg
      complex*16 b0,db0,cdzll
      complex*16 vl_lln,vl_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/fmass/em(3),um(3),dm(3)
c     we set the foton mass equal to the lepton mass.
      cdzll = 0.d0
c     mssm contribution
      do 10 L=1,3
        do 10 j=1,2
10        cdzll = cdzll - abs(vl_lsnc(I,L,j))**2
     1          *((fcm(j)**2 - vm(L)**2)*db0(0.d0,fcm(j),vm(L))
     2          + b0(0.d0,fcm(j),vm(L)))/2
      do 20 k=1,6
        do 20 j=1,4
20        cdzll = cdzll - abs(vl_lln(I,k,j))**2
     1          * ((fnm(j)**2 - slm(k)**2)*db0(0.d0,fnm(j),slm(k))
     2          + b0(0.d0,fnm(j),slm(k)))/2
      ddzll = dble(cdzll)/16/pi/pi
      return
      end





