c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: E_SELF.FOR
c     Released: 22: 2:1994 (J.R.)

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for lepton self-energy function    c
c     and its renormalization.                                          c
c                                                                       c
c     The definition of the self energy as                              c
c     follows (arguments are s=k^2,i,j):                                c
c                                                                       c
c       k      ____    k                                                c
c             |    |          =    -i (G(k)ev_sig + G(k)G(5)ea_sig      c
c       ~~~~~~|____|~~~~~~               + es_sig +     G(5)ep_sig)     c
c      l_i             l_j                                              c
c                                                                       c
c                                                                       c
c     i and j are the flavors of incoming and outgoing lepton           c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Vector self-energy (proportional to k(mu)gamma(mu) = G(k)))       c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ev_sig1(s,i,j)
c     Lepton and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      ev_sig1 = 0
      if (i.ne.j) return
c     Full diagram:
c     ev_sig1 = 2*e2*b1(s,em(i),0.d0)
c     1          + idflag*e2
c     DRED-DIMREG difference:
      ev_sig1 = (idflag - 1)*e2
      return
      end

      complex*16 function ev_sig2(s,i,j)
c     Lepton and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        ev_sig2 = 0
      else
        ev_sig2 = e2/4.d0/sct2*(1 - 4*st2 + 8*st2*st2)*b1(s,em(i),zm)
     1          + idflag*e2/8.d0/sct2*(1 - 4*st2 + 8*st2*st2)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ev_sig3(s,i,j)
c     Neutrino and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) then
        ev_sig3 = 0
      else
        ev_sig3 = e2/st2/2.d0*b1(s,0.d0,wm)
     1          + idflag*e2/st2/4
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ev_sig4(s,i,j)
c     Neutrino + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ev_sig4 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ev_sig4 = ev_sig4 + (em(i)/v1*zh(1,k))**2*b1(s,0.d0,cm(k))
      return
      end

      complex*16 function ev_sig5(s,i,j)
c     Lepton + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ev_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ev_sig5 = ev_sig5 + (em(i)/v1*zr(1,k))**2*b1(s,em(i),rm(k))
      return
      end

      complex*16 function ev_sig6(s,i,j)
c     Lepton + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ev_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ev_sig6 = ev_sig6 + (em(i)/v1*zh(1,k))**2*b1(s,em(i),pm(k))
      return
      end

      complex*16 function ev_sig7(s,i,j)
c     Neutralino and slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zn
      complex*16 vl_lln,vr_lln
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      ev_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        ev_sig7 = ev_sig7 + (vl_lln(i,k,l)*conjg(vl_lln(j,k,l))
     1            + vr_lln(i,k,l)*conjg(vr_lln(j,k,l)))/2
     2            * b1(s,fnm(l),slm(k))
      return
      end

      complex*16 function ev_sig8(s,i,j)
c     Chargino and sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zpos,zneg
      complex*16 vl_lsnc,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ev_sig8 = 0
      do 10 k=1,3
        do 10 l=1,2
10        ev_sig8 = ev_sig8 + (vl_lsnc(i,k,l)*conjg(vl_lsnc(j,k,l))
     1            + vr_lsnc(i,k,l)*conjg(vr_lsnc(j,k,l)))/2
     2            * b1(s,fcm(l),vm(k))
      return
      end

      complex*16 function ev_sig(s,i,j)
c     Full bare lepton self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 ev_sig1,ev_sig2,ev_sig3,ev_sig4,
     1           ev_sig5,ev_sig6,ev_sig7,ev_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ev_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in ev_sig!'
      if (if*ig.eq.1) ev_sig = ev_sig + ev_sig1(s,i,j) + ev_sig2(s,i,j)
     1                                + ev_sig3(s,i,j) + ev_sig4(s,i,j)
     2                                + ev_sig5(s,i,j) + ev_sig6(s,i,j)
      if (is*in*ic.eq.1) ev_sig = ev_sig + ev_sig7(s,i,j)
     1                                   + ev_sig8(s,i,j)
      ev_sig = ev_sig/16/pi/pi
      return
      end

      complex*16 function ev_ren(s,i,j)
c     Full renormalized lepton self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 ev_sig
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      ev_ren = ev_sig(s,i,j) - (dzll(i) + dzre(i))/2
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Axial self-energy (proportional to k(mu)gamma(mu)gamma(5))        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ea_sig2(s,i,j)
c     Lepton and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        ea_sig2 = 0
      else
        ea_sig2 = - e2/4.d0/sct2*(1 - 4*st2)*b1(s,em(i),zm)
     1            - idflag*e2/8.d0/sct2*(1 - 4*st2)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ea_sig3(s,i,j)
c     Neutrino and W in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) then
        ea_sig3 = 0
      else
        ea_sig3 = - e2/st2/2.d0*b1(s,0.d0,wm)
     1            - idflag*e2/st2/4.d0
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function ea_sig4(s,i,j)
c     Neutrino + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      ea_sig4 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      ea_sig4 = ea_sig4 + (em(i)/v1*zh(1,k))**2*b1(s,0.d0,cm(k))
      return
      end

      complex*16 function ea_sig7(s,i,j)
c     Neutralino and slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zn
      complex*16 vl_lln,vr_lln
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      ea_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        ea_sig7 = ea_sig7 - (vl_lln(i,k,l)*conjg(vl_lln(j,k,l))
     1            - vr_lln(i,k,l)*conjg(vr_lln(j,k,l)))/2
     2            * b1(s,fnm(l),slm(k))
      return
      end

      complex*16 function ea_sig8(s,i,j)
c     Chargino and sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 b1
      complex*16 zv,zl,zpos,zneg
      complex*16 vl_lsnc,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ea_sig8 = 0
      do 10 k=1,3
        do 10 l=1,2
10        ea_sig8 = ea_sig8 - (vl_lsnc(i,k,l)*conjg(vl_lsnc(j,k,l))
     1            - vr_lsnc(i,k,l)*conjg(vr_lsnc(j,k,l)))/2
     2            * b1(s,fcm(l),vm(k))
      return
      end

      complex*16 function ea_sig(s,i,j)
c     Full bare lepton self-energy, axial part
      implicit double precision (a-h,o-z)
      complex*16 ea_sig2,ea_sig3,ea_sig4,ea_sig7,ea_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ea_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in ea_sig!'
      if (if*ig.eq.1) ea_sig = ea_sig + ea_sig2(s,i,j) + ea_sig3(s,i,j)
     1                                + ea_sig4(s,i,j)
      if (is*in*ic.eq.1) ea_sig = ea_sig + ea_sig7(s,i,j)
     1                                   + ea_sig8(s,i,j)
      ea_sig = ea_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Scalar self-energy                                                c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function es_sig1(s,i,j)
c     Lepton and photon in loop
c     Since this diagram IN DIMREG is included into an overall QED
c     factor, we subtract here the difference between its value in
c     DIMREG and DRED
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        es_sig1 = 0
      else
c     Full diagram:
c        es_sig1 = 4*e2*em(i)*b0(s,em(i),0.d0)
c     1           - idflag*2*e2*em(i)
c     the last line vanishes in DRED
c     DRED-DIMREG difference
        es_sig1 = (1 - idflag)*2*e2*em(i)
      end if
      return
      end

      complex*16 function es_sig2(s,i,j)
c     Lepton and Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) then
        es_sig2 = 0
      else
        es_sig2 = - 2*e2/ct2*em(i)*(1 - 2*st2)*b0(s,em(i),zm)
     1          + idflag*e2/ct2*em(i)*(1 - 2*st2)
c     the last line vanishes in DRED
      end if
      return
      end

      complex*16 function es_sig5(s,i,j)
c     Lepton + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      es_sig5 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      es_sig5 = es_sig5 - em(i)**3*(zr(1,k)/v1)**2*b0(s,em(i),rm(k))
      return
      end

      complex*16 function es_sig6(s,i,j)
c     Lepton + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      es_sig6 = 0
      if (i.ne.j) return
      do 10 k=1,2
10      es_sig6 = es_sig6 + em(i)**3*(zh(1,k)/v1)**2*b0(s,em(i),pm(k))
      return
      end

      complex*16 function es_sig7(s,i,j)
c     Neutralino and slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zv,zl,zn
      complex*16 vl_lln,vr_lln
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      es_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        es_sig7 = es_sig7 - (vl_lln(i,k,l)*conjg(vr_lln(j,k,l))
     1            + vr_lln(i,k,l)*conjg(vl_lln(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),slm(k))
      return
      end

      complex*16 function es_sig8(s,i,j)
c     Chargino and sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zv,zl,zpos,zneg
      complex*16 vl_lsnc,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      es_sig8 = 0
      do 10 k=1,3
        do 10 l=1,2
10        es_sig8 = es_sig8 - (vl_lsnc(i,k,l)*conjg(vr_lsnc(j,k,l))
     1            + vr_lsnc(i,k,l)*conjg(vl_lsnc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),vm(k))
      return
      end

      complex*16 function es_sig(s,i,j)
c     Full bare lepton self-energy, scalar part
      implicit double precision (a-h,o-z)
      complex*16 es_sig1,es_sig2,es_sig5,es_sig6,es_sig7,es_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      es_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in es_sig!'
      if (if*ig.eq.1) es_sig = es_sig + es_sig1(s,i,j) + es_sig2(s,i,j)
     1                                + es_sig5(s,i,j) + es_sig6(s,i,j)
      if (is*in*ic.eq.1) es_sig = es_sig + es_sig7(s,i,j)
     1                                   + es_sig8(s,i,j)
      es_sig = es_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Pseudoscalar self-energy (proportional to G(5))                   c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function ep_sig7(s,i,j)
c     Neutralino and slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zv,zl,zn
      complex*16 vl_lln,vr_lln
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/neut/fnm(4),zn(4,4)
      ep_sig7 = 0
      do 10 k=1,6
        do 10 l=1,4
10        ep_sig7 = ep_sig7 + (vl_lln(i,k,l)*conjg(vr_lln(j,k,l))
     1            - vr_lln(i,k,l)*conjg(vl_lln(j,k,l)))*fnm(l)/2
     2            * b0(s,fnm(l),slm(k))
      return
      end

      complex*16 function ep_sig8(s,i,j)
c     Chargino and sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zv,zl,zpos,zneg
      complex*16 vl_lsnc,vr_lsnc
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      ep_sig8 = 0
      do 10 k=1,3
        do 10 l=1,2
10        ep_sig8 = ep_sig8 + (vl_lsnc(i,k,l)*conjg(vr_lsnc(j,k,l))
     1            - vr_lsnc(i,k,l)*conjg(vl_lsnc(j,k,l)))*fcm(l)/2
     2            * b0(s,fcm(l),vm(k))
      return
      end

      complex*16 function ep_sig(s,i,j)
c     Full bare lepton self-energy, pseudoscalar part
      implicit double precision (a-h,o-z)
      complex*16 ep_sig7,ep_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      ep_sig = (0,0)
      if ((is.ne.ic).or.(is.ne.in)) stop 'is=ic=in required in ep_sig!'
      if (is*in*ic.eq.1) ep_sig = ep_sig + ep_sig7(s,i,j)
     1                                   + ep_sig8(s,i,j)
      ep_sig = ep_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Left and right self-energy                                        c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function el_sig(s,i,j)
c     Full bare lepton self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 ev_sig1,ev_sig2,ev_sig3,ev_sig4,
     1           ev_sig5,ev_sig6,ev_sig7,ev_sig8
      complex*16 ea_sig2,ea_sig3,ea_sig4,ea_sig7,ea_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      el_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in el_sig!'
      if (if*ig.eq.1) el_sig = el_sig + ev_sig1(s,i,j)
     1                                + ev_sig2(s,i,j) - ea_sig2(s,i,j)
     2                                + ev_sig3(s,i,j) - ea_sig3(s,i,j)
     3                                + ev_sig4(s,i,j) - ea_sig4(s,i,j)
     4                                + ev_sig5(s,i,j)
     5                                + ev_sig6(s,i,j)
      if (is*in*ic.eq.1) el_sig = el_sig + ev_sig7(s,i,j)
     1                                   - ea_sig7(s,i,j)
     2                                   + ev_sig8(s,i,j)
     3                                   - ea_sig8(s,i,j)
      el_sig = el_sig/16/pi/pi
      return
      end

      complex*16 function er_sig(s,i,j)
c     Full bare lepton self-energy, vector part
      implicit double precision (a-h,o-z)
      complex*16 ev_sig1,ev_sig2,ev_sig3,ev_sig4,
     1           ev_sig5,ev_sig6,ev_sig7,ev_sig8
      complex*16 ea_sig2,ea_sig3,ea_sig4,ea_sig7,ea_sig8
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      er_sig = (0,0)
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in er_sig!'
      if (if*ig.eq.1) er_sig = er_sig + ev_sig1(s,i,j)
     1                                + ev_sig2(s,i,j) + ea_sig2(s,i,j)
     2                                + ev_sig3(s,i,j) + ea_sig3(s,i,j)
     3                                + ev_sig4(s,i,j) + ea_sig4(s,i,j)
     4                                + ev_sig5(s,i,j)
     5                                + ev_sig6(s,i,j)
      if (is*in*ic.eq.1) er_sig = er_sig + ev_sig7(s,i,j)
     1                                   + ea_sig7(s,i,j)
     2                                   + ev_sig8(s,i,j)
     3                                   + ea_sig8(s,i,j)
      er_sig = er_sig/16/pi/pi
      return
      end

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Constant terms in ev_sig,es_sig                                   c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      double precision function ev_sigc()
c     Constant contribution to ev_sig
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (if.ne.ig) stop 'if=ig required in ev_sigc!'
      ev_sigc = 0
      if (if*ig.ne.1) return
c     DIMREG;
      if (idflag.eq.1) ev_sigc = (e2/8/sct2*(1 - 4*st2 + 8*st2*st2)
     1    + e2/st2/4)/16/pi/pi
c     DRED:
      if (idflag.eq.0) ev_sigc = - e2/16/pi/pi
      return
      end

      double precision function es_sigc()
c     Constant contribution to es_sig; em(i) factorized
      implicit double precision (a-h,o-z)
      common/dimreg/idflag
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      if (if.ne.ig) stop 'if=ig required in es_sigc!'
      es_sigc = 0
      if (if*ig.ne.1) return
c     DIMREG;
      if (idflag.eq.1) es_sigc = e2/ct2*(1 - 2*st2)/16/pi/pi
c     DRED:
      if (idflag.eq.0) es_sigc = e2/8/pi/pi
      return
      end



