c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FFP_VERT.FOR
c     Last revised: 27: 3:1996(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains pseudoscalar - GAMMA- GAMMA vertex           c
c     formfactors. General off-shell expressions.                     c
c                                                                     c
c     Incoming pseudoscalar P(i):  momentum (p+q)                     c
c     Outgoing GAMMA            :  momentum  p^{\mu}                  c
c     Outgoing GAMMA            :  momentum  q^{\nu}                  c
c                                                                     c
c                                                                     c
c                                       GAMMA^\mu                     c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       P_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GAMMA^\nu                    c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex:                                   c
c                                                                     c
c       V = i (F_1 g(mu,nu) + F_2 p(mu)p(nu) + F_3 q(mu)q(nu)         c
c            + F_4 p(mu)q(nu) + F_5 q(mu)p(nu))                       c
c            + F_6 eps(p,q,mu,nu)                                     c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine ffp_vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        form(6) = form(6) + 8*e2*em(k)*em(k)*zh(1,i)/v1
     1          * c0(em(k),em(k),em(k))
        call creset
        form(6) = form(6) + 32/3.d0*e2*um(k)*um(k)*zh(2,i)/v2
     1          * c0(um(k),um(k),um(k))
        call creset
        form(6) = form(6) + 8/3.d0*e2*dm(k)*dm(k)*zh(1,i)/v1
     1          * c0(dm(k),dm(k),dm(k))
10      call creset
      return
      end
 
      subroutine ffp_vert2(p,q,pq,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      complex*16 zpos,zneg
      complex*16 v_ccp
      complex*16 r
      double precision mk
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        mk = fcm(k)
        r = (v_ccp(k,k,i) + conjg(v_ccp(k,k,i)))/2
        form(6) = form(6) - 4*e*e2*sq2/st*mk*dble(r)*c0(mk,mk,mk)
10      call creset
      return
      end
 
      subroutine ffp_vert4(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24,b0
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      s = p + 2*pq + q
      do 20 k=1,6
        tmp = 2*e2*dimag(v_llp(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*(4*c24(slm(k),slm(k),slm(k)) 
     1            + b0(s,slm(k),slm(k)))
          form(2) = form(2) - 2*tmp*(c0(slm(k),slm(k),slm(k))
     1            + 3*c11(slm(k),slm(k),slm(k))
     2            + 2*c21(slm(k),slm(k),slm(k)))
          form(3) = form(3) - 2*tmp*(c12(slm(k),slm(k),slm(k))
     1            + c22(slm(k),slm(k),slm(k)))
          form(4) = form(4) - tmp*(c0(slm(k),slm(k),slm(k))
     1            + 2*c11(slm(k),slm(k),slm(k))
     2            + 2*c12(slm(k),slm(k),slm(k))
     3            + 4*c23(slm(k),slm(k),slm(k)))
          form(5) = form(5) - 4*tmp*(c12(slm(k),slm(k),slm(k))
     1            + c23(slm(k),slm(k),slm(k)))
          call creset
        end if
        tmp = 8/3.d0*e2*dimag(v_uup(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*(4*c24(sum(k),sum(k),sum(k))
     1            + b0(s,sum(k),sum(k)))
          form(2) = form(2) - 2*tmp*(c0(sum(k),sum(k),sum(k))
     1            + 3*c11(sum(k),sum(k),sum(k))
     2            + 2*c21(sum(k),sum(k),sum(k)))
          form(3) = form(3) - 2*tmp*(c12(sum(k),sum(k),sum(k))
     1            + c22(sum(k),sum(k),sum(k)))
          form(4) = form(4) - tmp*(c0(sum(k),sum(k),sum(k))
     1            + 2*c11(sum(k),sum(k),sum(k))
     2            + 2*c12(sum(k),sum(k),sum(k))
     3            + 4*c23(sum(k),sum(k),sum(k)))
          form(5) = form(5) - 4*tmp*(c12(sum(k),sum(k),sum(k))
     1            + c23(sum(k),sum(k),sum(k)))
          call creset
        end if
        tmp = 2/3.d0*e2*dimag(v_ddp(k,k,i))
        if (abs(tmp).gt.epsf) then
          form(1) = form(1) - tmp*c24(sdm(k),sdm(k),sdm(k))
     1            + b0(s,sdm(k),sdm(k))
          form(2) = form(2) - 2*tmp*(c0(sdm(k),sdm(k),sdm(k))
     1            + 3*c11(sdm(k),sdm(k),sdm(k))
     2            + 2*c21(sdm(k),sdm(k),sdm(k)))
          form(3) = form(3) - 2*tmp*(c12(sdm(k),sdm(k),sdm(k))
     1            + c22(sdm(k),sdm(k),sdm(k)))
          form(4) = form(4) - tmp*(c0(sdm(k),sdm(k),sdm(k))
     1            + 2*c11(sdm(k),sdm(k),sdm(k))
     2            + 2*c12(sdm(k),sdm(k),sdm(k))
     3            + 4*c23(sdm(k),sdm(k),sdm(k)))
          form(5) = form(5) - 4*tmp*(c12(sdm(k),sdm(k),sdm(k))
     1            + c23(sdm(k),sdm(k),sdm(k)))
          call creset
        end if
20    continue
      return
      end

      subroutine ffp_vert(p,q,pq,i,form)
c     Full GAMMA-GAMMA-P formfactor
c     Array form(6) returns formfactors F_1,...,F_6
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call ffp_vert1(p,q,pq,i,form)
      if (is.eq.1) call ffp_vert4(p,q,pq,i,form)
      if (ic.eq.1) call ffp_vert2(p,q,pq,i,form)
      do j=1,6
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end
 
 
 




