c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: FZP_VERT.FOR
c     Last revised: 27: 3:1996(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains pseudoscalar - Z0-GAMMA vertex formfactors   c
c                                                                     c
c     Incoming pseudoscalar P(i):  momentum (p+q)                     c
c     Outgoing Z0               :  momentum  p^{\mu}                  c
c     Outgoing GAMMA            :  momentum  q^{\nu}                  c
c                                                                     c
c                                                                     c
c                                       Z0^\mu                        c
c                             /|~~~~~~~~                              c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       P_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  GAMMA^\nu                    c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 497)                   c
c                                                                     c
c       V = i (G_1 g(mu,nu) + G_2 p(mu)p(nu) + G_3 q(mu)q(nu)         c
c            + G_4 p(mu)q(nu) + G_5 q(mu)p(nu))                       c
c            + G_6 eps(mu,nu,p,q)                                     c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine fzp_vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        form(6) = form(6) + 2*e2/sct*(1 - 4*st2)*em(k)*em(k)
     1          * zh(1,i)/v1*c0(em(k),em(k),em(k))
        call creset
        form(6) = form(6) + 4*e2/sct*(1 - 8.d0/3*st2)
     1          * um(k)*um(k)*zh(2,i)/v2*c0(um(k),um(k),um(k))
        call creset
        form(6) = form(6) + 2*e2/sct*(1 - 4.d0/3*st2)
     1          * dm(k)*dm(k)*zh(1,i)/v1*c0(dm(k),dm(k),dm(k))
10      call creset
      return
      end

      subroutine fzp_vert2(p,q,pq,i,form)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz,v_ccp
      complex*16 a,b,r,s
      complex*16 tmp1,tmp2
      complex*16 form(6)
      double precision mk,ml
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 l=1,2
          mk  =  fcm(k)
          ml  =  fcm(l)
          a = (v_ccp(k,l,i) - conjg(v_ccp(l,k,i)))/2
          r = (v_ccp(k,l,i) + conjg(v_ccp(l,k,i)))/2
          b = (vl_ccz(k,l) + vr_ccz(k,l))/2
          s = (vl_ccz(k,l) - vr_ccz(k,l))/2
          tmp1 = - mk*dimag(r*b - a*s)
     1         *(0.5d0 + p*(c0(mk,ml,ml) + 2*c11(mk,ml,ml)
     2         + c21(mk,ml,ml)) + q*(c12(mk,ml,ml) + c22(mk,ml,ml))
     3         + pq*(c0(mk,ml,ml) + c11(mk,ml,ml) + 2*c12(mk,ml,ml)
     4         + 2*c23(mk,ml,ml)) + 2*c24(mk,ml,ml))
          tmp2 = ml*dimag(r*b + a*s)
     1         *(q*c12(mk,ml,ml) + pq*c11(mk,ml,ml) + 2*c24(mk,ml,ml))
          form(1) = form(1) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
          tmp1 = 2*mk*dimag(r*b - a*s)
     1         *(c0(mk,ml,ml) + 2*c11(mk,ml,ml) + c21(mk,ml,ml))
          tmp2 = 2*ml*dimag(r*b + a*s)
     1         *(c11(mk,ml,ml) + c21(mk,ml,ml))
          form(2) = form(2) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
          tmp1 = 2*mk*dimag(r*b - a*s)*(c12(mk,ml,ml) + c22(mk,ml,ml))
          tmp2 = 2*ml*dimag(r*b + a*s)*c22(mk,ml,ml)
          form(3) = form(3) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
          tmp1 = mk*dimag(r*b - a*s)*(c0(mk,ml,ml) + c11(mk,ml,ml)
     1         + 2*c12(mk,ml,ml) + 2*c23(mk,ml,ml))
          tmp2 = ml*dimag(r*b + a*s)*(c11(mk,ml,ml) + 2*c23(mk,ml,ml))
          form(4) = form(4) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
          tmp1 = mk*dimag(r*b - a*s)*(c0(mk,ml,ml) + c11(mk,ml,ml)
     2         + 2*c12(mk,ml,ml) + 2*c23(mk,ml,ml))
          tmp2 = ml*dimag(r*b + a*s)*(c11(mk,ml,ml) + 2*c23(mk,ml,ml))
          form(5) = form(5) - e*e2*sq2/st/sct2*(tmp1 + tmp2)
          tmp1 = - mk*dble(r*b - a*s)*(c0(mk,ml,ml) + c11(mk,ml,ml))
          tmp2 = ml*dble(r*b + a*s)*c11(mk,ml,ml)
          form(6) = form(6) + 2*e*e2*sq2/st/sct*(tmp1 + tmp2)
10        call creset
      return
      end 
 
      subroutine fzp_vert4(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24,b0
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      s = p + 2*pq + q
      do 20 k=1,6
        do 20 l=1,6
          tmp = 4*e2/sct*dimag(v_llz(l,k)*v_llp(k,l,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) - tmp*(c24(slm(k),slm(l),slm(l))
     1              + b0(s,slm(l),slm(k))/4)
            form(2) = form(2) - tmp/2*(c0(slm(k),slm(l),slm(l))
     1              + 3*c11(slm(k),slm(l),slm(l))
     2              + 2*c21(slm(k),slm(l),slm(l)))
            form(3) = form(3) - tmp/2*(c12(slm(k),slm(l),slm(l))
     1              + c22(slm(k),slm(l),slm(l)))
            form(4) = form(4) - tmp/4*(c0(slm(k),slm(l),slm(l))
     1              + 2*c11(slm(k),slm(l),slm(l))
     2              + 2*c12(slm(k),slm(l),slm(l))
     3              + 4*c23(slm(k),slm(l),slm(l)))
            form(5) = form(5) - tmp*(c12(slm(k),slm(l),slm(l))
     1              + c23(slm(k),slm(l),slm(l)))
            call creset
          end if
          tmp = 8*e2/sct*dimag(v_uuz(l,k)*v_uup(k,l,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) - tmp*(c24(sum(k),sum(l),sum(l))
     1              + b0(s,sum(l),sum(k))/4)
            form(2) = form(2) - tmp/2*(c0(sum(k),sum(l),sum(l))
     1              + 3*c11(sum(k),sum(l),sum(l))
     2              + 2*c21(sum(k),sum(l),sum(l)))
            form(3) = form(3) - tmp/2*(c12(sum(k),sum(l),sum(l))
     1              + c22(sum(k),sum(l),sum(l)))
            form(4) = form(4) - tmp/4*(c0(sum(k),sum(l),sum(l))
     1              + 2*c11(sum(k),sum(l),sum(l))
     2              + 2*c12(sum(k),sum(l),sum(l))
     3              + 4*c23(sum(k),sum(l),sum(l)))
            form(5) = form(5) - tmp*(c12(sum(k),sum(l),sum(l))
     1              + c23(sum(k),sum(l),sum(l)))
            call creset
          end if
          tmp = 4*e2/sct*dimag(v_ddz(l,k)*v_ddp(k,l,i))
          if (abs(tmp).gt.epsf) then
            form(1) = form(1) - tmp*(c24(sdm(k),sdm(l),sdm(l))
     1              + b0(s,sdm(l),sdm(k))/4)
            form(2) = form(2) - tmp/2*(c0(sdm(k),sdm(l),sdm(l))
     1              + 3*c11(sdm(k),sdm(l),sdm(l))
     2              + 2*c21(sdm(k),sdm(l),sdm(l)))
            form(3) = form(3) - tmp/2*(c12(sdm(k),sdm(l),sdm(l))
     1              + c22(sdm(k),sdm(l),sdm(l)))
            form(4) = form(4) - tmp/4*(c0(sdm(k),sdm(l),sdm(l))
     1              + 2*c11(sdm(k),sdm(l),sdm(l))
     2              + 2*c12(sdm(k),sdm(l),sdm(l))
     3              + 4*c23(sdm(k),sdm(l),sdm(l)))
            form(5) = form(5) - tmp*(c12(sdm(k),sdm(l),sdm(l))
     1              + c23(sdm(k),sdm(l),sdm(l)))
            call creset
          end if
20    continue
      return
      end

      subroutine fzp_vert(p,q,pq,i,form)
c     Full GAMMA-Z0-P formfactor
c     Array form(6) returns formfactors G_1,...,G_6
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do j=1,6
         form(j) = (0,0)
      end do
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call fzp_vert1(p,q,pq,i,form)
      if (is.eq.1) call fzp_vert4(p,q,pq,i,form)
      if (ic.eq.1) call fzp_vert2(p,q,pq,i,form)
      do j=1,6
         form(j) = - form(j)/16/pi/pi
      end do
      return
      end
 
 



 
 


 






