c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: MH_DIAG.FOR
c      Revised: 25: 4:1996(J.R.)
c      Initialization variables for charged Higgs-squark vertices added
c      Subroutine set_2hdm added: see comments inside.
c      Revised: 25: 3:1997(J.R.)
c      Proper handling of complex chargino and neutralino parameters  

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains set of routines computing masses and mixing   c
c     angles of physical particles in the MSSM.                        c
c     Compare with the paper: J.Rosiek@Phys.Rev.D41(1990)p.3464;       c
c     erratum hep-ph/9511250                                           c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      logical function sldiag()
c     Slepton masses and mixing angles
c     sldiag=true if one or more masses negative
      implicit double precision (a-h,o-z)
      logical init_lls,init_llp
      complex*16 zv,zl,h
      complex*16 lms,rms,ums,dms,qms
      complex*16 vlls,vllp
      double precision mv(3,3),imv(3,3),zv1(3,3),zv2(3,3)
      double precision msl(6,6),imsl(6,6),zl1(6,6),zl2(6,6),work(12)
      complex*16 ls,ks,ds,es,us,ws,tmp(6,6)
      logical zzs_stat,zps_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hpar/hm1,hm2,hs,h
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/msoft/lms(3,3),rms(3,3),ums(3,3),dms(3,3),qms(3,3)
      common/rsl/vlls(6,6,2),init_lls
      common/psl/vllp(6,6,2),init_llp
c     Scalar - slepton vertices should be recalculated after this procedure
      init_lls = .true.
      init_llp = .true.
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
c     sldiag variable initialization
      sldiag = .false.
c     Sneutrino masses and mixing angles
      vmin = v1*v1-v2*v2
      do 10 i=1,3
        do 10 j=1,3
          imv(i,j) = dimag(lms(i,j))
          mv(i,j) = dble(lms(i,j))
10        if (i.eq.j) mv(i,j) = mv(i,j)+e2/8/sct2*vmin
      call eisch1(3,3,mv,imv,vm,zv1,zv2,ierr,work)
      do 20 i=1,3
        if (vm(i).le.0.d0) then
          sldiag = .true.
          vm(i) = -sqrt(-vm(i))
        else
          vm(i) = sqrt(vm(i))
        end if
        do 20 j=1,3
20        zv(i,j) = zv1(i,j)+(0,1)*zv2(i,j)
c     Slepton masses and mixing angles
      do 30 i=1,3
        do 30 j=1,3
          tmp(i,j)       = lms(j,i)
          tmp(i+3,j+3)   = rms(i,j)
          tmp(i,j+3)     = -(v2*ks(i,j)-v1*ls(i,j))/sq2
          if (i.eq.j) then
            tmp(i,j)     = tmp(i,j)+e2/8*(1-2*ct2)/sct2*vmin+em(i)**2
            tmp(i+3,j+3) = tmp(i+3,j+3)-e2/4/ct2*vmin+em(i)**2
            tmp(i,j+3)   = tmp(i,j+3)-v2/v1*em(i)*conjg(h)
          end if
30        tmp(j+3,i)     = conjg(tmp(i,j+3))
      do 40 i=1,6
        do 40 j=1,6
          msl(i,j)  = dble(tmp(i,j))
40        imsl(i,j) = dimag(tmp(i,j))
      call eisch1(6,6,msl,imsl,slm,zl1,zl2,ierr,work)
      do 50 i=1,6
        if (slm(i).le.0.d0) then
          sldiag = .true.
          slm(i) = -sqrt(-slm(i))
        else
          slm(i) = sqrt(slm(i))
        end if
        do 50 j=1,6
50        zl(i,j)=zl1(i,j)+(0,1)*zl2(i,j)
      return
      end

      logical function sqdiag()
c     Squark masses and mixing angles
c     sqdiag=true if one or more masses negative
      implicit double precision (a-h,o-z)
      logical init_uus,init_dds,init_uup,init_ddp
      logical init_ddhh,init_uuhh,init_udh,init_udhs
      complex*16 vuus,vdds,vuup,vddp
      complex*16 vddhh,vuuhh,vudh,vudhs
      complex*16 zu,zd,h
      complex*16 lms,rms,ums,dms,qms
      complex*16 c,tmp1(6,6),tmp2(6,6)
      complex*16 ls,ks,ds,es,us,ws
      double precision msu(6,6),imsu(6,6),zu1(6,6),zu2(6,6)
      double precision msd(6,6),imsd(6,6),zd1(6,6),zd2(6,6),work(12)
      logical zzs_stat,zps_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/hpar/hm1,hm2,hs,h
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/msoft/lms(3,3),rms(3,3),ums(3,3),dms(3,3),qms(3,3)
      common/km_mat/c(3,3)
      common/rsu/vuus(6,6,2),init_uus
      common/rsd/vdds(6,6,2),init_dds
      common/psu/vuup(6,6,2),init_uup
      common/psd/vddp(6,6,2),init_ddp
      common/hud/vudh(6,6,2),init_udh
      common/hhdd/vddhh(6,6,2,2),init_ddhh
      common/hhuu/vuuhh(6,6,2,2),init_uuhh
      common/hsud/vudhs(6,6,2,2),init_udhs
c     Scalar - squark vertices should be recalculated after this procedure
      init_uus = .true.
      init_dds = .true.
      init_uup = .true.
      init_ddp = .true.
      init_udh = .true.
      init_ddhh = .true.
      init_uuhh = .true.
      init_udhs = .true.
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
c     sqdiag variable initialization
      sqdiag = .false.
      vmin = v1*v1 - v2*v2
      do 10 i=1,3
        do 10 j=1,3
c    D-squark mass matrix initialization
          tmp1(i,j)       = qms(j,i)
          tmp1(i+3,j+3)   = dms(i,j)
          tmp1(i,j+3)     = - (v2*es(i,j) - v1*ds(i,j))/sq2
          if (i.eq.j) then
            tmp1(i,j)     = tmp1(i,j)-e2*vmin*(1+2*ct2)/24/sct2+dm(i)**2
            tmp1(i+3,j+3) = tmp1(i+3,j+3) - e2*vmin/12/ct2 + dm(i)**2
            tmp1(i,j+3)   = tmp1(i,j+3) - v2/v1*dm(i)*conjg(h)
          end if
          tmp1(j+3,i)     = conjg(tmp1(i,j+3))
c     U-squark mass matrix initialization
          tmp2(i,j) = (0,0)
          do 20 k=1,3
            do 20 l=1,3
20            tmp2(i,j)   = tmp2(i,j) + conjg(qms(k,l)*c(l,i))*c(k,j)
          tmp2(i+3,j+3)   = conjg(ums(i,j))
          tmp2(i,j+3)     = - conjg(v2*us(i,j) + v1*ws(i,j))/sq2
          if (i.eq.j) then
            tmp2(i,j)     = tmp2(i,j)-e2*vmin*(1-4*ct2)/24/sct2+um(i)**2
            tmp2(i+3,j+3) = tmp2(i+3,j+3) + e2/6/ct2*vmin + um(i)**2
            tmp2(i,j+3)   = tmp2(i,j+3) - v1/v2*um(i)*h
          end if
10        tmp2(j+3,i)     = conjg(tmp2(i,j+3))
      do 30 i=1,6
        do 30 j=1,6
          msd(i,j)  = dble(tmp1(i,j))
          imsd(i,j) = dimag(tmp1(i,j))
          msu(i,j)  = dble(tmp2(i,j))
30        imsu(i,j) = dimag(tmp2(i,j))
      call eisch1(6,6,msd,imsd,sdm,zd1,zd2,ierr,work)
      call eisch1(6,6,msu,imsu,sum,zu1,zu2,ierr,work)
      do 40 i=1,6
        if (sdm(i).le.0.d0) then
          sqdiag = .true.
          sdm(i) = -sqrt(-sdm(i))
        else
          sdm(i) = sqrt(sdm(i))
        end if
        if (sum(i).le.0.d0) then
          sqdiag = .true.
          sum(i) = -sqrt(-sum(i))
        else
          sum(i) = sqrt(sum(i))
        end if
        do 40 j=1,6
          zu(i,j) = zu1(i,j)+(0,1)*zu2(i,j)
40        zd(i,j) = zd1(i,j)+(0,1)*zd2(i,j)
      return
      end

      logical function cdiag()
c     Chargino masses and mixing angles
c     cdiag=true if one or two masses less then 1 MeV
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg,x(2,2)
      complex*16 ztmp(2,2),sgn(2)
      complex*16 h,gm2,gm3
      double precision z1(2,2),z2(2,2),z3(2,2),z4(2,2)
      double precision z5(2,2),z6(2,2),z7(2,2),z8(2,2),work(4)
      double precision diag(2,2),swap(2,2)
      logical zzs_stat,zps_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/hpar/hm1,hm2,hs,h
      common/gmass/gm1,gm2,gm3
      data swap/0.d0,1.d0,1.d0,0.d0/
      cdiag = .false.
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
c     Chargino mass matrix initialization
      x(1,1) = 2*gm2
      x(1,2) = e*v2/sq2/st
      x(2,1) = e*v1/sq2/st
      x(2,2) = h
c     Build X*Xherm and X*hermX
      do i=1,2
        do j=1,2
          z1(i,j) = 0.d0
          z2(i,j) = 0.d0
          z3(i,j) = 0.d0
          z4(i,j) = 0.d0
          do k=1,2
            z1(i,j) = z1(i,j) + dble(conjg(x(k,i))*x(k,j))
            z2(i,j) = z2(i,j) + dimag(conjg(x(k,i))*x(k,j))
            z3(i,j) = z3(i,j) + dble(conjg(x(i,k))*x(j,k))
            z4(i,j) = z4(i,j) + dimag(conjg(x(i,k))*x(j,k))
          end do
        end do
      end do
      call eisch1(2,2,z1,z2,fcm,z5,z6,ierr,work)
      call eisch1(2,2,z3,z4,fcm,z7,z8,ierr,work)
c      Build mixing matrices up to possible rows swap and mass sign chang
      do i=1,2
        do j=1,2
          zpos(i,j) = z5(i,j) + (0,1)*z6(i,j)
          zneg(i,j) = z7(i,j) + (0,1)*z8(i,j)
        end do
      end do
c      Check is row swapping is necessary. If yes, perform it.
      do i=1,2
        do j=1,2
          ztmp(i,j) = (0.d0,0.d0)
          do k=1,2
            do l=1,2
              ztmp(i,j) = ztmp(i,j) + zneg(k,i)*zpos(l,j)*x(k,l)
            end do
          end do
          diag(i,j) = abs(ztmp(i,j))
        end do
      end do
      if (max(diag(1,1),diag(2,2)).lt.max(diag(1,2),diag(2,1))) then
        do i=1,2
          do j=1,2
            ztmp(i,j) = (0.d0,0.d0)
            do k=1,2
              ztmp(i,j) = ztmp(i,j) + zpos(i,k)*swap(k,j)
            end do
          end do
        end do
        do i=1,2
          do j=1,2
            zpos(i,j) = ztmp(i,j)
          end do
        end do
      end if
c      Find complex chargino masses and rephasing vector
      do i=1,2
        sgn(i) = (0.d0,0.d0)
        do k=1,2
          do l=1,2
            sgn(i) = sgn(i) + zneg(k,i)*zpos(l,i)*x(k,l)
          end do
        end do
        if (abs(sgn(i)).eq.0) then
          sgn(i) = (1,0)
        else
          sgn(i) = sgn(i)/abs(sgn(i))
        end if
      end do
      do i=1,2
        do j=1,2
          zpos(i,j) = conjg(sgn(j))*zpos(i,j)
        end do
      end do
c      Finally, calculate chargino masses. Check if not too small.
      do i=1,2
        fcm(i) = 0.d0
        do k=1,2
          do l=1,2
            fcm(i) = fcm(i) + dble(zneg(k,i)*zpos(l,i)*x(k,l))
          end do
        end do
        if (fcm(i).le.1.d-3) cdiag = .true.
      end do
      return
      end

      logical function ndiag()
c     Neutralino masses and mixing angles
c     ndiag=true if one or more neutralinos is lighter than 1 MeV
      implicit double precision (a-h,o-z)
      complex*16 zn,h,y(4,4),sgn(4),gm2,gm3
      double precision z1(4,4),z2(4,4),z3(4,4),z4(4,4),work(8)
      logical zzs_stat,zps_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/neut/fnm(4),zn(4,4)
      common/gmass/gm1,gm2,gm3
      common/hpar/hm1,hm2,hs,h
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
c     ndiag variable initialization
      ndiag = .false.
c     Neutralino mass matrix initialization
      g3 = e/ct/2
      g2 = e/st/2
      y(1,1) = 2*gm3
      y(1,2) = 0.d0
      y(1,3) = - v1*g3
      y(1,4) = v2*g3
      y(2,2) = 2*gm2
      y(2,3) = v1*g2
      y(2,4) = - v2*g2
      y(3,3) = 0.d0
      y(3,4) = - h
      y(4,4) = 0.d0
      do i=2,4
         do j=1,i-1
            y(i,j) = y(j,i)
         end do
      end do
c     Build Y^{\dagger}*Y
      do i=1,4
         do j=1,4
            z1(i,j) = 0.d0
            z2(i,j) = 0.d0
            do k=1,4
               z1(i,j) = z1(i,j) + dble(y(k,j)*conjg(y(k,i)))
               z2(i,j) = z2(i,j) + dimag(y(k,j)*conjg(y(k,i)))
            end do
         end do
      end do
      call eisch1(4,4,z1,z2,fnm,z3,z4,ierr,work)
c     Build phase matrix
      do i=1,4
         do j=1,4
            zn(i,j) = cmplx(z3(i,j),z4(i,j))
         end do
      end do
c     Find complex neutralino masses and rephasing vector
      do i=1,4
         sgn(i) = (0.d0,0.d0)
         do k=1,4
            do l=1,4
               sgn(i) = sgn(i) + zn(k,i)*y(k,l)*zn(l,i)
            end do
         end do
         if (abs(sgn(i)).eq.0) then
            sgn(i) = (1,0)
         else
            sgn(i) = sqrt(sgn(i)/abs(sgn(i)))
         end if
      end do
c     Find diagonalization matrix
      do i=1,4
         do j=1,4
            zn(i,j) = zn(i,j)*conjg(sgn(j))
         end do
      end do
c     Find neutralino masses. Check if not too low
      do i=1,4
         fnm(i) = 0.d0
         do k=1,4
            do l=1,4
               fnm(i) = fnm(i) + dble(zn(k,i)*y(k,l)*zn(l,i))
            end do
         end do
         if (fnm(i).le.1.d-3) ndiag = .true.
      end do
      return
      end

      logical function hdiag()
c     Higgs masses and mixing matrices
c     hdiag=true if one or more masses less equal to zero
      implicit double precision (a-h,o-z)
      logical init_lls,init_uus,init_dds
      logical init_llp,init_uup,init_ddp
      logical init_ddhh,init_uuhh,init_udh,init_udhs
      complex*16 h,vuus,vdds,vlls,vuup,vddp,vllp
      complex*16 vddhh,vuuhh,vudh,vudhs
      logical zzs_stat,zps_stat
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hmass_mssm/cmm(2),rmm(2),pmm(2),zzr(2,2),zzh(2,2)
      common/thdm/alpha0,beta0,am0,hm10,hm20,hmc0,istat0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/vev/v1,v2
      common/hangle/ca,sa,cb,sb
      common/hpar/hm1,hm2,hs,h
      common/rsl/vlls(6,6,2),init_lls
      common/rsu/vuus(6,6,2),init_uus
      common/rsd/vdds(6,6,2),init_dds
      common/psl/vllp(6,6,2),init_llp
      common/psu/vuup(6,6,2),init_uup
      common/psd/vddp(6,6,2),init_ddp
      common/hud/vudh(6,6,2),init_udh
      common/hhdd/vddhh(6,6,2,2),init_ddhh
      common/hhuu/vuuhh(6,6,2,2),init_uuhh
      common/hsud/vudhs(6,6,2,2),init_udhs
      common/fmass/em(3),um(3),dm(3)
      external init_phys,init_const,init_control
c     Scalar - sfermion vertices should be recalculated after this procedure
      init_lls = .true.
      init_uus = .true.
      init_dds = .true.
      init_llp = .true.
      init_uup = .true.
      init_ddp = .true.
      init_udh = .true.
      init_ddhh = .true.
      init_uuhh = .true.
      init_udhs = .true.
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
c     hdiag variable initialization
      hdiag=.false.
c     Build pseudoscalar and charged Higgs mixing matrix
      zh(1,1) = v2
      zh(2,2) = v2
      zh(1,2) = -v1
      zh(2,1) = v1
      do 10 i=1,2
        do 10 j=1,2
10        zh(i,j)  = zh(i,j)/sqrt(v1*v1+v2*v2)
c     Store sin(beta), cos(beta) in common/hangle/
      sb = zh(1,1)
      cb = zh(2,1)
c     Calculate pseudoscalar and charged Higgs masses
      pm(1) = hm1+hm2+2*abs(h*h)
      cm(1) = pm(1)+wm*wm
c     Goldstone masses (already not squared)
      pm(2) = zm
      cm(2) = wm
c     Calculate pseudoscalar and charged Higgs masses
c     Check if all masses positive
      if (pm(1).le.0.d0) then
        hdiag = .true.
        pm(1) = - sqrt( - pm(1))
c     Next if nested because if cm(1)<0 then always pm(1)<0 and hdiag=tr
        if (cm(1).le.0.d0) then
          cm(1) = - sqrt( - cm(1))
        else
          cm(1) = sqrt(cm(1))
        end if
      else
        pm(1) = sqrt(pm(1))
        cm(1) = sqrt(cm(1))
      end if
c     Build scalar mixing matrix
      a = hm1 + abs(h*h) + e2/8/sct2*(3*v1*v1 - v2*v2)
      b = hm2 + abs(h*h) + e2/8/sct2*(3*v2*v2 - v1*v1)
      c = hs - e2/4/sct2*v1*v2
      x = atan(2*c/(a - b))/2
      if (x.le.0.d0) then
        ca = cos(x)
        sa = sin(x)
      else
        ca = sin(x)
        sa = - cos(x)
      end if
      zr(1,1) = ca
      zr(2,2) = ca
      zr(1,2) = - sa
      zr(2,1) = sa
c     Calculate squared scalar masses.
      rm(1) = a*ca*ca + b*sa*sa + 2*c*sa*ca
      rm(2) = a*sa*sa + b*ca*ca - 2*c*sa*ca
c     Check if scalar masses positive
      do i=1,2
         if (rm(i).le.0) then
            hdiag = .true.
            rm(i) = - sqrt( - rm(i))
         else
            rm(i) = sqrt(rm(i))
         end if
      end do
c     Initialize common/thdm/
      istat0 = 0
      do i=1,2
         cmm(i) = cm(i)
         pmm(i) = pm(i)
         rmm(i) = rm(i)
         do j=1,2
            zzr(i,j) = zr(i,j)
            zzh(i,j) = zh(i,j)
         end do
      end do
      return
      end

      double precision function alpha_eff(nh)
c     Effective alpha calculated from the corrections to h/H self-energy
      implicit double precision (a-h,o-z)
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hangle/ca,sa,cb,sb
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
c     Effective alpha calculated from the corrections to ZZh/H vertex
      sab = sa*cb - sb*ca
      cab = sa*sb + ca*cb
      sabe = dble(sqrt(zs(nh))*(sab - zms(nh,2)*cab))
      cabe = dble(sqrt(zs(nh))*(cab + zms(nh,2)*sab))
      tabe = sabe/cabe
      alpha_eff = atan(tabe) + atan(sb/cb) - pi
      return
      end

      subroutine set_2hdm(alpha,beta,am,hm1,hm2,hmc,istat)
c     Set/reset Higgs sector parameters for 2HDM/MSSM 
c     alpha, beta:   mixing angles
c     am:            pseudoscalar mass
c     hm1,hm2:       H/h masses
c     hmc:           H^+ mass
c     istat defines the required action (istat value is stored in
c     common/2hdm_args/):
c     istat=0    Restores tree level MSSM mixing angles and masses
c                Subroutine mh_diag has to be called first!
c     istat=1    MSSM alpha_eff and 1-loop mh/mH used in FDC approximation
c                Subroutines hm_solve and z_ext has to be called first!
c     istat=2    MSSM alpha_eff and 1-loop mh/mH used in FDC approximation
c                Subroutines corr_EPA or fcorr_EPA has to be called first!
c     istat=3    Sets completely free values of masses and mixing angles.
c                Values of parameters alpha,...,hmc important only in this case
      implicit double precision (a-h,o-z)
      logical init_lls,init_uus,init_dds
      logical init_llp,init_uup,init_ddp
      logical init_ddhh,init_uuhh,init_udh,init_udhs
      logical zzs_stat,zps_stat
      complex*16 vddhh,vuuhh,vudh,vudhs
      complex*16 vuus,vdds,vlls,vuup,vddp,vllp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alp,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/hangle/ca,sa,cb,sb
      common/hmass_mssm/cmm(2),rmm(2),pmm(2),zzr(2,2),zzh(2,2)
      common/thdm/alpha0,beta0,am0,hm10,hm20,hmc0,istat0
      common/hmass_EPA/pme,hm1e,hm2e,sae,cae,sbe,cbe
      common/hm_phys/frm(2),frm2(2)
      common/zzs_stat/zzs_cra,zzs_crb,zzs_cr,ss,nh,zzs_stat
      common/zps_stat/zps_cr,ssa,nha,zps_stat
      common/rsl/vlls(6,6,2),init_lls
      common/rsu/vuus(6,6,2),init_uus
      common/rsd/vdds(6,6,2),init_dds
      common/psl/vllp(6,6,2),init_llp
      common/psu/vuup(6,6,2),init_uup
      common/psd/vddp(6,6,2),init_ddp
      common/hud/vudh(6,6,2),init_udh
      common/hhdd/vddhh(6,6,2,2),init_ddhh
      common/hhuu/vuuhh(6,6,2,2),init_uuhh
      common/hsud/vudhs(6,6,2,2),init_udhs
c     Scalar - sfermion vertices should be recalculated after this procedure
      init_lls = .true.
      init_uus = .true.
      init_dds = .true.
      init_llp = .true.
      init_uup = .true.
      init_ddp = .true.
      init_udh = .true.
      init_ddhh = .true.
      init_uuhh = .true.
      init_udhs = .true.
c     Store parameter values
      alpha0 = alpha
      beta0  = beta
      am0    = am
      hm10   = hm1
      hm20   = hm2
      hmc0   = hmc
      istat0 = istat
c     Cross sections should be recalculated after this procedure
      zzs_stat = .false.
      zps_stat = .false.
      if (istat.eq.0) then
         do i=1,2
            cm(i) = cmm(i)
            pm(i) = pmm(i)
            rm(i) = rmm(i)
            do j=1,2
               zr(i,j) = zzr(i,j)
               zh(i,j) = zzh(i,j)
            end do
         end do
         sa = zr(2,1)
         ca = zr(1,1)
         sb = zh(1,1)
         cb = zh(2,1)
      else if (istat.eq.1) then
         rm(1) = frm(1)
         rm(2) = frm(2)         
         al = alpha_eff(2)
         sa = sin(al)
         ca = cos(al)
         zr(1,1) = ca
         zr(1,2) = - sa
         zr(2,1) = sa
         zr(2,2) = ca
      else if (istat.eq.2) then
         rm(1) = hm1e
         rm(2) = hm2e
         zr(1,1) = cae
         zr(1,2) = - sae
         zr(2,1) = sae
         zr(2,2) = cae
      else if (istat.eq.3) then
         rm(1) = hm1
         rm(2) = hm2
         cm(1) = hmc
         pm(1) = am
         sa = sin(alpha)
         ca = cos(alpha)
         sb = sin(beta)
         cb = cos(beta)
         v1 = 2*wm*st/e*cb 
         v2 = 2*wm*st/e*sb 
         zr(1,1) = ca
         zr(1,2) = - sa
         zr(2,1) = sa
         zr(2,2) = ca
         zh(1,1) = sb
         zh(1,2) = - cb
         zh(2,1) = cb
         zh(2,2) = sb
      else 
         stop 'istat out of range in set_2hdm'
      end if
      return
      end



