c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM 
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek 
c     e-mail: rosiek@fuw.edu.pl 
c             chank@padova.infn.it
 
c     FILENAME: P_GAM.FOR
c     Released: 30:11:1993
c     Last revised: 5.02.1994(J.R.)
c     Decays into sfermions added 
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Evaluation of the widths and branching ratios for the (physical)    c
c     pseudoscalar decay                                                  c
c     function gam_p(gam_arr,br_arr) outputs decay widths and branching   c
c     ratios for the pseudoscalar P_1 = A. The entries of the arrays      c
c     gam_arr and br_arr are described below.                             c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function gam_p(gam_arr,br_arr)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Total decay width of pseudoscalar (gam_p); partial decay    c
c     widths (gam_arr); decay branching ratios (br_arr)           c
c     Decays numeration:                                          c
c     1:      P -> ZZ                                             c
c     2:      P -> Zgamma                                         c
c     3:      P -> gamma + gamma                                  c
c     4-6:    P -> ll                                             c
c     7-9:    P -> uu                                             c
c     10-12:  P -> dd                                             c
c     13:     P -> gg                                             c
c     14-17:  P -> 2 neutralino (identical)                       c
c     18-23:  P -> neutralino + neutralino (not identical)        c
c     24-25:  P -> 2 chargino (identical with opposite charge)    c
c     26:     P -> chargino + chargino (not identical)            c
c             attention: decays into c1+c2- ad c1-c2+ summed      c
c     27:     P -> W+H-,W-H+                                      c
c     28-29:  P -> ZS                                             c
c     30-35:  P -> 2 sleptons (identical)                         c
c     36-50:  P -> slepton + slepton (not identical)              c
c             attention: decays into Li+Lj- and Li-Lj+ summed     c
c     51-56:  P -> 2 up-squarks (identical)                       c
c     57-71:  P -> up-squark + up-squark (not identical)          c
c             attention: decays into Ui+Uj- and Ui-Uj+ summed     c
c     72-78:  P -> 2 down - squarks (identical)                   c
c     79-93:  P -> down-squark + down-squark (not identical)      c
c             attention: decays into Di+Dj- and Di-Dj+ summed     c
c     Three-body decays (very small?) - not included!             c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit double precision (a-h,o-z)
      parameter (max_gam = 93)
      dimension gam_arr(max_gam),br_arr(max_gam)
c     P -> ZZ
      gam_arr(1) = gam_p_zz()
c     P -> Zgamma
      gam_arr(2) = gam_p_fz()
c     P -> 2gamma
      gam_arr(3) = gam_p_ff()
c     P -> ll, P -> uu, P -> dd
      do 10 j=1,3
        gam_arr(j + 3) = gam_p_ll(j)
        gam_arr(j + 6) = gam_p_uu(j)
10      gam_arr(j + 9) = gam_p_dd(j)
c     P -> gg
      gam_arr(13) = gam_p_gg()
c     P -> 2neutralino
      do 20 j=1,4
20      gam_arr(j + 13) = gam_p_nn(j,j)
c     P -> neutralino + neutralino (not identical)
      ind = 17
      do 30 j=1,3
        do 30 k=j+1,4
          ind = ind + 1
30        gam_arr(ind) = 2*gam_p_nn(j,k)
c     P -> 2chargino
      do 40 j=1,2
40      gam_arr(j + 23) = gam_p_cc(j,j)
c     P -> chargino + chargino (not identical)
c          attention: decays into c1+c2- ad c1-c2+ summed
      gam_arr(26) = 2*gam_p_cc(1,2)
c     P -> W+H-,W-H+
      gam_arr(27) = gam_p_wh()
c     P -> ZS
      do 50 j=1,2
50      gam_arr(27 + j) = gam_p_zs(j)
c     P -> LL
      do 60 j=1,6
60      gam_arr(j + 29) = gam_p_sll(j,j)
c     P -> L + L (not identical)
      ind = 35
      do 70 j=1,5
        do 70 k=j+1,6
          ind = ind + 1
70        gam_arr(ind) = 2*gam_p_sll(j,k)
c     P -> UU
      do 80 j=1,6
80      gam_arr(j + 50) = gam_p_suu(j,j)
c     P -> U + U (not identical)
      ind = 56
      do 90 j=1,5
        do 90 k=j+1,6
          ind = ind + 1
90        gam_arr(ind) = 2*gam_p_suu(j,k)
c     P -> DD
      do 100 j=1,6
100     gam_arr(j + 71) = gam_p_sdd(j,j)
c     P -> D + D (not identical)
      ind = 78
      do 110 j=1,5
        do 110 k=j+1,6
          ind = ind + 1
110       gam_arr(ind) = 2*gam_p_sdd(j,k)
c     Total width
      gam_p = 0
      do 1000 j=1,max_gam
1000    gam_p = gam_p + gam_arr(j)
c     Branching ratios
      do 1100 j=1,max_gam
1100    br_arr(j) = gam_arr(j)/gam_p
      return
      end
 
      double precision function gam_p_zz()
c     Width of the decay of pseudoscalar into Z boson pair
      implicit double precision (a-h,o-z)
      complex*16 fgg,fgp,fge
      complex*16 zms,zmp
      complex*16 tmp1(6),tmp2(6)
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      if (pm(1).le.2*zm) then
        gam_p_zz = 0
        return
      end if
      vtmp = vstat
      vstat = .true.
      pm2 = pm(1)*pm(1)
      p = zm2
      q = zm2
      pq = pm2/2 - zm2
      x = pm2/p/2 - 1
      call zzp_vert(p,q,pq,1,tmp1)
      call zzp_vert(p,q,pq,2,tmp2)
      fgg = tmp1(1) + zmp(1,2)*tmp2(1)
      fgp = tmp1(5) + zmp(1,2)*tmp2(5)
      fge = tmp1(6) + zmp(1,2)*tmp2(6)
      am = 3*abs(fgg)**2
     1   + (x*x - 1)*(abs(fgg + zm2*x*fgp)**2 +  2*abs(zm2*fge)**2)
      gam_p_zz = (zz*zz*zp(1))**2/32/pi/pm(1)*sqrt(1 - 4*p/pm2)*am
      vstat = vtmp
      return
      end
 
      double precision function gam_p_fz()
c     Width of the decay of pseudoscalar into Z boson and photon
      implicit double precision (a-h,o-z)
      complex*16 fgg,fge
      complex*16 zms,zmp
      complex*16 tmp1(6),tmp2(6)
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.zm) then
        gam_p_fz = 0
        return
      end if
      vtmp = vstat
      vstat = .true.
      pm2 = pm(1)*pm(1)
      p = zm2
      q = 0.d0
      pq = (pm2 - p)/2
      call fzp_vert(p,q,pq,1,tmp1)
      call fzp_vert(p,q,pq,2,tmp2)
      fgg = tmp1(1) + zmp(1,2)*tmp2(1)
      fge = tmp1(6) + zmp(1,2)*tmp2(6)
      am = abs(fgg)**2 + abs(pq*fge)**2
      gam_p_fz = (1 - p/pm2)/8/pi/pm(1)*(zp(1)*zz)**2*am
      vstat = vtmp
      return
      end
 
      double precision function gam_p_ff()
c     Width of the decay of pseudoscalar into photon pair
      implicit double precision (a-h,o-z)
      complex*16 fgg,fge
      complex*16 zms,zmp
      complex*16 tmp1(6),tmp2(6)
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      vtmp = vstat
      vstat = .true.
      s = pm(1)*pm(1)
      call ffp_on_vert(s,1,tmp1)
      call ffp_on_vert(s,2,tmp2)
      fgg = tmp1(1) + zmp(1,2)*tmp2(1)
      fge = tmp1(6) + zmp(1,2)*tmp2(6)
      am = abs(fgg)**2 + abs(s*fge/2)**2
      gam_p_ff = (zp(1))**2/16/pi/pm(1)*am
      vstat = vtmp
      return
      end
 
      double precision function gam_p_ll(i)
c     Width of the decay of pseudoscalar into lepton pair
c     Corrections to vertex and lepton self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.2*em(i)) then
        gam_p_ll = 0
        return
      end if
      p = em(i)*em(i)
      q = pm(1)*pm(1)
      amp = (zh(1,1) + zmp(1,2)*zh(1,2))*zp(1)
      gam_p_ll = pm(1)/8/pi*p/v1/v1*sqrt(1 - 4*p/q)*abs(amp)**2
      return
      end
 
      double precision function gam_p_dd(i)
c     Width of the decay of pseudoscalar into down quark pair
c     Corrections to vertex and quark self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (i.ne.3) then
c     Stop for attempt of calculation of decay width into dd or ss pair
        gam_p_dd = 0
        return
      end if
c     running quark mass at Q = mh
      qm = runmass(pm(1),dm(i))
      if (pm(1).le.2*qm) then
        gam_p_dd = 0
        return
      end if
      p = qm*qm
      q = pm(1)*pm(1)
      amp = (zh(1,1) + zmp(1,2)*zh(1,2))*zp(1)
      gam_p_dd = 3.d0*pm(1)/8/pi*p/v1/v1*sqrt(1 - 4*p/q)*abs(amp)**2
      gam_p_dd = gam_p_dd*run_gam(qm,pm(1),2)
      return
      end
 
      double precision function gam_p_uu(i)
c     Width of the decay of pseudoscalar into up quark pair
c     Corrections to vertex and quark self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 amp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (i.eq.1) then
c     Stop for attempt of calculation of decay width into uu pair
        gam_p_uu = 0
        return
      end if
c     running quark mass at Q = mh
      qm = runmass(pm(1),um(i))
      if (pm(1).le.2*qm) then
        gam_p_uu = 0
        return
      end if
      p = qm*qm
      q = pm(1)*pm(1)
      amp = (zh(2,1) + zmp(1,2)*zh(2,2))*zp(1)
      gam_p_uu = 3.d0*pm(1)/8/pi*p/v2/v2*sqrt(1 - 4*p/q)*abs(amp)**2
      gam_p_uu = gam_p_uu*run_gam(qm,pm(1),2)
      return
      end
 
      double precision function gam_p_gg()
c     Width of the decay of pseudoscalar into gluon pair
      implicit double precision (a-h,o-z)
      complex*16 fgg,fge
      complex*16 tmp1(6),tmp2(6)
      complex*16 zms,zmp
      logical vstat,fstat,vtmp
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      vtmp = vstat
      vstat = .true.
      s = pm(1)*pm(1)
      call ggp_on_vert(s,1,tmp1)
      call ggp_on_vert(s,2,tmp2)
      fgg = tmp1(1) + zmp(1,2)*tmp2(1)
      fge = tmp1(6) + zmp(1,2)*tmp2(6)
      am = abs(fgg)**2 + abs(s*fge/2)**2
      gam_p_gg = (alfas(pm(1))*zp(1)/pi)**2/8/pi/pm(1)*am
      vstat = vtmp
      return
      end
 
      double precision function gam_p_nn(j,k)
c     Width of the decay of pseudoscalar into neutralino pair
c     Corrections to vertex and neutralino self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 a
      complex*16 v_nnp,zn
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/neut/fnm(4),zn(4,4)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.fnm(j) + fnm(k)) then
        gam_p_nn = 0
        return
      end if
      p1 = fnm(j)*fnm(j)
      p2 = fnm(k)*fnm(k)
      p3 = fnm(j)*fnm(k)
      q = pm(1)*pm(1)
      alam = sqrt(q*q - 2*q*(p1 + p2) + (p1 - p2)**2)
      a = (v_nnp(j,k,1) + zmp(1,2)*v_nnp(j,k,2))*zp(1)
      am = (q - p1 - p2)*abs(a)**2 + 2*p3*dble(a*a)
      gam_p_nn = alam/16/pi/pm(1)**3*e2/4/sct2*am
      return
      end
 
      double precision function gam_p_cc(j,k)
c     Width of the decay of pseudoscalar into chargino pair
c     Corrections to vertex and chargino self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 a,at
      complex*16 v_ccp,zpos,zneg
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.fcm(j) + fcm(k)) then
        gam_p_cc = 0
        return
      end if
      p1 = fcm(j)*fcm(j)
      p2 = fcm(k)*fcm(k)
      p3 = fcm(j)*fcm(k)
      q = pm(1)*pm(1)
      alam = sqrt(q*q - 2*q*(p1 + p2) + (p1 - p2)**2)
      a = (v_ccp(j,k,1) + zmp(1,2)*v_ccp(j,k,2))*zp(1)
      at = (v_ccp(k,j,1) + zmp(1,2)*v_ccp(k,j,2))*zp(1)
      am = (q - p1 - p2)*(abs(a)**2 + abs(at)**2) + 4*p3*dble(a*at)
      gam_p_cc = alam/16/pi/pm(1)**3*e2/2/st2*am
      return
      end
 
      double precision function gam_p_wh()
c     Width of the decay of pseudoscalar into charged Higgs and W boson
c     Corrections to vertex and charged Higgs self energy not included!
      implicit double precision (a-h,o-z)
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.cm(1) + wm) then
        gam_p_wh = 0
        return
      end if
      p = cm(1)*cm(1)
      q = pm(1)*pm(1)
      alam = sqrt(q*q - 2*q*(p + wm2) + (p - wm2)**2)
      gam_p_wh = e2/32/pi*(zp(1)*zw)**2*(alam/pm(1))**3
      return
      end
 
      double precision function gam_p_zs(i)
c     Width of the decay of pseudoscalar into Z boson and scalar
      implicit double precision (a-h,o-z)
      complex*16 bm,zps(2)
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hm_phys/frm(2),frm2(2)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.zm + frm(i)) then
        gam_p_zs = 0
        return
      end if
      p = pm(1)*pm(1)
      q = frm2(i)
      pq = (zm2 - p - q)/2
      alam = sqrt(zm2*zm2 - 2*zm2*(p + q) + (p - q)**2)
      bm = 0
      do 10 k=1,2
        do 10 l=1,2
          kk = i_sup(i,k)
          ll = i_sup(1,l)
          call zps_ren(p,q,pq,kk,ll,zps)
10        bm = bm + (e/sct*am(kk,ll)+ zps(1) + zps(2))*zms(i,k)*zmp(1,l)
      fact = alam**3*(zs(i)*zp(1)*zz)**2/64/pi/zm2/pm(1)**3
      gam_p_zs = fact*abs(bm)**2
      return
      end
 
      double precision function gam_p_sll(j,k)
c     Width of the decay of pseudoscalar into slepton pair
c     Slepton L_j^- incoming, slepton L_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,v_llp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.slm(j) + slm(k)) then
        gam_p_sll = 0
        return
      end if
      p = pm(1)*pm(1)
      q = slm(j)**2
      r = slm(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = alam/16/pi/pm(1)**3*zp(1)**2 
      gam_p_sll = fact*abs(v_llp(j,k,1) + zmp(1,2)*v_llp(j,k,2))**2
      return
      end
 
      double precision function gam_p_sdd(j,k)
c     Width of the decay of scalar into down-squark pair
c     Squark D_j^- incoming, squark D_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,v_ddp
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.sdm(j) + sdm(k)) then
        gam_p_sdd = 0
        return
      end if
      p = pm(1)*pm(1)
      q = sdm(j)**2
      r = sdm(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = 3.d0*alam/16/pi/pm(1)**3*zp(1)**2 
      gam_p_sdd = fact*abs(v_ddp(j,k,1) + zmp(1,2)*v_ddp(j,k,2))**2
      return
      end
 
      double precision function gam_p_suu(j,k)
c     Width of the decay of scalar into up-squark pair
c     Squark U_j^- incoming, squark U_k^- outgoing  
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,v_uup
      complex*16 zms,zmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      if (pm(1).le.sum(j) + sum(k)) then
        gam_p_suu = 0
        return
      end if
      p = pm(1)*pm(1)
      q = sum(j)**2
      r = sum(k)**2
      alam = sqrt(p*p + q*q + r*r - 2*p*q - 2*q*r - 2*r*p)
      fact = 3.d0*alam/16/pi/pm(1)**3*zp(1)**2 
      gam_p_suu = fact*abs(v_uup(j,k,1) + zmp(1,2)*v_uup(j,k,2))**2
      return
      end
 
 
 
 
 
 
 
