c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: P_SELF.FOR
c     Last revised: 15: 02:1993 (PCh)
c     gauge boson contributions adjusted to the DIMENSIONAL
c     REDUCTION regularization

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for pseudoscalar              c
c     self-energy function  and their renormalization.             c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,  c
c     available as hep-ph/9303309.                                 c
c                                                                  c
c     The definition of the self energy as follows:                c
c              ______                                              c
c        k    |      |   k                                         c
c       ------|      |-----             = - i p_sig(k^2,i,j)       c
c       P_i   |______|  P_j         (or = - i p_ren(k^2,i,j)       c
c                             for the renormalized self energy)    c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function p_3sig1(s,i,j)
c     Z + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_3sig1 = 0
      do 10 k=1,2
10      p_3sig1 = p_3sig1 + e2*am(k,i)*am(k,j)/4/sct2*(2*a(zm)
     1          - a(rm(k)) - (2*s + 2*rm(k)*rm(k) - zm2)*b0(s,zm,rm(k)))
      return
      end

      complex*16 function p_3sig2(s,i,j)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/delta/d(6,6)
      p_3sig2 = e2*d(i,j)/2/st2*(2*a(wm) - a(cm(i))
     1        - (2*s + 2*cm(i)*cm(i) - wm2)*b0(s,wm,cm(i)))
      return
      end

      complex*16 function p_3sig34(s,i,j)
c     W-ghost pair + charged Higgs pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/delta/d(6,6)
      p_3sig34 = e2/st2/2*wm2*d(i,j)*b0(s,cm(i),wm)
      return
      end

      complex*16 function p_3sig5(s,i,j)
c     Scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_3sig5 = 0
      do 10 k=1,2
        do 10 l=1,2
10        p_3sig5 = p_3sig5 + e2*e2/16/sct2/sct2*ah(i,k)*ah(j,k)
     1            *br(l)**2*b0(s,pm(k),rm(l))
      return
      end

      complex*16 function p_3sig6(s,i,j)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      p_3sig6 = 0
      do 10 k=1,3
        p_3sig6 = p_3sig6 + 2*em(k)*em(k)/v1/v1*zh(1,i)*zh(1,j)
     1          *(2*a(em(k)) + s*b0(s,em(k),em(k)))
        p_3sig6 = p_3sig6 + 6*um(k)*um(k)/v2/v2*zh(2,i)*zh(2,j)
     1          *(2*a(um(k)) + s*b0(s,um(k),um(k)))
10      p_3sig6 = p_3sig6 + 6*dm(k)*dm(k)/v1/v1*zh(1,i)*zh(1,j)
     1          *(2*a(dm(k)) + s*b0(s,dm(k),dm(k)))
      return
      end

      complex*16 function p_3sig7(s,i,j)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,v_llp,v_uup,v_ddp
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      p_3sig7 = 0
      do 10 k=1,6
        do 10 l=1,6
          p_3sig7 = p_3sig7 - v_llp(k,l,i)*v_llp(l,k,j)
     1             *b0(s,slm(k),slm(l))
          p_3sig7 = p_3sig7 - 3*v_uup(k,l,i)*v_uup(l,k,j)
     1             *b0(s,sum(k),sum(l))
10        p_3sig7 = p_3sig7 - 3*v_ddp(k,l,i)*v_ddp(l,k,j)
     1             *b0(s,sdm(k),sdm(l))
      return
      end

      complex*16 function p_3sig8(s,i,j)
c     Neutralino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zn,v_nnp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      p_3sig8 = 0
      do 10 k=1,4
        do 10 l=1,4
          a1 = v_nnp(k,l,i)*conjg(v_nnp(k,l,j))
     1       + conjg(v_nnp(l,k,i))*v_nnp(l,k,j)
          a2 = v_nnp(k,l,i)*v_nnp(l,k,j)
     1       + conjg(v_nnp(l,k,i)*v_nnp(k,l,j))
10        p_3sig8 = p_3sig8 + e2/8/sct2
     1            *(a1*(a(fnm(l)) + a(fnm(k)) + (s - fnm(k)*fnm(k)
     2            - fnm(l)*fnm(l))*b0(s,fnm(k),fnm(l)))
     3            + 2*a2*fnm(k)*fnm(l)*b0(s,fnm(k),fnm(l)))
      return
      end

      complex*16 function p_3sig9(s,i,j)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zpos,zneg,v_ccp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      p_3sig9 = 0
      do 10 k=1,2
        do 10 l=1,2
          a1 = v_ccp(k,l,i)*conjg(v_ccp(k,l,j))
     1       + conjg(v_ccp(l,k,i))*v_ccp(l,k,j)
          a2 = v_ccp(k,l,i)*v_ccp(l,k,j)
     1       + conjg(v_ccp(l,k,i)*v_ccp(k,l,j))
10        p_3sig9 = p_3sig9 + e2/2/st2
     1            *(a1*(a(fcm(l)) + a(fcm(k)) + (s - fcm(k)*fcm(k)
     2            - fcm(l)*fcm(l))*b0(s,fcm(k),fcm(l)))
     3            + 2*a2*fcm(k)*fcm(l)*b0(s,fcm(k),fcm(l)))
      return
      end

      double precision function p_4sig1(i,j)
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/delta/d(6,6)
      common/dimreg/idflag
      p_4sig1 = - e2/st2*d(i,j)*2*a(wm)
     1         - idflag*e2/st2*d(i,j)*wm2
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      double precision function p_4sig2(i,j)
c     Z in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/delta/d(6,6)
      common/dimreg/idflag
      p_4sig2 = - e2/sct2*d(i,j)*a(zm)
     1        - idflag*e2/sct2*d(i,j)*zm2/2.d0
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      double precision function p_4sig3(i,j)
c     Pseudoscalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_4sig3 = 0
      do 10 k=1,2
10      p_4sig3 = p_4sig3 - e2/8/sct2*v_pppp(i,j,k,k)*a(pm(k))
      return
      end

      double precision function p_4sig4(i,j)
c     Scalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_4sig4 = 0
      do 10 k=1,2
10      p_4sig4 = p_4sig4 - e2/8/sct2*ah(i,j)*ar(k,k)*a(rm(k))
      return
      end

      double precision function p_4sig5(i,j)
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_4sig5 = 0
      do 10 k=1,2
10      p_4sig5 = p_4sig5 - e2/4/st2*v_hhpp(i,j,k,k)*a(cm(k))
      return
      end

      double precision function p_4sig6(i,j)
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 v_llpp,v_uupp,v_ddpp
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      p_4sig6 = 0
c     Sneutrino contribution
      do 10 k=1,3
10      p_4sig6 = p_4sig6 - e2/4/sct2*ah(i,j)*a(vm(k))
c     Other sfermions
      do 20 k=1,6
        p_4sig6 = p_4sig6 + dble(v_llpp(i,j,k,k))*a(slm(k))
        p_4sig6 = p_4sig6 + 3*dble(v_uupp(i,j,k,k))*a(sum(k))
20      p_4sig6 = p_4sig6 + 3*dble(v_ddpp(i,j,k,k))*a(sdm(k))
      return
      end

      complex*16 function p_sig(s,i,j)
c     Full bare pseudoscalar self-energy function
      implicit double precision (a-h,o-z)
      complex*16 p_3sig1,p_3sig2,p_3sig34,p_3sig5,p_3sig6,p_3sig7,
     1           p_3sig8,p_3sig9
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      p_sig = 0
      if (if.eq.1) p_sig = p_sig + p_3sig6(s,i,j)
      if (is.eq.1) p_sig = p_sig + p_3sig7(s,i,j)  + p_4sig6(i,j)
      if (ig.eq.1) p_sig = p_sig + p_3sig1(s,i,j)  + p_3sig2(s,i,j)
     1     + p_3sig34(s,i,j) + p_3sig5(s,i,j)  + p_4sig1(i,j)
     2     + p_4sig2(i,j)    + p_4sig3(i,j)    + p_4sig4(i,j)
     3     + p_4sig5(i,j)
      if (ic.eq.1) p_sig = p_sig + p_3sig9(s,i,j)
      if (in.eq.1) p_sig = p_sig + p_3sig8(s,i,j)
      p_sig = - p_sig/16/pi/pi
      return
      end

      complex*16 function p_ren(s,i,j)
c     Full renormalized pseudoscalar self-energy function
      implicit double precision (a-h,o-z)
      complex*16 h
      complex*16 p_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/vev/v1,v2
      common/hangle/ca,sa,cb,sb
      common/hpar/hm1,hm2,hs,h
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sm1 = hm1 + abs(h*h)
      sm2 = hm2 + abs(h*h)
      if (i*j.eq.1) then
        p_ren = p_sig(s,1,1) - s*(sb*sb*dzh1 + cb*cb*dzh2)
     1        + sb*sb*((sm1*dv1 + hs*dv2 - tt1)/v1
     2        + e2/sct2*(v1*dv1 - v2*dv2)/8)
     3        + cb*cb*((sm2*dv2 + hs*dv1 - tt2)/v2
     4        + e2/sct2*(v2*dv2 - v1*dv1)/8) - dhs/cb/sb
      else if (i*j.eq.2) then
        p_ren = p_sig(s,1,2) - s*sb*cb*(dzh2 - dzh1)
     1        - sb*cb*((sm1*dv1 + hs*dv2 - tt1)/v1
     2        + e2/sct2/8*(v1*dv1 - v2*dv2))
     3        + sb*cb*((sm2*dv2 + hs*dv1 - tt2)/v2
     4        + e2/sct2/8*(v2*dv2 - v1*dv1))
      else if (i*j.eq.4) then
        p_ren = p_sig(s,2,2) - s*(sb*sb*dzh2 + cb*cb*dzh1)
     1        + cb*cb*((sm1*dv1 + hs*dv2 - tt1)/v1
     2        + e2/sct2/8*(v1*dv1 - v2*dv2))
     3        + sb*sb*((sm2*dv2 + hs*dv1 - tt2)/v2
     4        + e2/sct2/8*(v2*dv2 - v1*dv1))
      else
        stop 'p_ren called with wrong arguments'
      end if
      return
      end



